/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities.extra;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class AbilityExplosion {
    public List affectedBlockPositions = new ArrayList();
    private World worldObj;
    private Entity exploder;
    private double explosionX;
    private double explosionY;
    private double explosionZ;
    private double explosionSize;
    private String smokeParticles = "commonExplosion";
    private int explosionGrab = 16;
    private boolean canStartFireAfterExplosion = false;
    private boolean canDestroyBlocks = true;
    private boolean canDropBlocksAfterExplosion = false;
    private boolean canDamageEntities = true;
    private boolean canDamageOwner = true;
    private boolean canProduceExplosionSound = true;

    public AbilityExplosion(Entity entity, double d, double d2, double d3, double d4) {
        this.worldObj = entity.field_70170_p;
        this.exploder = entity;
        this.explosionSize = d4;
        this.explosionX = d;
        this.explosionY = d2;
        this.explosionZ = d3;
    }

    public void setDamageOwner(boolean bl) {
        this.canDamageOwner = bl;
    }

    public void setDamageEntities(boolean bl) {
        this.canDamageEntities = bl;
    }

    public void setDropBlocksAfterExplosion(boolean bl) {
        this.canDropBlocksAfterExplosion = bl;
    }

    public void setFireAfterExplosion(boolean bl) {
        this.canStartFireAfterExplosion = bl;
    }

    public void setDestroyBlocks(boolean bl) {
        this.canDestroyBlocks = bl;
    }

    public void setSmokeParticles(String string) {
        this.smokeParticles = string;
    }

    public boolean hasSmokeParticles() {
        return !this.smokeParticles.isEmpty();
    }

    public void setExplosionSound(boolean bl) {
        this.canProduceExplosionSound = bl;
    }

    public void doExplosion() {
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        int n2;
        HashSet<ChunkPosition> hashSet = new HashSet<ChunkPosition>();
        for (int i = 0; i < this.explosionGrab; ++i) {
            for (int j = 0; j < this.explosionGrab; ++j) {
                for (n2 = 0; n2 < this.explosionGrab; ++n2) {
                    if (i != 0 && i != this.explosionGrab - 1 && j != 0 && j != this.explosionGrab - 1 && n2 != 0 && n2 != this.explosionGrab - 1) continue;
                    double d6 = (float)i / ((float)this.explosionGrab - 1.0f) * 2.0f - 1.0f;
                    double d7 = (float)j / ((float)this.explosionGrab - 1.0f) * 2.0f - 1.0f;
                    double d8 = (float)n2 / ((float)this.explosionGrab - 1.0f) * 2.0f - 1.0f;
                    d5 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8);
                    d6 /= d5;
                    d7 /= d5;
                    d8 /= d5;
                    d4 = this.explosionX;
                    d3 = this.explosionY;
                    d2 = this.explosionZ;
                    float f = 0.3f;
                    for (d = this.explosionSize * ((double)0.7f + this.worldObj.field_73012_v.nextDouble() * (double)0.6f); d > 0.0; d -= (double)(f * 0.75f)) {
                        int n3;
                        int n4;
                        int n5 = MathHelper.func_76128_c((double)d4);
                        Block block = this.worldObj.func_147439_a(n5, n4 = MathHelper.func_76128_c((double)d3), n3 = MathHelper.func_76128_c((double)d2));
                        if (block.func_149688_o() != Material.field_151579_a) {
                            float f2 = (float)((double)block.getExplosionResistance(this.exploder, this.worldObj, n5, n4, n3, this.explosionX, this.explosionY, this.explosionZ) / 1.25);
                            d -= (double)((f2 + 0.1f) * f);
                        }
                        if (d > 0.0) {
                            hashSet.add(new ChunkPosition(n5, n4, n3));
                        }
                        d4 += d6 * (double)f;
                        d3 += d7 * (double)f;
                        d2 += d8 * (double)f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(hashSet);
        if (this.canProduceExplosionSound) {
            this.worldObj.func_72908_a(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (this.canDamageEntities) {
            for (EntityLivingBase entityLivingBase : WyHelper.getEntitiesNear((int)this.explosionX, (int)this.explosionY, (int)this.explosionZ, this.worldObj, this.explosionSize * 1.5, EntityLivingBase.class)) {
                DamageSource damageSource;
                if (!this.canDamageOwner && entityLivingBase == this.exploder) continue;
                d4 = entityLivingBase.field_70165_t - this.explosionX;
                d3 = entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e() - this.explosionY;
                d2 = entityLivingBase.field_70161_v - this.explosionZ;
                Vec3 vec3 = Vec3.func_72443_a((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
                d5 = entityLivingBase.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / this.explosionSize;
                d = this.worldObj.func_72842_a(vec3, entityLivingBase.field_70121_D);
                double d9 = (1.0 - d5) * d;
                float f = (int)((d9 * d9 + d9) / 2.0 * 8.0 * this.explosionSize + 1.0);
                float f3 = 1.0f;
                if (this.exploder instanceof EntityLivingBase) {
                    damageSource = DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this.exploder));
                    f3 = ExtendedEntityData.get((EntityLivingBase)this.exploder).getDamageMultiplier();
                } else {
                    damageSource = DamageSource.field_76376_m;
                }
                entityLivingBase.func_70097_a(this.setExplosionSource(this), f * f3);
            }
        }
        if (this.canDestroyBlocks && MainConfig.enableGriefing) {
            for (ChunkPosition chunkPosition : this.affectedBlockPositions) {
                n2 = chunkPosition.field_151329_a;
                int n6 = chunkPosition.field_151327_b;
                n = chunkPosition.field_151328_c;
                Block block = this.worldObj.func_147439_a(n2, n6, n);
                if (block == null || block.func_149688_o() == Material.field_151579_a) continue;
                block.func_149690_a(this.worldObj, n2, n6, n, this.worldObj.func_72805_g(n2, n6, n), 0.0f, 0);
                this.worldObj.func_147468_f(n2, n6, n);
            }
        }
        if (this.hasSmokeParticles()) {
            WyNetworkHelper.sendToAllAround(new PacketParticles(this.smokeParticles, this.explosionX, this.explosionY, this.explosionZ), this.exploder.field_71093_bK, this.explosionX, this.explosionY, this.explosionZ, 128.0);
        }
        if (this.canStartFireAfterExplosion && MainConfig.enableGriefing) {
            for (ChunkPosition chunkPosition : this.affectedBlockPositions) {
                n2 = chunkPosition.field_151329_a;
                int n7 = chunkPosition.field_151327_b;
                n = chunkPosition.field_151328_c;
                Block block = this.worldObj.func_147439_a(n2, n7, n);
                Block block2 = this.worldObj.func_147439_a(n2, n7 - 1, n);
                if (block.func_149688_o() != Material.field_151579_a || !block2.func_149730_j() || this.worldObj.field_73012_v.nextInt(3) != 0) continue;
                this.worldObj.func_147449_b(n2, n7, n, (Block)Blocks.field_150480_ab);
            }
        }
    }

    public DamageSource setExplosionSource(AbilityExplosion abilityExplosion) {
        return abilityExplosion != null && abilityExplosion.exploder != null ? new EntityDamageSource("explosion.player", abilityExplosion.exploder).func_76351_m().func_94540_d() : new DamageSource("explosion").func_76351_m().func_94540_d();
    }
}

