/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities.extra;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityManager;

public class AbilityProperties
implements IExtendedEntityProperties {
    public static final String EXT_ABILITYPROP_NAME = "mineminenomi_AbilityIEEP";
    private final EntityPlayer thePlayer;
    private Ability[] hotbarAbilities = new Ability[8];
    private Ability[] devilFruitAbilities = new Ability[32];
    private Ability[] racialAbilities = new Ability[32];
    private Ability[] styleAbilities = new Ability[32];
    private Ability[] hakiAbilities = new Ability[16];

    public AbilityProperties(EntityPlayer entityPlayer) {
        this.thePlayer = entityPlayer;
    }

    public static final void register(EntityPlayer entityPlayer) {
        entityPlayer.registerExtendedProperties(EXT_ABILITYPROP_NAME, (IExtendedEntityProperties)new AbilityProperties(entityPlayer));
    }

    public static final AbilityProperties get(EntityPlayer entityPlayer) {
        return (AbilityProperties)entityPlayer.getExtendedProperties(EXT_ABILITYPROP_NAME);
    }

    public void saveNBTData(NBTTagCompound nBTTagCompound) {
        int n;
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        for (n = 0; n < this.hotbarAbilities.length; ++n) {
            if (this.hotbarAbilities[n] == null) continue;
            nBTTagCompound2.func_74782_a("hotbar_ability_" + n, (NBTBase)this.saveNLOBData(this.hotbarAbilities[n]));
        }
        for (n = 0; n < this.devilFruitAbilities.length; ++n) {
            if (this.devilFruitAbilities[n] == null) continue;
            nBTTagCompound2.func_74782_a("devilfruits_ability_" + n, (NBTBase)this.saveNLOBData(this.devilFruitAbilities[n]));
        }
        for (n = 0; n < this.racialAbilities.length; ++n) {
            if (this.racialAbilities[n] == null) continue;
            nBTTagCompound2.func_74782_a("racial_ability_" + n, (NBTBase)this.saveNLOBData(this.racialAbilities[n]));
        }
        for (n = 0; n < this.styleAbilities.length; ++n) {
            if (this.styleAbilities[n] == null) continue;
            nBTTagCompound2.func_74782_a("style_ability_" + n, (NBTBase)this.saveNLOBData(this.styleAbilities[n]));
        }
        for (n = 0; n < this.hakiAbilities.length; ++n) {
            if (this.hakiAbilities[n] == null) continue;
            nBTTagCompound2.func_74782_a("haki_ability_" + n, (NBTBase)this.saveNLOBData(this.hakiAbilities[n]));
        }
        nBTTagCompound.func_74782_a(EXT_ABILITYPROP_NAME, (NBTBase)nBTTagCompound2);
    }

    private NBTTagCompound saveNLOBData(Ability ability) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("name", ability.getAttribute().getAttributeName());
        nBTTagCompound.func_74757_a("isOnCooldown", ability.isOnCooldown());
        nBTTagCompound.func_74757_a("isCharging", ability.isCharging());
        nBTTagCompound.func_74757_a("isPassiveActive", ability.isPassiveActive());
        return nBTTagCompound;
    }

    public void loadNBTData(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagCompound.func_74781_a(EXT_ABILITYPROP_NAME);
        try {
            int n;
            for (n = 0; n < this.hotbarAbilities.length; ++n) {
                this.hotbarAbilities[n] = this.loadAbilityFromNLOB((NBTTagCompound)nBTTagCompound2.func_74781_a("hotbar_ability_" + n));
            }
            for (n = 0; n < this.devilFruitAbilities.length; ++n) {
                this.devilFruitAbilities[n] = this.loadAbilityFromNLOB((NBTTagCompound)nBTTagCompound2.func_74781_a("devilfruits_ability_" + n));
            }
            for (n = 0; n < this.racialAbilities.length; ++n) {
                this.racialAbilities[n] = this.loadAbilityFromNLOB((NBTTagCompound)nBTTagCompound2.func_74781_a("racial_ability_" + n));
            }
            for (n = 0; n < this.styleAbilities.length; ++n) {
                this.styleAbilities[n] = this.loadAbilityFromNLOB((NBTTagCompound)nBTTagCompound2.func_74781_a("style_ability_" + n));
            }
            for (n = 0; n < this.hakiAbilities.length; ++n) {
                this.hakiAbilities[n] = this.loadAbilityFromNLOB((NBTTagCompound)nBTTagCompound2.func_74781_a("haki_ability_" + n));
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().log(Level.SEVERE, "Ability is not registered correctly or could not be found in the master list !");
            exception.printStackTrace();
        }
    }

    private Ability loadAbilityFromNLOB(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound == null) {
            return null;
        }
        String string = nBTTagCompound.func_74779_i("name");
        Ability ability = null;
        try {
            if (AbilityManager.instance().getAbilityByName(WyHelper.getFancyName(string)) != null) {
                ability = (Ability)AbilityManager.instance().getAbilityByName(WyHelper.getFancyName(string)).getClass().newInstance();
                ability.setCooldownActive(nBTTagCompound.func_74767_n("isOnCooldown"));
                ability.setChargeActive(nBTTagCompound.func_74767_n("isCharging"));
                ability.setPassiveActive(nBTTagCompound.func_74767_n("isPassiveActive"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return ability;
    }

    public void init(Entity entity, World world) {
    }

    public boolean addDevilFruitAbility(Ability ability) {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] != null || this.hasDevilFruitAbility(ability)) continue;
            this.devilFruitAbilities[i] = ability;
            return true;
        }
        return false;
    }

    public void removeDevilFruitAbility(Ability ability) {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] == null || !this.devilFruitAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ability.getAttribute().getAttributeName())) continue;
            this.devilFruitAbilities[i] = null;
            break;
        }
    }

    public boolean hasDevilFruitAbility(Ability ability) {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] == null || !this.devilFruitAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ability.getAttribute().getAttributeName())) continue;
            return true;
        }
        return false;
    }

    public Ability[] getDevilFruitAbilities() {
        return this.devilFruitAbilities;
    }

    public void clearDevilFruitAbilities() {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] == null) continue;
            this.devilFruitAbilities[i] = null;
        }
    }

    public boolean addRacialAbility(Ability ability) {
        for (int i = 0; i < this.racialAbilities.length; ++i) {
            if (this.racialAbilities[i] != null || this.hasRacialAbility(ability)) continue;
            this.racialAbilities[i] = ability;
            return true;
        }
        return false;
    }

    public void removeRacialAbility(Ability ability) {
        for (int i = 0; i < this.racialAbilities.length; ++i) {
            if (this.racialAbilities[i] == null || !this.racialAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ability.getAttribute().getAttributeName())) continue;
            this.racialAbilities[i] = null;
            break;
        }
    }

    public boolean hasRacialAbility(Ability ability) {
        if (ability != null) {
            for (int i = 0; i < this.racialAbilities.length; ++i) {
                if (this.racialAbilities[i] == null || !this.racialAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ability.getAttribute().getAttributeName())) continue;
                return true;
            }
        }
        return false;
    }

    public Ability[] getRacialAbilities() {
        return this.racialAbilities;
    }

    public void clearRacialAbilities() {
        for (int i = 0; i < this.racialAbilities.length; ++i) {
            if (this.racialAbilities[i] == null) continue;
            this.racialAbilities[i] = null;
        }
    }

    public boolean addHakiAbility(Ability ability) {
        for (int i = 0; i < this.hakiAbilities.length; ++i) {
            if (this.hakiAbilities[i] != null || this.hasHakiAbility(ability)) continue;
            this.hakiAbilities[i] = ability;
            return true;
        }
        return false;
    }

    public void removeHakiAbility(Ability ability) {
        for (int i = 0; i < this.hakiAbilities.length; ++i) {
            if (this.hakiAbilities[i] == null || !this.hakiAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ability.getAttribute().getAttributeName())) continue;
            this.hakiAbilities[i] = null;
            break;
        }
    }

    public boolean hasHakiAbility(Ability ability) {
        return Arrays.stream(this.hakiAbilities).filter(ability2 -> ability2 != null && ability2.getAttribute().getAttributeName().equalsIgnoreCase(ability.getAttribute().getAttributeName())).findFirst().orElse(null) != null;
    }

    public Ability[] getHakiAbilities() {
        return this.hakiAbilities;
    }

    public void clearHakiAbilities() {
        for (int i = 0; i < this.hakiAbilities.length; ++i) {
            if (this.hakiAbilities[i] == null) continue;
            this.hakiAbilities[i] = null;
        }
    }

    public Ability[] getAbilitiesInHotbar() {
        return this.hotbarAbilities;
    }

    public boolean hasAbilityInHotbar(Ability ability) {
        return this.hasAbilityInHotbar(ability.getAttribute().getAttributeName());
    }

    public boolean hasAbilityInHotbar(String string) {
        return Arrays.stream(this.hotbarAbilities).filter(ability -> ability != null && ability.getAttribute().getAttributeName().equalsIgnoreCase(string)).findFirst().orElse(null) != null;
    }

    public void setAbilityInSlot(int n, Ability ability) {
        this.hotbarAbilities[n] = ability;
    }

    public Ability getAbilityFromSlot(int n) {
        return this.hotbarAbilities[n];
    }

    public Ability getAbilityFromName(String string) {
        return Arrays.stream(this.getAbilitiesInHotbar()).filter(ability -> ability != null && ability.getAttribute() != null && ability.getAttribute().getAttributeName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public int countAbilitiesInHotbar() {
        return this.hotbarAbilities.length;
    }

    public void clearHotbar() {
        for (int i = 0; i < this.hotbarAbilities.length; ++i) {
            if (this.hotbarAbilities[i] == null) continue;
            if (this.hotbarAbilities[i].isPassiveActive()) {
                this.hotbarAbilities[i].endPassive(this.thePlayer);
            }
            this.hotbarAbilities[i] = null;
        }
    }
}

