/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.helpers;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.abilities.CyborgAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.FishKarateAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.HakiAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.RokushikiAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.SniperAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.SwordsmanAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.WeatherAbilities;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.AbilityAttribute;
import xyz.pixelatedw.MineMineNoMi3.items.AkumaNoMi;

public class WebAppHelper {
    public static void generateWebAppJSONs() {
        WebAppHelper.writeFancyAbilitiesList();
        File file = new File(Values.RESOURCES_FOLDER + "/assets/" + "mineminenomi" + "/EXTRA_BOT_FILES/");
        file.mkdirs();
        if (file.exists()) {
            WebAppHelper.writeDevilFruitsJSON();
            WebAppHelper.writeSpecialAbilitiesJSON();
        }
    }

    private static void writeDevilFruitsJSON() {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Values.RESOURCES_FOLDER + "/assets/" + "mineminenomi" + "/EXTRA_BOT_FILES/devilfruits.json"), "UTF-8"));){
            bufferedWriter.write("{\n");
            bufferedWriter.write("\"devilfruits\" : [");
            for (Item item : Values.devilfruits) {
                AkumaNoMi akumaNoMi = (AkumaNoMi)item;
                ItemStack itemStack = new ItemStack(GameRegistry.findItem((String)"mineminenomi", (String)akumaNoMi.func_77658_a().substring(5)));
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("name", "\"" + itemStack.func_82833_r() + "\"");
                linkedHashMap.put("type", "\"" + akumaNoMi.getType().getName() + "\"");
                linkedHashMap.put("abilities", "[ " + WebAppHelper.generateAbilitiesString(akumaNoMi.abilities) + " ]");
                bufferedWriter.write("{ ");
                for (String string : linkedHashMap.keySet()) {
                    Object v = linkedHashMap.get(string);
                    if (!(v instanceof String)) continue;
                    bufferedWriter.write("\"" + string + "\": " + v + ", ");
                }
                bufferedWriter.write("},\n");
            }
            bufferedWriter.write("]}");
            ((Writer)bufferedWriter).close();
        }
        catch (Exception exception) {
            exception.getStackTrace();
        }
    }

    private static void writeSpecialAbilitiesJSON() {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Values.RESOURCES_FOLDER + "/assets/" + "mineminenomi" + "/EXTRA_BOT_FILES/specialabilities.json"), "UTF-8"));){
            bufferedWriter.write("{\n");
            bufferedWriter.write("\"specialabilities\" : [");
            Ability[] abilityArray = (Ability[])Stream.of(RokushikiAbilities.abilitiesArray, HakiAbilities.abilitiesArray).flatMap(Stream::of).toArray(Ability[]::new);
            bufferedWriter.write("{ \"name\": \"Human\", \"type\": \"n/a\", \"abilities\": [ " + WebAppHelper.generateAbilitiesString(abilityArray) + " ]},\n");
            Ability[] abilityArray2 = (Ability[])Stream.of(FishKarateAbilities.abilitiesArray, HakiAbilities.abilitiesArray).flatMap(Stream::of).toArray(Ability[]::new);
            bufferedWriter.write("{ \"name\": \"Fishman\", \"type\": \"n/a\", \"abilities\": [ " + WebAppHelper.generateAbilitiesString(abilityArray2) + " ]},\n");
            Ability[] abilityArray3 = (Ability[])Stream.of(CyborgAbilities.abilitiesArray, HakiAbilities.abilitiesArray).flatMap(Stream::of).toArray(Ability[]::new);
            bufferedWriter.write("{ \"name\": \"Cyborg\", \"type\": \"n/a\", \"abilities\": [ " + WebAppHelper.generateAbilitiesString(abilityArray3) + " ]},\n");
            bufferedWriter.write("{ \"name\": \"Swordsman\", \"type\": \"n/a\", \"abilities\": [ " + WebAppHelper.generateAbilitiesString(SwordsmanAbilities.abilitiesArray) + " ]},\n");
            bufferedWriter.write("{ \"name\": \"Sniper\", \"type\": \"n/a\", \"abilities\": [ " + WebAppHelper.generateAbilitiesString(SniperAbilities.abilitiesArray) + " ]},\n");
            bufferedWriter.write("{ \"name\": \"Art of Weather\", \"type\": \"n/a\", \"abilities\": [ " + WebAppHelper.generateAbilitiesString(WeatherAbilities.abilitiesArray) + " ]},\n");
            bufferedWriter.write("]}");
            ((Writer)bufferedWriter).close();
        }
        catch (Exception exception) {
            exception.getStackTrace();
        }
    }

    private static void writeFancyAbilitiesList() {
        File file = new File(Values.RESOURCES_FOLDER + "/assets/" + "mineminenomi" + "/EXTRA_BOT_FILES/");
        file.mkdirs();
        if (file.exists()) {
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Values.RESOURCES_FOLDER + "/assets/" + "mineminenomi" + "/EXTRA_BOT_FILES/fancylist.txt"), "UTF-8"));){
                for (AkumaNoMi akumaNoMi : Values.devilfruits) {
                    bufferedWriter.write(akumaNoMi.func_77653_i(new ItemStack((Item)akumaNoMi)) + "\n");
                    for (Ability ability : akumaNoMi.abilities) {
                        bufferedWriter.write("> " + ability.getAttribute().getAbilityDisplayName() + "\n");
                    }
                    bufferedWriter.write("\n");
                }
            }
            catch (Exception exception) {
                exception.getStackTrace();
            }
        }
    }

    private static String generateAbilitiesString(Ability[] abilityArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Ability ability : abilityArray) {
            Object object;
            boolean bl = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("{ ");
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            AbilityAttribute abilityAttribute = ability.getAttribute();
            linkedHashMap.put("name", abilityAttribute.getAbilityDisplayName());
            linkedHashMap.put("texture", WyHelper.getFancyName(abilityAttribute.getAbilityTexture()));
            if (abilityAttribute.getAbilityCooldown() > 0) {
                linkedHashMap.put("cooldown", abilityAttribute.getAbilityCooldown() / 20);
            }
            if (abilityAttribute.getAbilityCharges() > 0) {
                linkedHashMap.put("chargeTime", abilityAttribute.getAbilityCharges() / 20);
            }
            if (abilityAttribute.getProjectileDamage() > 1.0f) {
                linkedHashMap.put("projectileDamage", Float.valueOf(abilityAttribute.getProjectileDamage()));
            }
            if (abilityAttribute.hasProjectile() && abilityAttribute.isRepeater()) {
                linkedHashMap.put("projectileNumber", abilityAttribute.getAbilityCooldown() / abilityAttribute.getAbilityRepeaterTime() / abilityAttribute.getAbilityRepeaterTime());
            }
            if (abilityAttribute.getProjectileExplosionPower() > 0) {
                linkedHashMap.put("projectileExplosion", abilityAttribute.getProjectileExplosionPower());
            }
            if (abilityAttribute.getPotionEffectsForAoE() != null && abilityAttribute.getPotionEffectsForAoE().length > 0) {
                linkedHashMap.put("aoeEffects", "[" + WebAppHelper.getPotionEffectsFor(abilityAttribute.getPotionEffectsForAoE()) + "]");
            }
            if (abilityAttribute.getPotionEffectsForProjectile() != null && abilityAttribute.getPotionEffectsForProjectile().length > 0) {
                linkedHashMap.put("onHitEffects", "[" + WebAppHelper.getPotionEffectsFor(abilityAttribute.getPotionEffectsForProjectile()) + "]");
            }
            if (abilityAttribute.getPotionEffectsForUser() != null && abilityAttribute.getPotionEffectsForUser().length > 0) {
                linkedHashMap.put("selfEffects", "[" + WebAppHelper.getPotionEffectsFor(abilityAttribute.getPotionEffectsForUser()) + "]");
            }
            for (String string : Values.abilityWebAppExtraParams.keySet()) {
                if (!WyHelper.getFancyName(abilityAttribute.getAttributeName()).equalsIgnoreCase(string)) continue;
                object = (String[])Values.abilityWebAppExtraParams.get(string);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string2 = object[i];
                    Object object2 = object[++i];
                    if (string2.equalsIgnoreCase("desc")) {
                        bl = true;
                    }
                    try {
                        object2 = Integer.parseInt((String)object2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (linkedHashMap.containsKey(string2)) {
                        linkedHashMap.replace(string2, object2);
                        continue;
                    }
                    linkedHashMap.put(string2, object2);
                }
            }
            for (String string : linkedHashMap.keySet()) {
                object = linkedHashMap.get(string);
                if (object instanceof Integer || object instanceof Double || object instanceof Float || string.equalsIgnoreCase("aoeEffects") || string.equalsIgnoreCase("onHitEffects") || string.equalsIgnoreCase("selfEffects")) {
                    stringBuilder2.append("\"" + string + "\": " + object + ",");
                    continue;
                }
                if (!(linkedHashMap.get(string) instanceof String)) continue;
                stringBuilder2.append("\"" + string + "\": \"" + object + "\",");
            }
            stringBuilder2.append("},");
            stringBuilder.append(stringBuilder2.toString());
            if (bl) continue;
            System.out.println("Ability without description : " + ability.getAttribute().getAbilityDisplayName());
        }
        return stringBuilder.toString();
    }

    private static String getPotionEffectsFor(PotionEffect[] potionEffectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < potionEffectArray.length; ++i) {
            double d = Math.ceil((double)potionEffectArray[i].func_76459_b() / 24.0);
            if (i < potionEffectArray.length - 1) {
                stringBuilder.append("\"" + I18n.func_135052_a((String)potionEffectArray[i].func_76453_d(), (Object[])new Object[0]) + " " + String.format("%.0f", d) + " " + (d == 1.0 ? "second" : "seconds") + " (" + (potionEffectArray[i].func_76458_c() > 0 ? "+" : "-") + ")\", ");
                continue;
            }
            stringBuilder.append("\"" + I18n.func_135052_a((String)potionEffectArray[i].func_76453_d(), (Object[])new Object[0]) + " " + String.format("%.0f", d) + " " + (d == 1.0 ? "second" : "seconds") + " (" + (potionEffectArray[i].func_76458_c() > 0 ? "+" : "-") + ")\"");
        }
        String string = stringBuilder.toString();
        return string;
    }
}

