/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper$1;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper$2;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper$3;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper$Direction;
import xyz.pixelatedw.MineMineNoMi3.api.WyRegistry;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityExplosion;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;

public class WyHelper {
    public static AxisAlignedBB NULL_AABB = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public static EntityLivingBase getEntityByUUID(World world, UUID uUID) {
        List list = world.field_72996_f.stream().filter(object -> object instanceof EntityLivingBase).collect(Collectors.toList());
        for (EntityLivingBase entityLivingBase : list) {
            if (!entityLivingBase.func_110124_au().equals(uUID)) continue;
            return entityLivingBase;
        }
        return null;
    }

    public static boolean afterDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Calendar calendar = null;
        try {
            calendar = Calendar.getInstance();
            calendar.setTime(simpleDateFormat.parse(string));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return false;
        }
        Calendar calendar2 = Calendar.getInstance();
        return calendar2.after(calendar);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static AbilityExplosion newExplosion(Entity entity, double d, double d2, double d3, double d4) {
        AbilityExplosion abilityExplosion = new AbilityExplosion(entity, d, d2, d3, d4);
        return abilityExplosion;
    }

    public static void doExplosion(Entity entity, double d, double d2, double d3, double d4) {
        AbilityExplosion abilityExplosion = new AbilityExplosion(entity, d, d2, d3, d4);
        abilityExplosion.doExplosion();
    }

    public static boolean isBlockNearby(EntityLivingBase entityLivingBase, int n, Block ... blockArray) {
        for (Block block : blockArray) {
            for (int i = -n; i < n; ++i) {
                for (int j = -n; j < n; ++j) {
                    for (int k = -n; k < n; ++k) {
                        if (entityLivingBase.field_70170_p.func_147439_a((int)entityLivingBase.field_70165_t + i, (int)entityLivingBase.field_70163_u + j, (int)entityLivingBase.field_70161_v + k) != block) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Block getBlockNearby(EntityLivingBase entityLivingBase, int n, Block block) {
        for (int i = -n; i < n; ++i) {
            for (int j = -n; j < n; ++j) {
                for (int k = -n; k < n; ++k) {
                    if (entityLivingBase.field_70170_p.func_147439_a((int)entityLivingBase.field_70165_t + i, (int)entityLivingBase.field_70163_u + j, (int)entityLivingBase.field_70161_v + k) != block) continue;
                    return entityLivingBase.field_70170_p.func_147439_a((int)entityLivingBase.field_70165_t + i, (int)entityLivingBase.field_70163_u + j, (int)entityLivingBase.field_70161_v + k);
                }
            }
        }
        return null;
    }

    public static List getBlockLocationsNearby(EntityLivingBase entityLivingBase, int[] nArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = -nArray[0]; i < nArray[0]; ++i) {
            for (int j = -nArray[1]; j < nArray[1]; ++j) {
                for (int k = -nArray[2]; k < nArray[2]; ++k) {
                    arrayList.add(new int[]{(int)entityLivingBase.field_70165_t + i, (int)entityLivingBase.field_70163_u + j, (int)entityLivingBase.field_70161_v + k});
                }
            }
        }
        return arrayList;
    }

    public static List getBlockLocationsNearby(EntityLivingBase entityLivingBase, int n) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = -n; i < n; ++i) {
            for (int j = -n; j < n; ++j) {
                for (int k = -n; k < n; ++k) {
                    arrayList.add(new int[]{(int)entityLivingBase.field_70165_t + i, (int)entityLivingBase.field_70163_u + j, (int)entityLivingBase.field_70161_v + k});
                }
            }
        }
        return arrayList;
    }

    public static Map sortAlphabetically(Map map) {
        LinkedList linkedList = new LinkedList(map.entrySet());
        Collections.sort(linkedList, new WyHelper$1());
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    public static void generateLangFiles() {
        Map map = WyHelper.sortAlphabetically(WyRegistry.getLangMap());
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        Map.Entry entry = null;
        File file = new File(Values.RESOURCES_FOLDER + "/assets/" + "mineminenomi" + "/lang/");
        file.mkdirs();
        if (file.exists()) {
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Values.RESOURCES_FOLDER + "/assets/" + "mineminenomi" + "/lang/en_US.lang"), "UTF-8"));){
                while (iterator.hasNext()) {
                    Map.Entry entry2 = iterator.next();
                    if (entry != null && !((String)entry.getKey()).substring(0, 2).equals(((String)entry2.getKey()).substring(0, 2))) {
                        bufferedWriter.write("\n");
                    }
                    bufferedWriter.write(entry2.getKey() + "=" + entry2.getValue() + "\n");
                    entry = entry2;
                }
                ((Writer)bufferedWriter).close();
            }
            catch (Exception exception) {
                exception.getStackTrace();
            }
        }
    }

    public static void setEntityFlag(Entity entity, int n, boolean bl) {
        byte by = entity.func_70096_w().func_75683_a(0);
        if (bl) {
            entity.func_70096_w().func_75692_b(0, (Object)((byte)(by | 1 << n)));
        } else {
            entity.func_70096_w().func_75692_b(0, (Object)((byte)(by & ~(1 << n))));
        }
    }

    public static Color hslToColor(float f, float f2, float f3) {
        float[] fArray = new float[]{f, f2, f3};
        if (f2 < 0.0f || f2 > 100.0f) {
            String string = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(string);
        }
        if (f3 < 0.0f || f3 > 100.0f) {
            String string = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(string);
        }
        f %= 360.0f;
        float f4 = 0.0f;
        f4 = (double)f3 < 0.5 ? f3 * (1.0f + f2) : (f3 /= 100.0f) + (f2 /= 100.0f) - f2 * f3;
        float f5 = 2.0f * f3 - f4;
        float f6 = Math.max(0.0f, WyHelper.hueToRGB(f5, f4, (f /= 360.0f) + 0.33333334f));
        float f7 = Math.max(0.0f, WyHelper.hueToRGB(f5, f4, f));
        float f8 = Math.max(0.0f, WyHelper.hueToRGB(f5, f4, f - 0.33333334f));
        f6 = Math.min(f6, 1.0f);
        f7 = Math.min(f7, 1.0f);
        f8 = Math.min(f8, 1.0f);
        return new Color(f6, f7, f8);
    }

    private static float hueToRGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * 6.0f * (0.6666667f - f3);
        }
        return f;
    }

    public static Color hexToRGB(String string) {
        if (string.startsWith("#")) {
            return Color.decode(string);
        }
        return Color.decode("#" + string);
    }

    public static String formatBytes(long l) {
        int n = 1024;
        if (l < (long)n) {
            return l + " B";
        }
        int n2 = (int)(Math.log(l) / Math.log(n));
        String string = "KMGTPE".charAt(n2 - 1) + "";
        return String.format("%.1f %sB", (double)l / Math.pow(n, n2), string);
    }

    public static void sendMsgToPlayer(EntityPlayer entityPlayer, String string) {
        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(string));
    }

    public static String upperCaseFirst(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1) + " ";
    }

    public static String getFancyName(String string) {
        return string.replaceAll("\\s+", "").toLowerCase().replaceAll("'", "").replaceAll("-", "").replaceAll(":", "").replaceAll("#", "").replace(",", "");
    }

    public static String getFancyNameNoLowerCase(String string) {
        return string.replaceAll("\\s+", "").replaceAll("'", "").replaceAll("-", "").replaceAll(":", "").replaceAll("#", "").replace(",", "");
    }

    public static List getEntitiesNear(int n, int n2, int n3, World world, double d) {
        return WyHelper.getEntitiesNear(n, n2, n3, world, d, EntityLivingBase.class);
    }

    public static List getEntitiesNear(int n, int n2, int n3, World world, double d, Class clazz) {
        AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)n, (double)n2, (double)n3, (double)(n + 1), (double)(n2 + 1), (double)(n3 + 1)).func_72314_b(d, d, d);
        List list = world.func_72872_a(clazz, axisAlignedBB);
        return list;
    }

    public static List getEntitiesNear(Entity entity, double d) {
        return WyHelper.getEntitiesNear(entity, d, EntityLivingBase.class);
    }

    public static List getEntitiesNear(Entity entity, double d, Class ... classArray) {
        try {
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)(entity.field_70165_t + 1.0), (double)(entity.field_70163_u + 1.0), (double)(entity.field_70161_v + 1.0)).func_72314_b(d, d, d);
            ArrayList arrayList = new ArrayList();
            for (Class clazz : classArray) {
                arrayList.addAll(entity.field_70170_p.func_72872_a(clazz, axisAlignedBB));
            }
            arrayList.remove(entity);
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List getEntitiesNear(Entity entity, double[] dArray, Class ... classArray) {
        try {
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)(entity.field_70165_t + 1.0), (double)(entity.field_70163_u + 1.0), (double)(entity.field_70161_v + 1.0)).func_72314_b(dArray[0], dArray[1], dArray[2]);
            ArrayList arrayList = new ArrayList();
            for (Class clazz : classArray) {
                arrayList.addAll(entity.field_70170_p.func_72872_a(clazz, axisAlignedBB));
            }
            arrayList.remove(entity);
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List getEntitiesNear(TileEntity tileEntity, double d) {
        return WyHelper.getEntitiesNear(tileEntity, d, EntityLivingBase.class);
    }

    public static List getEntitiesNear(TileEntity tileEntity, double d, Class clazz) {
        AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)tileEntity.field_145851_c, (double)tileEntity.field_145848_d, (double)tileEntity.field_145849_e, (double)(tileEntity.field_145851_c + 1), (double)(tileEntity.field_145848_d + 1), (double)(tileEntity.field_145849_e + 1)).func_72314_b(d, d, d);
        List list = tileEntity.func_145831_w().func_72872_a(clazz, axisAlignedBB);
        return list;
    }

    public static WyHelper$Direction get4Directions(Entity entity) {
        switch (MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
            case 0: {
                return WyHelper$Direction.SOUTH;
            }
            case 1: {
                return WyHelper$Direction.WEST;
            }
            case 2: {
                return WyHelper$Direction.NORTH;
            }
            case 3: {
                return WyHelper$Direction.EAST;
            }
        }
        return null;
    }

    public static WyHelper$Direction get8Directions(Entity entity) {
        switch (MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7) {
            case 0: {
                return WyHelper$Direction.SOUTH;
            }
            case 1: {
                return WyHelper$Direction.SOUTH_WEST;
            }
            case 2: {
                return WyHelper$Direction.WEST;
            }
            case 3: {
                return WyHelper$Direction.NORTH_WEST;
            }
            case 4: {
                return WyHelper$Direction.NORTH;
            }
            case 5: {
                return WyHelper$Direction.NORTH_EAST;
            }
            case 6: {
                return WyHelper$Direction.EAST;
            }
            case 7: {
                return WyHelper$Direction.SOUTH_EAST;
            }
        }
        return null;
    }

    public static MovingObjectPosition rayTraceBlocks(Entity entity) {
        float f = 1.0f;
        float f2 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * f;
        float f3 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * f;
        double d = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)f;
        double d2 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)f + 1.62 - entity.func_70033_W();
        double d3 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d, (double)d2, (double)d3);
        float f4 = MathHelper.func_76134_b((float)(-f3 * 0.01745329f - 3.141593f));
        float f5 = MathHelper.func_76126_a((float)(-f3 * 0.01745329f - 3.141593f));
        float f6 = -MathHelper.func_76134_b((float)(-f2 * 0.01745329f));
        float f7 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f));
        float f8 = f5 * f6;
        float f9 = f4 * f6;
        double d4 = 5000.0;
        Vec3 vec32 = vec3.func_72441_c((double)f8 * d4, (double)f7 * d4, (double)f9 * d4);
        MovingObjectPosition movingObjectPosition = entity.field_70170_p.func_72901_a(vec3, vec32, false);
        return movingObjectPosition;
    }

    public static List createEmptyCube(Entity entity, int[] nArray, Block block, String ... stringArray) {
        return WyHelper.createEmptyCube(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, nArray, block, stringArray);
    }

    public static List createEmptyCube(World world, double d, double d2, double d3, int[] nArray, Block block, String ... stringArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = nArray[0] * 0 - nArray[0]; i <= nArray[0]; ++i) {
            for (int j = nArray[1] * 0 - nArray[1]; j <= nArray[1]; ++j) {
                for (int k = nArray[2] * 0 - nArray[2]; k <= nArray[2]; ++k) {
                    if (i != -nArray[0] && i != nArray[0] && j != -nArray[1] && j != nArray[1] && k != -nArray[2] && k != nArray[2]) continue;
                    DevilFruitsHelper.placeBlockIfAllowed(world, (int)d + i, (int)d2 + j, (int)d3 + k, block, stringArray);
                    arrayList.add(new int[]{(int)d + i, (int)d2 + j, (int)d3 + k});
                }
            }
        }
        return arrayList;
    }

    public static List createFilledCube(Entity entity, int[] nArray, Block block, String ... stringArray) {
        return WyHelper.createFilledCube(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, nArray, block, stringArray);
    }

    public static List createFilledCube(World world, double d, double d2, double d3, int[] nArray, Block block, String ... stringArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = nArray[0] * 0 - nArray[0]; i <= nArray[0]; ++i) {
            for (int j = nArray[1] * 0 - nArray[1]; j <= nArray[1]; ++j) {
                for (int k = nArray[2] * 0 - nArray[2]; k <= nArray[2]; ++k) {
                    DevilFruitsHelper.placeBlockIfAllowed(world, (int)d + i, (int)d2 + j, (int)d3 + k, block, stringArray);
                    arrayList.add(new int[]{(int)d + i, (int)d2 + j, (int)d3 + k});
                }
            }
        }
        return arrayList;
    }

    public static List createEmptySphere(World world, int n, int n2, int n3, int n4, Block block, String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        try {
            WyHelper$2 wyHelper$2 = new WyHelper$2("Sphere Generator", n, n2, n3, n4, world, block, stringArray, arrayList);
            wyHelper$2.start();
            wyHelper$2.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return arrayList;
    }

    public static List createFilledSphere(World world, int n, int n2, int n3, int n4, Block block, String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        try {
            WyHelper$3 wyHelper$3 = new WyHelper$3("Sphere Generator", n, n2, n3, n4, world, block, stringArray, arrayList);
            wyHelper$3.start();
            wyHelper$3.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return arrayList;
    }

    public static void removeStackFromArmorSlots(EntityPlayer entityPlayer, ItemStack itemStack) {
        int n;
        for (int i = n = entityPlayer.field_71071_by.field_70462_a.length; i < n + entityPlayer.field_71071_by.field_70460_b.length; ++i) {
            if (itemStack != entityPlayer.field_71071_by.func_70301_a(i)) continue;
            entityPlayer.field_71071_by.func_70299_a(i, null);
            break;
        }
    }

    public static void removeStackFromInventory(EntityPlayer entityPlayer, ItemStack itemStack) {
        for (int i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
            if (itemStack != entityPlayer.field_71071_by.func_70301_a(i)) continue;
            entityPlayer.field_71071_by.func_70299_a(i, null);
            break;
        }
    }

    public static void removeStackFromSlot(EntityPlayer entityPlayer, int n) {
        if (entityPlayer.field_71071_by.field_70462_a[n] != null) {
            entityPlayer.field_71071_by.field_70462_a[n] = null;
        }
    }

    public static int getPatreonLevel(EntityPlayer entityPlayer) {
        boolean bl = false;
        String string = "/patreon?uuid=" + entityPlayer.func_110124_au().toString();
        String string2 = WyTelemetry.sendGET(string);
        if (!WyHelper.isNullOrEmpty(string2)) {
            int n = Integer.parseInt(string2);
            return n;
        }
        return 1;
    }

    public static boolean isCelestialDragon(EntityPlayer entityPlayer) {
        return WyHelper.getPatreonLevel(entityPlayer) == 4;
    }

    public static boolean isSupernova(EntityPlayer entityPlayer) {
        return WyHelper.getPatreonLevel(entityPlayer) == 3;
    }

    public static boolean isRookie(EntityPlayer entityPlayer) {
        return WyHelper.getPatreonLevel(entityPlayer) == 2;
    }

    public static boolean isDevBuild() {
        return "RELEASE".equalsIgnoreCase("DEV");
    }

    public static boolean isEarlyAccessBuild() {
        return "RELEASE".equalsIgnoreCase("EARLY_ACCESS");
    }

    public static boolean isReleaseBuild() {
        return "RELEASE".equalsIgnoreCase("RELEASE");
    }

    public static boolean hasPatreonAccess(EntityPlayer entityPlayer) {
        int n = WyHelper.getPatreonLevel(entityPlayer);
        if (WyHelper.isDevBuild() && WyDebug.isDebug()) {
            return true;
        }
        if (WyHelper.isDevBuild() && n >= 4) {
            return true;
        }
        return WyHelper.isEarlyAccessBuild() && n >= 3;
    }
}

