/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities.extra;

import java.util.LinkedHashMap;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.WyRegistry;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;

public class AbilityManager {
    private static AbilityManager instance;
    private LinkedHashMap registeredAbilities = new LinkedHashMap();

    public static AbilityManager instance() {
        if (instance == null) {
            instance = new AbilityManager();
        }
        return instance;
    }

    public void registerAbility(Ability ability) {
        if (this.registeredAbilities.containsKey(WyHelper.getFancyName(ability.getAttribute().getAttributeName()))) {
            WyDebug.info(ability.getAttribute().getAttributeName() + " ability is already registered ! Ignoring request.");
        } else {
            this.registeredAbilities.put(WyHelper.getFancyName(ability.getAttribute().getAttributeName()), ability);
            WyRegistry.registerName("ability." + WyHelper.getFancyName(ability.getAttribute().getAttributeName()) + ".name", ability.getAttribute().getAbilityDisplayName());
        }
    }

    public Ability getAbilityByName(String string) {
        if (this.registeredAbilities.containsKey(string)) {
            return (Ability)this.registeredAbilities.get(string);
        }
        return null;
    }

    public LinkedHashMap getHashMap() {
        return this.registeredAbilities;
    }

    public int getSize() {
        return this.registeredAbilities.size();
    }
}

