/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.quests;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.Quest;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;

public class QuestManager {
    private static QuestManager instance;

    public static QuestManager instance() {
        if (instance == null) {
            instance = new QuestManager();
        }
        return instance;
    }

    public Quest startQuest(EntityPlayer entityPlayer, Quest quest) {
        Quest quest2 = null;
        QuestProperties questProperties = QuestProperties.get(entityPlayer);
        if (questProperties.hasQuestCompleted(quest) && !quest.isRepeatable()) {
            WyHelper.sendMsgToPlayer(entityPlayer, quest.getQuestName() + " was completed and cannot be started again!");
            return null;
        }
        if (questProperties.hasQuestInTracker(quest)) {
            WyHelper.sendMsgToPlayer(entityPlayer, quest.getQuestName() + " is already in progress!");
            return null;
        }
        if (!quest.canStart(entityPlayer)) {
            return null;
        }
        try {
            quest2 = (Quest)quest.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        questProperties.addQuestInTracker(quest2);
        quest2.startQuest(entityPlayer);
        return quest2;
    }

    public Quest getQuestByNameFromList(HashMap hashMap, String string) {
        for (Quest quest : hashMap.values()) {
            if (!quest.getQuestID().toLowerCase().equals(string.toLowerCase())) continue;
            return quest;
        }
        return null;
    }
}

