/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.items.AkumaNoMi;

public class ExtendedWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi";
    private boolean isSwordsmanDojoSpawned = false;
    private int totalDojosSpawned;
    private HashMap issuedBounties = new HashMap();
    private List devilFruitsInWorld = new ArrayList();
    private List protectedAreas = new ArrayList();

    public ExtendedWorldData() {
        super(IDENTIFIER);
    }

    public ExtendedWorldData(String string) {
        super(string);
    }

    public static ExtendedWorldData get(World world) {
        ExtendedWorldData extendedWorldData = (ExtendedWorldData)world.func_72943_a(ExtendedWorldData.class, IDENTIFIER);
        if (extendedWorldData == null) {
            extendedWorldData = new ExtendedWorldData();
            world.func_72823_a(IDENTIFIER, (WorldSavedData)extendedWorldData);
        }
        return extendedWorldData;
    }

    public void func_76184_a(NBTTagCompound nBTTagCompound) {
        this.isSwordsmanDojoSpawned = nBTTagCompound.func_74767_n("isSwordsmanDojoSpawned");
        this.totalDojosSpawned = nBTTagCompound.func_74762_e("totalDojosSpawned");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("issuedBounties");
        this.issuedBounties.clear();
        nBTTagCompound2.func_150296_c().stream().forEach(object -> this.issuedBounties.put((String)object, nBTTagCompound2.func_74763_f((String)object)));
        NBTTagCompound nBTTagCompound3 = nBTTagCompound.func_74775_l("devilFruits");
        this.devilFruitsInWorld.clear();
        nBTTagCompound3.func_150296_c().stream().forEach(object -> this.devilFruitsInWorld.add((String)object));
        NBTTagCompound nBTTagCompound4 = nBTTagCompound.func_74775_l("protectedAreas");
        this.protectedAreas.clear();
        for (int i = 0; i <= nBTTagCompound4.func_150296_c().size(); ++i) {
            int[] nArray = nBTTagCompound4.func_74759_k("minPos_" + i);
            int[] nArray2 = nBTTagCompound4.func_74759_k("maxPos_" + i);
            this.protectedAreas.add(new int[][]{nArray, nArray2});
        }
    }

    public void func_76187_b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74757_a("isSwordsmanDojoSpawned", this.isSwordsmanDojoSpawned);
        nBTTagCompound.func_74768_a("totalDojosSpawned", this.totalDojosSpawned);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        if (this.issuedBounties.size() > 0) {
            this.issuedBounties.entrySet().stream().forEach(entry -> nBTTagCompound2.func_74772_a((String)entry.getKey(), ((Long)entry.getValue()).longValue()));
        }
        nBTTagCompound.func_74782_a("issuedBounties", (NBTBase)nBTTagCompound2);
        NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
        if (this.devilFruitsInWorld.size() > 0) {
            this.devilFruitsInWorld.stream().forEach(string -> nBTTagCompound3.func_74757_a(string, true));
        }
        nBTTagCompound.func_74782_a("devilFruits", (NBTBase)nBTTagCompound3);
        NBTTagCompound nBTTagCompound4 = new NBTTagCompound();
        if (this.protectedAreas.size() > 0) {
            int n = 0;
            for (int[][] nArray : this.protectedAreas) {
                nBTTagCompound4.func_74783_a("minPos_" + n, nArray[0]);
                nBTTagCompound4.func_74783_a("maxPos_" + n, nArray[1]);
                ++n;
            }
        }
        nBTTagCompound.func_74782_a("protectedAreas", (NBTBase)nBTTagCompound4);
    }

    public boolean isInsideRestrictedArea(int n, int n2, int n3) {
        if (this.protectedAreas.size() <= 0) {
            return false;
        }
        for (int[][] nArray : this.protectedAreas) {
            int[] nArray2 = nArray[0];
            int[] nArray3 = nArray[1];
            if (nArray2.length <= 0 || nArray3.length <= 0 || n <= nArray2[0] || n >= nArray3[0] || n2 <= nArray2[1] || n2 >= nArray3[1] || n3 <= nArray2[2] || n3 >= nArray3[2]) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedArea(int[] nArray, int[] nArray2) {
        this.protectedAreas.add(new int[][]{nArray, nArray2});
        this.func_76185_a();
    }

    public void removeRestrictedArea(int n, int n2, int n3) {
        Iterator iterator = this.protectedAreas.iterator();
        while (iterator.hasNext()) {
            int[][] nArray = (int[][])iterator.next();
            int[] nArray2 = nArray[0];
            int[] nArray3 = nArray[1];
            if (nArray2.length <= 0 || nArray3.length <= 0) continue;
            int n4 = (nArray2[0] + nArray3[0]) / 2;
            int n5 = (nArray2[1] + nArray3[1]) / 2;
            int n6 = (nArray2[2] + nArray3[2]) / 2;
            if (n != n4 || n2 != n5 || n3 != n6) continue;
            iterator.remove();
        }
        this.func_76185_a();
    }

    public List getAllRestrictions() {
        return this.protectedAreas;
    }

    public HashMap getAllBounties() {
        return this.issuedBounties;
    }

    public long getBounty(String string) {
        if (this.issuedBounties.containsKey(string.toLowerCase())) {
            return (Long)this.issuedBounties.get(string.toLowerCase());
        }
        return 0L;
    }

    public void issueBounty(String string, long l) {
        if (this.issuedBounties.containsKey(string.toLowerCase())) {
            this.issuedBounties.remove(string.toLowerCase());
            this.issuedBounties.put(string.toLowerCase(), l);
        } else {
            this.issuedBounties.put(string.toLowerCase(), l);
        }
        this.func_76185_a();
    }

    public int getTotalDojosSpawned() {
        return this.totalDojosSpawned;
    }

    public void countUpDojoSpawned() {
        ++this.totalDojosSpawned;
        if (this.totalDojosSpawned >= MainConfig.maxDojoSpawn) {
            this.setSwordsmanDojoSpawned(true);
        }
        this.func_76185_a();
    }

    public void setDojoSpawned(int n) {
        this.totalDojosSpawned = n;
        if (this.totalDojosSpawned >= MainConfig.maxDojoSpawn) {
            this.setSwordsmanDojoSpawned(true);
        }
        this.func_76185_a();
    }

    public boolean isSwordsmanDojoSpawned() {
        return this.isSwordsmanDojoSpawned;
    }

    public void setSwordsmanDojoSpawned(boolean bl) {
        this.isSwordsmanDojoSpawned = bl;
        this.func_76185_a();
    }

    public List getDevilFruitsInWorld() {
        return this.devilFruitsInWorld;
    }

    public void removeDevilFruitFromWorld(AkumaNoMi akumaNoMi) {
        String string = akumaNoMi.func_77658_a().substring(5).replace("nomi", "").replace(":", "").replace(",", "").replace("model", "");
        if (this.devilFruitsInWorld.contains(string)) {
            this.devilFruitsInWorld.remove(string);
            this.func_76185_a();
        }
    }

    public void removeDevilFruitFromWorld(String string) {
        if (this.devilFruitsInWorld.contains(string)) {
            this.devilFruitsInWorld.remove(string);
            this.func_76185_a();
        }
    }

    public void addDevilFruitInWorld(AkumaNoMi akumaNoMi) {
        String string = akumaNoMi.func_77658_a().substring(5).replace("nomi", "").replace(":", "").replace(",", "").replace("model", "");
        if (!this.devilFruitsInWorld.contains(string)) {
            this.devilFruitsInWorld.add(string);
            this.func_76185_a();
        }
    }

    public void addDevilFruitInWorld(String string) {
        if (!this.devilFruitsInWorld.contains(string)) {
            this.devilFruitsInWorld.add(string);
            this.func_76185_a();
        }
    }

    public boolean isDevilFruitInWorld(String string) {
        return this.devilFruitsInWorld.contains(string);
    }
}

