/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.quests.questlines.swordsmanprogression;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketQuestSync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.Quest;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.bandits.BanditData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.bandits.EntityBandit;
import xyz.pixelatedw.MineMineNoMi3.helpers.QuestLogicHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.lists.ListQuests;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketQuestObjectiveSpawn;
import xyz.pixelatedw.MineMineNoMi3.quests.EnumQuestlines;
import xyz.pixelatedw.MineMineNoMi3.quests.IInteractQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IKillQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IProgressionQuest;

public class QuestSwordsmanProgression05
extends Quest
implements IInteractQuest,
IKillQuest,
IProgressionQuest {
    private int questPhase = 0;
    private String lore1 = "Transport Content :";
    private String lore2 = "* 100 TNT Blocks";
    private String lore3 = "* 50 Gunpowder";
    private String lore4 = "";
    private String lore5 = "Delivered to :";
    private String lore6 = "X:0 Y:0 Z:0";
    private String lore7 = "- Simple Text Name";

    @Override
    public String getQuestID() {
        return "swordsmanprogression05";
    }

    @Override
    public String getQuestName() {
        return "Mysterious Note";
    }

    @Override
    public String[] getQuestDescription() {
        return new String[]{"", "", "", "", "", "", ""};
    }

    @Override
    public void startQuest(EntityPlayer entityPlayer) {
        WyHelper.sendMsgToPlayer(entityPlayer, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".started"), (Object[])new Object[0]));
        for (int i = 0; i < 6; ++i) {
            EntityBandit entityBandit = new EntityBandit(entityPlayer.field_70170_p);
            double d = entityPlayer.field_70165_t + WyMathHelper.randomWithRange(-20, 20);
            double d2 = entityPlayer.field_70161_v + WyMathHelper.randomWithRange(-20, 20);
            entityBandit.func_70012_b(d, entityPlayer.field_70163_u, d2, 0.0f, 0.0f);
            entityBandit.setOwner(entityPlayer);
            entityBandit.setActive(true);
            if (entityPlayer.field_70170_p.field_72995_K) continue;
            entityPlayer.field_70170_p.func_72838_d((Entity)entityBandit);
        }
        WyNetworkHelper.sendToAll(new PacketQuestObjectiveSpawn(entityPlayer.func_145782_y()));
        this.extraData = new NBTTagCompound();
        this.extraData.func_74768_a("phase", this.questPhase);
        super.startQuest(entityPlayer);
    }

    @Override
    public boolean canStart(EntityPlayer entityPlayer) {
        ExtendedEntityData extendedEntityData = ExtendedEntityData.get((EntityLivingBase)entityPlayer);
        QuestProperties questProperties = QuestProperties.get(entityPlayer);
        boolean bl = extendedEntityData.isSwordsman();
        boolean bl2 = questProperties.hasQuestCompleted(ListQuests.swordsmanProgression04);
        return bl && bl2;
    }

    @Override
    public void finishQuest(EntityPlayer entityPlayer) {
        WyHelper.sendMsgToPlayer(entityPlayer, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".completed"), (Object[])new Object[0]));
        ItemStack itemStack = QuestLogicHelper.getQuestItemStack(entityPlayer.field_71071_by, this.getQuestID());
        WyHelper.removeStackFromInventory(entityPlayer, itemStack);
        super.finishQuest(entityPlayer);
    }

    @Override
    public boolean isFinished(EntityPlayer entityPlayer) {
        boolean bl;
        this.questPhase = this.extraData.func_74762_e("phase");
        boolean bl2 = this.questPhase == 0;
        boolean bl3 = WyHelper.getEntitiesNear((Entity)entityPlayer, 20.0, BanditData.class).size() > 0;
        boolean bl4 = this.getProgress() >= this.getMaxProgress();
        boolean bl5 = bl = this.questPhase == 1;
        if (bl3) {
            if (!entityPlayer.field_70170_p.field_72995_K) {
                WyHelper.sendMsgToPlayer(entityPlayer, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".dialogue.01"), (Object[])new Object[0]));
            }
            return false;
        }
        if (bl2 && !bl4) {
            if (!entityPlayer.field_70170_p.field_72995_K) {
                WyHelper.sendMsgToPlayer(entityPlayer, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".dialogue.02"), (Object[])new Object[0]));
            }
            ItemStack itemStack = new ItemStack(ListMisc.Note);
            itemStack.func_151001_c("Mysterious Note");
            itemStack.func_77978_p().func_74778_a("ForQuest", this.getQuestID());
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("lore1", WyMathHelper.shuffleArray(this.lore1));
            nBTTagCompound.func_74778_a("lore2", WyMathHelper.shuffleArray(this.lore2));
            nBTTagCompound.func_74778_a("lore3", WyMathHelper.shuffleArray(this.lore3));
            nBTTagCompound.func_74778_a("lore4", this.lore4);
            nBTTagCompound.func_74778_a("lore5", WyMathHelper.shuffleArray(this.lore5));
            nBTTagCompound.func_74778_a("lore6", WyMathHelper.shuffleArray(this.lore6));
            nBTTagCompound.func_74778_a("lore7", WyMathHelper.shuffleArray(this.lore7));
            itemStack.func_77978_p().func_74782_a("QuestLore", (NBTBase)nBTTagCompound);
            entityPlayer.field_71071_by.func_70441_a(itemStack);
            this.extraData.func_74768_a("phase", 1);
        } else if (bl && bl4) {
            ItemStack itemStack;
            if (!entityPlayer.field_70170_p.field_72995_K && (itemStack = QuestLogicHelper.getQuestItemStack(entityPlayer.field_71071_by, this.getQuestID())) != null && itemStack.func_77942_o()) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)itemStack.func_77978_p().func_74781_a("QuestLore");
                if (nBTTagCompound == null) {
                    return false;
                }
                itemStack.func_151001_c("Deciphered Note");
                nBTTagCompound.func_74778_a("lore1", this.lore1);
                nBTTagCompound.func_74778_a("lore2", this.lore2);
                nBTTagCompound.func_74778_a("lore3", this.lore3);
                nBTTagCompound.func_74778_a("lore4", this.lore4);
                nBTTagCompound.func_74778_a("lore5", this.lore5);
                nBTTagCompound.func_74778_a("lore6", this.lore6);
                nBTTagCompound.func_74778_a("lore7", this.lore7);
                itemStack.func_77978_p().func_74782_a("QuestLore", (NBTBase)nBTTagCompound);
            }
            return true;
        }
        return false;
    }

    @Override
    public double getMaxProgress() {
        return 6.0;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public EnumQuestlines getQuestLine() {
        return EnumQuestlines.SWORDSMAN_PROGRESSION;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isTarget(EntityPlayer entityPlayer, EntityLivingBase entityLivingBase) {
        this.questPhase = this.extraData.func_74762_e("phase");
        if (this.questPhase == 0) {
            boolean bl;
            boolean bl2 = entityLivingBase instanceof BanditData;
            boolean bl3 = bl = this.getProgress() < this.getMaxProgress() - 1.0;
            if (bl2 && bl) {
                return true;
            }
        } else if (this.questPhase == 1) {
            boolean bl;
            boolean bl4 = entityLivingBase instanceof EntityVillager;
            boolean bl5 = bl4 && ((EntityVillager)entityLivingBase).func_70946_n() == 1;
            boolean bl6 = bl = this.getProgress() < this.getMaxProgress();
            if (bl4 && bl5 && bl) {
                this.setProgress(entityPlayer, this.getMaxProgress());
                WyNetworkHelper.sendTo(new PacketQuestSync(QuestProperties.get(entityPlayer)), (EntityPlayerMP)entityPlayer);
                entityLivingBase.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                this.isFinished(entityPlayer);
                return true;
            }
        }
        return false;
    }
}

