/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.util.ForgeDirection;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.Schematic;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.WySchematicHelper;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructureBanditSmallBase;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructureCamp;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructureCloud;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructureDojo;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructureLargeShip;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructureMarineLargeBase;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructurePoneglyph;
import xyz.pixelatedw.MineMineNoMi3.world.structures.StructureSmallShip;

public class MainWorldGen
implements IWorldGenerator {
    public void generate(Random random, int n, int n2, World world, IChunkProvider iChunkProvider, IChunkProvider iChunkProvider2) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateSurface(world, random, n * 16, n2 * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int n, int n2) {
        this.addOreSpawn(ListMisc.KairosekiOre, world, random, n, n2, 16, 16, 4 + random.nextInt(3), 10, 15, 50);
        if (MainConfig.enableClouds && (double)random.nextInt(100) + random.nextDouble() <= 1.0) {
            int n3 = n;
            int n4 = random.nextInt(128);
            int n5 = n2;
            StructureCloud.build(world, n3, n4, n5);
            n4 = random.nextInt(64);
            StructurePoneglyph.build(world, n3, n4, n5);
            System.out.println("Poneglyph spawned at /tp @p " + n3 + " " + n4 + " " + n5);
        }
        if (MainConfig.enableShips) {
            this.addStructureSpawn(WySchematicHelper.load("marineShip"), world, random, n, n2, 1, 1, 1.5 * MainConfig.modifierShipsSpawn);
            this.addStructureSpawn(WySchematicHelper.load("pyrateShip"), world, random, n, n2, 1, 1, 1.8 * MainConfig.modifierShipsSpawn);
            this.addStructureSpawn(WySchematicHelper.load("pyrateLargeShip"), world, random, n, n2, 1, 1, 1.3 * MainConfig.modifierShipsSpawn);
            this.addStructureSpawn(WySchematicHelper.load("marineLargeShip"), world, random, n, n2, 1, 1, 1.4 * MainConfig.modifierShipsSpawn);
        }
        this.addStructureSpawn(WySchematicHelper.load("dojo"), world, random, n, n2, 1, 1, 5.0);
        if (MainConfig.enableCamps) {
            this.addStructureSpawn(WySchematicHelper.load("marineCamp"), world, random, n, n2, 1, 1, 5.0);
            this.addStructureSpawn(WySchematicHelper.load("banditCamp"), world, random, n, n2, 1, 1, 10.0);
        }
        if (MainConfig.enableBases) {
            this.addStructureSpawn(WySchematicHelper.load("banditBase"), world, random, n, n2, 1, 1, 3.0);
            this.addStructureSpawn(WySchematicHelper.load("marineLargeBase"), world, random, n, n2, 1, 1, 1.0);
        }
        this.addDialSpawn(ListMisc.DialEisenBlock, "Eisen Dial", world, random, n, n2, 1, 1, 100.0);
        this.addDialSpawn(ListMisc.DialFireBlock, "Fire Dial", world, random, n, n2, 1, 1, 70.0);
        this.addDialSpawn(ListMisc.DialAxeBlock, "Axe Dial", world, random, n, n2, 1, 1, 70.0);
        this.addDialSpawn(ListMisc.DialMilkyBlock, "Milky Dial", world, random, n, n2, 1, 1, 20.0);
        this.addDialSpawn(ListMisc.DialRejectBlock, "Reject Dial", world, random, n, n2, 1, 1, 10.0);
        this.addDialSpawn(ListMisc.DialBreathBlock, "Breath Dial", world, random, n, n2, 1, 1, 50.0);
        this.addDialSpawn(ListMisc.DialFlashBlock, "Flash Dial", world, random, n, n2, 1, 1, 45.0);
    }

    public boolean addOreSpawn(Block block, World world, Random random, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n7 + (n8 - 1);
        int n10 = n8 - n7;
        for (int i = 0; i < n6; ++i) {
            int n11 = n + random.nextInt(n3);
            int n12 = n7 + random.nextInt(n10);
            int n13 = n2 + random.nextInt(n4);
            BiomeGenBase biomeGenBase = world.getBiomeGenForCoordsBody(n11, n13);
            if (block != ListMisc.KairosekiOre || !biomeGenBase.field_76791_y.equals("Ocean") && !biomeGenBase.field_76791_y.equals("Deep Ocean") && !biomeGenBase.field_76791_y.equals("Beach")) continue;
            new WorldGenMinable(block, n5).func_76484_a(world, random, n11, n12, n13);
            return true;
        }
        return false;
    }

    public boolean addDialSpawn(Block block, String string, World world, Random random, int n, int n2, int n3, int n4, double d) {
        if ((double)world.field_73012_v.nextInt(100) + world.field_73012_v.nextDouble() <= d) {
            int n5 = n;
            int n6 = random.nextInt(128);
            int n7 = n2;
            BiomeGenBase biomeGenBase = world.getBiomeGenForCoordsBody(n5, n7);
            if (!(biomeGenBase != BiomeGenBase.field_76787_r && biomeGenBase != BiomeGenBase.field_76772_c || world.func_147439_a(n5, n6 - 1, n7) != Blocks.field_150354_m && world.func_147439_a(n5, n6 - 1, n7) != Blocks.field_150349_c || world.func_147439_a(n5, n6 + 1, n7) != Blocks.field_150350_a)) {
                world.func_147449_b(n5, n6, n7, block);
                if (WyDebug.isDebug()) {
                    System.out.println("" + block.func_149732_F() + " spawned at /tp @p " + n5 + " " + (n6 + 1) + " " + n7);
                }
                WyTelemetry.addStructureStat(WyHelper.getFancyName(string), string, 1);
                return true;
            }
        }
        return false;
    }

    public boolean addStructureSpawn(Schematic schematic, World world, Random random, int n, int n2, int n3, int n4, double d) {
        if ((double)random.nextInt(100) + random.nextDouble() <= d) {
            int n5 = n;
            int n6 = random.nextInt(128);
            int n7 = n2;
            BiomeGenBase biomeGenBase = world.getBiomeGenForCoordsBody(n5, n7);
            if (schematic != null) {
                boolean bl = false;
                if (schematic.getName().equals("marineShip") || schematic.getName().equals("pyrateShip")) {
                    bl = StructureSmallShip.build(schematic, world, n5, n6, n7, biomeGenBase);
                }
                if (schematic.getName().equals("marineLargeShip") || schematic.getName().equals("pyrateLargeShip")) {
                    bl = StructureLargeShip.build(schematic, world, n5, n6, n7, biomeGenBase);
                }
                if (schematic.getName().equals("marineCamp") || schematic.getName().equals("banditCamp")) {
                    bl = StructureCamp.build(schematic, world, n5, n6, n7, biomeGenBase);
                }
                if (schematic.getName().equals("marineLargeBase")) {
                    bl = StructureMarineLargeBase.build(schematic, world, n5, n6, n7, biomeGenBase);
                }
                if (schematic.getName().equals("banditBase")) {
                    bl = StructureBanditSmallBase.build(schematic, world, n5, n6, n7, biomeGenBase);
                }
                if (schematic.getName().equals("dojo")) {
                    bl = StructureDojo.build(schematic, world, n5, n6, n7, biomeGenBase);
                }
                if (bl) {
                    if (WyDebug.isDebug()) {
                        System.out.println("" + schematic.getName() + " spawned at /tp @p " + n5 + " " + n6 + " " + n7);
                    }
                    WyTelemetry.addStructureStat(WyHelper.getFancyName(schematic.getName()), schematic.getName(), 1);
                }
                return bl;
            }
            Logger.getGlobal().log(Level.SEVERE, "Some schematic is null, this should never happen !");
        }
        return false;
    }

    public static boolean checkCorners(Schematic schematic, World world, int n, int n2, int n3) {
        return MainWorldGen.checkCorners(schematic, world, n, n2, n3, 4);
    }

    public static boolean checkCorners(Schematic schematic, World world, int n, int n2, int n3, int n4) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 1; i < n4; ++i) {
            if (!bl) {
                bl = world.func_147439_a(n, n2 - i, n3).isSideSolid((IBlockAccess)world, n, n2 - i, n3, ForgeDirection.DOWN);
            }
            if (!bl2) {
                bl2 = world.func_147439_a(n + schematic.getWidth(), n2 - i, n3).isSideSolid((IBlockAccess)world, n + schematic.getWidth(), n2 - i, n3, ForgeDirection.DOWN);
            }
            if (!bl3) {
                bl3 = world.func_147439_a(n, n2 - i, n3 + schematic.getLength()).isSideSolid((IBlockAccess)world, n, n2 - i, n3 + schematic.getLength(), ForgeDirection.DOWN);
            }
            if (!bl4) {
                bl4 = world.func_147439_a(n + schematic.getWidth(), n2 - i, n3 + schematic.getLength()).isSideSolid((IBlockAccess)world, n + schematic.getWidth(), n2 - i, n3 + schematic.getLength(), ForgeDirection.DOWN);
            }
            if ((bl ? 1 : 0) + (bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0) < 3) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCornersAboveGround(Schematic schematic, World world, int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < 3; ++i) {
            if (!bl) {
                boolean bl5 = bl = world.func_147439_a(n, n2 + i, n3) == Blocks.field_150350_a && world.func_72937_j(n, n2 + i, n3);
            }
            if (!bl2) {
                boolean bl6 = bl2 = world.func_147439_a(n + schematic.getWidth(), n2 + i, n3) == Blocks.field_150350_a && world.func_72937_j(n + schematic.getWidth(), n2 + i, n3);
            }
            if (!bl3) {
                boolean bl7 = bl3 = world.func_147439_a(n, n2 + i, n3 + schematic.getLength()) == Blocks.field_150350_a && world.func_72937_j(n, n2 + i, n3 + schematic.getLength());
            }
            if (!bl4) {
                bl4 = world.func_147439_a(n + schematic.getWidth(), n2 + i, n3 + schematic.getLength()) == Blocks.field_150350_a && world.func_72937_j(n + schematic.getWidth(), n2 + i, n3 + schematic.getLength());
            }
            if ((bl ? 1 : 0) + (bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0) < 3) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForWaterSpawn(Schematic schematic, World world, int n, int n2, int n3) {
        for (int i = 0; i < schematic.getWidth(); ++i) {
            for (int j = 0; j < schematic.getHeight(); ++j) {
                for (int k = 0; k < schematic.getLength(); ++k) {
                    if (world.func_147439_a(n + i, n2 + j, n3 + k) != Blocks.field_150350_a) continue;
                    if (world.func_147439_a(n, n2 - 1, n3) == Blocks.field_150355_j || world.func_147439_a(n, n2 - 1, n3) == Blocks.field_150358_i) {
                        return world.func_147439_a(n, n2 + 2, n3) == Blocks.field_150350_a;
                    }
                    return false;
                }
            }
        }
        return false;
    }
}

