/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.entity;

import awger.AwgerLogger;
import awger.smallboats.SmallBoats;
import awger.smallboats.entity.EntityBoatPart;
import awger.smallboats.entity.EntitySmallBoat;
import awger.smallboats.util.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class EntityBoatChest
extends EntityBoatPart
implements IInventory {
    private boolean Open;
    protected ItemStack[] inventory;

    public EntityBoatChest(World par1World) {
        super(par1World);
        this.hasChest = true;
        this.inventory = new ItemStack[27];
        this.Open = false;
    }

    public EntityBoatChest(EntitySmallBoat _parent, String _name, int _slots, int _modelIndex) {
        super(_parent, _name, _modelIndex);
        this.hasChest = true;
        this.inventory = new ItemStack[_slots];
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        AwgerLogger.fine(SmallBoats.LogLevel, "%s: EntityBoatChest.writeEntityToNBT() for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y());
        super.func_70014_b(compound);
        compound.func_74768_a("InventorySize", this.inventory.length);
        if (this.func_70302_i_() > 0) {
            NBTTagList items = new NBTTagList();
            for (int slot = 0; slot < this.inventory.length; ++slot) {
                if (this.inventory[slot] == null) continue;
                NBTTagCompound item = new NBTTagCompound();
                item.func_74774_a("Slot", (byte)slot);
                this.inventory[slot].func_77955_b(item);
                items.func_74742_a((NBTBase)item);
            }
            compound.func_74782_a("Items", (NBTBase)items);
            AwgerLogger.fine(SmallBoats.LogLevel, "*** wrote %d items", items.func_74745_c());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        AwgerLogger.fine(SmallBoats.LogLevel, "%s: EntityBoatChest.readEntityToNBT() for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y());
        super.func_70037_a(compound);
        int isize = compound.func_74762_e("InventorySize");
        this.inventory = new ItemStack[isize];
        NBTTagList items = compound.func_150295_c("Items", 10);
        if (items != null) {
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                int slot = item.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
            }
            AwgerLogger.fine(SmallBoats.LogLevel, "*** read %d items", items.func_74745_c());
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory[var1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.Name + ".Chest";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a != 0) continue;
            this.inventory[i] = null;
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_70128_L ? false : var1.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70295_k_() {
        this.Open = true;
        AwgerLogger.fine(SmallBoats.LogLevel, "chest.Open = %b", this.Open);
    }

    public void func_70305_f() {
        this.Open = false;
        AwgerLogger.fine(SmallBoats.LogLevel, "chest.Open = %b", this.Open);
    }

    protected void dumpChest() {
        for (int i = 0; i < this.inventory.length; ++i) {
            WorldUtils.spawnItemWithRandom(this.field_70170_p, this.func_70304_b(i), this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    @Override
    protected void func_70076_C() {
        this.dumpChest();
        super.func_70076_C();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    public boolean isOpen() {
        return this.Open;
    }
}

