/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.entity;

import awger.AwgerLogger;
import awger.smallboats.SmallBoats;
import awger.smallboats.entity.EntityBoatChest;
import awger.smallboats.entity.EntitySmallBoat;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class EntityBoatPart
extends Entity
implements IEntityAdditionalSpawnData {
    public EntitySmallBoat Parent = null;
    protected UUID ParentPersistentID;
    public String Name;
    public int ModelIndex;
    public final AxisAlignedBB collisionBox;
    public float posOfsX;
    public float posOfsY;
    public float posOfsZ;
    public float riderOfsX;
    public float riderOfsY;
    public float riderOfsZ;
    public float renderOfsX;
    public float renderOfsY;
    public float renderOfsZ;
    public float renderRotX;
    public float renderRotY;
    public float renderRotZ;
    public EntityBoatPart Sibling;
    private int trackRider = 1;
    protected int parentId = 0;
    int savedId;
    public boolean canInteract = true;
    public boolean hasSeat = false;
    public boolean hasChest = false;
    public boolean hasGun = false;
    public boolean isDeck = false;
    protected int BoundingFlags = 0;
    private int SuicideCounter = 500;

    public EntityBoatPart(World par1World) {
        super(par1World);
        AwgerLogger.log(SmallBoats.LogLevel, String.format("%s: instantiating generic EntityBoatPart(%d)", par1World.field_72995_K ? "client" : "server", this.func_145782_y()), new Object[0]);
        this.savedId = this.func_145782_y();
        this.field_70156_m = true;
        this.Name = "zombie";
        this.ModelIndex = -1;
        this.func_70105_a(0.95f, 0.95f);
        this.collisionBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.posOfsX = 0.0f;
        this.posOfsY = 0.0f;
        this.posOfsZ = 0.0f;
        this.riderOfsX = 0.0f;
        this.riderOfsY = 0.0f;
        this.riderOfsZ = 0.0f;
        this.renderOfsX = 0.0f;
        this.renderOfsY = 0.0f;
        this.renderOfsZ = 0.0f;
        this.renderRotX = 0.0f;
        this.renderRotY = 0.0f;
        this.renderRotZ = 0.0f;
        this.hasSeat = false;
        this.hasChest = false;
        this.hasGun = false;
        this.isDeck = false;
    }

    public EntityBoatPart(EntitySmallBoat _parent, String _name, int _modelIndex) {
        super(_parent.field_70170_p);
        AwgerLogger.log(SmallBoats.LogLevel, String.format("%s: additional initialization for EntityBoatPart(%d)", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y()), new Object[0]);
        this.savedId = this.func_145782_y();
        this.field_70156_m = true;
        this.Name = "zombie";
        this.ModelIndex = -1;
        this.func_70105_a(0.95f, 0.95f);
        this.collisionBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.posOfsX = 0.0f;
        this.posOfsY = 0.0f;
        this.posOfsZ = 0.0f;
        this.renderOfsX = 0.0f;
        this.renderOfsY = 0.0f;
        this.renderOfsZ = 0.0f;
        this.renderRotX = 0.0f;
        this.renderRotY = 0.0f;
        this.renderRotZ = 0.0f;
        this.hasSeat = false;
        this.hasChest = false;
        this.hasGun = false;
        this.isDeck = false;
        this.setParent(_parent);
        this.setName(_name);
        this.setModelIndex(_modelIndex);
    }

    protected void func_70088_a() {
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.ParentPersistentID.getMostSignificantBits());
        buffer.writeLong(this.ParentPersistentID.getLeastSignificantBits());
        if (this.Parent != null) {
            buffer.writeInt(this.Parent.func_145782_y());
        } else {
            buffer.writeInt(0);
        }
        buffer.writeInt(this.ModelIndex);
        buffer.writeBoolean(this.hasSeat);
        buffer.writeBoolean(this.hasChest);
        buffer.writeBoolean(this.hasGun);
        buffer.writeBoolean(this.isDeck);
        buffer.writeBoolean(this.canInteract);
        buffer.writeByte(this.BoundingFlags);
        buffer.writeFloat(this.posOfsX);
        buffer.writeFloat(this.posOfsY);
        buffer.writeFloat(this.posOfsZ);
        buffer.writeFloat(this.riderOfsX);
        buffer.writeFloat(this.riderOfsY);
        buffer.writeFloat(this.riderOfsZ);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.ParentPersistentID = new UUID(buffer.readLong(), buffer.readLong());
        AwgerLogger.fine(SmallBoats.LogLevel, "** child %d parent is %s", this.func_145782_y(), this.ParentPersistentID.toString());
        this.parentId = buffer.readInt();
        if (this.parentId != 0) {
            this.setParent((EntitySmallBoat)this.field_70170_p.func_73045_a(this.parentId));
        } else {
            AwgerLogger.fine(SmallBoats.LogLevel, "!! received spawn of child %d with invalid parentId", this.func_145782_y());
        }
        this.setModelIndex(buffer.readInt());
        AwgerLogger.fine(SmallBoats.LogLevel, "** child %d ModelIndex %d", this.func_145782_y(), this.ModelIndex);
        this.setHasSeat(buffer.readBoolean());
        this.setHasChest(buffer.readBoolean());
        this.setHasGun(buffer.readBoolean());
        this.setIsDeck(buffer.readBoolean());
        this.canInteract = buffer.readBoolean();
        this.BoundingFlags = buffer.readByte();
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float z = buffer.readFloat();
        this.setPositionOffsets(x, y, z);
        x = buffer.readFloat();
        y = buffer.readFloat();
        z = buffer.readFloat();
        if (this.hasSeat) {
            this.setRiderOffsets(x, y, z);
        }
        if (this.Parent != null) {
            this.Parent.addPart(this);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        if (this.Parent != null) {
            par1NBTTagCompound.func_74772_a("ParentUUID_MSB", this.Parent.getParentPersistentID().getMostSignificantBits());
            par1NBTTagCompound.func_74772_a("ParentUUID_LSB", this.Parent.getParentPersistentID().getLeastSignificantBits());
            par1NBTTagCompound.func_74778_a("Name", this.Name);
            par1NBTTagCompound.func_74768_a("ModelIndex", this.ModelIndex);
            par1NBTTagCompound.func_74757_a("HasSeat", this.hasSeat);
            par1NBTTagCompound.func_74757_a("HasChest", this.hasChest);
            par1NBTTagCompound.func_74757_a("HasGun", this.hasGun);
            par1NBTTagCompound.func_74757_a("IsDeck", this.isDeck);
            par1NBTTagCompound.func_74757_a("canInteract", this.canInteract);
            par1NBTTagCompound.func_74768_a("BoundingFlags", this.BoundingFlags);
            par1NBTTagCompound.func_74776_a("posOfsX", this.posOfsX);
            par1NBTTagCompound.func_74776_a("posOfsY", this.posOfsY);
            par1NBTTagCompound.func_74776_a("posOfsZ", this.posOfsZ);
            par1NBTTagCompound.func_74776_a("riderOfsX", this.riderOfsX);
            par1NBTTagCompound.func_74776_a("riderOfsY", this.riderOfsY);
            par1NBTTagCompound.func_74776_a("riderOfsZ", this.riderOfsZ);
            AwgerLogger.fine(SmallBoats.LogLevel, "** wrote child %d to NBT, parent is %s", this.func_145782_y(), this.Parent.getParentPersistentID().toString());
        } else {
            AwgerLogger.warning(SmallBoats.LogLevel, "!! attempted to write orphan %d to NBT", this.func_145782_y());
            this.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.ParentPersistentID = new UUID(par1NBTTagCompound.func_74763_f("ParentUUID_MSB"), par1NBTTagCompound.func_74763_f("ParentUUID_LSB"));
        this.setName(par1NBTTagCompound.func_74779_i("Name"));
        this.setModelIndex(par1NBTTagCompound.func_74762_e("ModelIndex"));
        this.setHasSeat(par1NBTTagCompound.func_74767_n("HasSeat"));
        this.setHasChest(par1NBTTagCompound.func_74767_n("HasChest"));
        this.setHasGun(par1NBTTagCompound.func_74767_n("HasGun"));
        this.setIsDeck(par1NBTTagCompound.func_74767_n("IsDeck"));
        this.canInteract = par1NBTTagCompound.func_74767_n("canInteract");
        this.BoundingFlags = par1NBTTagCompound.func_74762_e("BoundingFlags");
        this.posOfsX = par1NBTTagCompound.func_74760_g("posOfsX");
        this.posOfsY = par1NBTTagCompound.func_74760_g("posOfsY");
        this.posOfsZ = par1NBTTagCompound.func_74760_g("posOfsZ");
        this.riderOfsX = par1NBTTagCompound.func_74760_g("riderOfsX");
        this.riderOfsY = par1NBTTagCompound.func_74760_g("riderOfsY");
        this.riderOfsZ = par1NBTTagCompound.func_74760_g("riderOfsZ");
        if (this.ParentPersistentID.getMostSignificantBits() == 0L && this.ParentPersistentID.getLeastSignificantBits() == 0L) {
            AwgerLogger.warning(SmallBoats.LogLevel, "!! read orphan %d from NBT", this.func_145782_y());
            this.func_70106_y();
        } else {
            AwgerLogger.fine(SmallBoats.LogLevel, "** read child %d from NBT, parent is %s", this.func_145782_y(), this.ParentPersistentID.toString());
        }
    }

    public void setParent(EntitySmallBoat _parent) {
        if (_parent != null) {
            AwgerLogger.fine(SmallBoats.LogLevel, "%s: %d.setParent(%d)", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y(), _parent.func_145782_y());
            this.Parent = _parent;
            this.parentId = this.Parent.func_145782_y();
            this.ParentPersistentID = _parent.getParentPersistentID();
        } else {
            AwgerLogger.fine(SmallBoats.LogLevel, "%s: %d.setParent(null)", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y());
        }
    }

    public void setName(String _name) {
        this.Name = _name;
    }

    public void setModelIndex(int _index) {
        this.ModelIndex = _index;
    }

    public void setHasSeat(boolean _hasSeat) {
        this.hasSeat = _hasSeat;
    }

    public void setHasChest(boolean _hasChest) {
        this.hasChest = _hasChest;
    }

    public void setHasGun(boolean _hasGun) {
        this.hasGun = _hasGun;
    }

    public void setIsDeck(boolean _isDeck) {
        this.isDeck = _isDeck;
    }

    public void setPositionOffsets(float _x, float _y, float _z) {
        this.posOfsX = _x;
        this.posOfsY = _y;
        this.posOfsZ = _z;
    }

    public void setRiderOffsets(float _x, float _y, float _z) {
        this.riderOfsX = _x;
        this.riderOfsY = _y;
        this.riderOfsZ = _z;
    }

    public void setRenderRotations(float _x, float _y, float _z) {
        this.renderRotX = _x;
        this.renderRotY = _y;
        this.renderRotZ = _z;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return this.collisionBox;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.Parent != null) {
            if (par1DamageSource.func_76355_l() == "thrown") {
                return false;
            }
            return this.Parent.attackEntityFromPart(par1DamageSource, par2);
        }
        return false;
    }

    public boolean func_70028_i(Entity par1Entity) {
        return this == par1Entity || this.Parent == par1Entity;
    }

    public void func_70108_f(Entity par1Entity) {
        if (this.isDeck) {
            if (this.Parent != null) {
                this.Parent.addPassenger(par1Entity);
            }
        } else if (this.Parent != null && par1Entity != this.Parent && !this.Parent.isRider(par1Entity) && !this.Parent.isChild(par1Entity) && par1Entity.func_70104_M()) {
            this.Parent.func_70108_f(par1Entity);
        }
    }

    public void applyBlockCollision(float x, float y, float z, float magnitude) {
        if (this.Parent != null) {
            this.Parent.applyBlockCollision(x, y, z, magnitude);
        }
    }

    public void func_70107_b(double par1, double par3, double par5) {
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        this.setBoundingBox();
    }

    public void func_70080_a(double par1, double par3, double par5, float par7, float par8) {
        this.field_70169_q = this.field_70165_t = par1;
        this.field_70167_r = this.field_70163_u = par3;
        this.field_70166_s = this.field_70161_v = par5;
        this.field_70126_B = this.field_70177_z = par7;
        this.field_70127_C = this.field_70125_A = par8;
        this.field_70139_V = 0.0f;
        double var9 = this.field_70126_B - par7;
        if (var9 < -180.0) {
            this.field_70126_B += 360.0f;
        }
        if (var9 >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(par7, par8);
        this.setBoundingBox();
    }

    public void func_70071_h_() {
        if (this.Parent == null) {
            if (this.ParentPersistentID == null) {
                AwgerLogger.fine("!! orphan %d has no parent UUID", this.func_145782_y());
                return;
            }
            for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                Entity ent = (Entity)this.field_70170_p.field_72996_f.get(i);
                if (!(ent instanceof EntitySmallBoat)) continue;
                EntitySmallBoat sm = (EntitySmallBoat)ent;
                UUID uuid = sm.getParentPersistentID();
                AwgerLogger.finer(String.format("\t** found smallboat %s ", uuid.toString()), new Object[0]);
                long msb1 = uuid.getMostSignificantBits();
                long lsb1 = uuid.getLeastSignificantBits();
                long msb2 = this.ParentPersistentID.getMostSignificantBits();
                long lsb2 = this.ParentPersistentID.getLeastSignificantBits();
                if (msb1 != msb2 || lsb1 != lsb2) continue;
                AwgerLogger.finer(String.format("%s: found smallboat %s ", this.field_70170_p.field_72995_K ? "client" : "server", uuid.toString()), new Object[0]);
                this.setParent(sm);
                break;
            }
            if (this.Parent != null) {
                this.Parent.addPart(this);
            } else {
                AwgerLogger.fine(String.format("!! orphan %d waiting on parent %s", this.func_145782_y(), this.ParentPersistentID.toString()), new Object[0]);
                --this.SuicideCounter;
                if (this.SuicideCounter <= 0) {
                    AwgerLogger.severe(String.format("!! child %d couldn't find parent %s -- GOODBYE, CRUEL WORLD!", this.func_145782_y(), this.ParentPersistentID.toString()), new Object[0]);
                    this.func_70106_y();
                }
                return;
            }
        }
        if (this.savedId != this.func_145782_y()) {
            this.savedId = this.func_145782_y();
            if (this.field_70170_p.field_72995_K) {
                this.Parent.updateChildIds();
            }
        }
        this.setBoundingBox();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70132_H = false;
            List var16 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.25, 0.25, 0.25));
            if (var16 != null && !var16.isEmpty()) {
                for (Entity var18 : var16) {
                    if (var18 == this.Parent || this.Parent.isRider(var18) || this.Parent.isChild(var18)) continue;
                    var18.func_70108_f((Entity)this);
                }
            }
            for (int ofsx = -2; ofsx <= 2; ++ofsx) {
                for (int ofsz = -2; ofsz <= 2; ++ofsz) {
                    boolean isWater;
                    int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ofsx));
                    int z = MathHelper.func_76128_c((double)(this.field_70161_v + (double)ofsz));
                    int y = MathHelper.func_76128_c((double)this.field_70163_u);
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    int metadata = this.field_70170_p.func_72805_g(x, y, z);
                    boolean isAir = block == Blocks.field_150350_a;
                    boolean bl = isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
                    if (!isAir && !isWater) {
                        this.field_70132_H = true;
                        this.field_70122_E = true;
                    } else {
                        this.field_70122_E = false;
                    }
                    if (this.field_70132_H && ofsx == 0 && ofsz == 0) {
                        this.field_70124_G = true;
                    }
                    if (block == Blocks.field_150433_aE) {
                        this.field_70170_p.func_147480_a(x, y, z, true);
                        continue;
                    }
                    if (block == Blocks.field_150346_d) {
                        this.applyBlockCollision(x, y, z, 0.75f);
                        continue;
                    }
                    if (block == Blocks.field_150349_c) {
                        this.applyBlockCollision(x, y, z, 0.75f);
                        continue;
                    }
                    if (block == Blocks.field_150354_m) {
                        this.applyBlockCollision(x, y, z, 0.75f);
                        continue;
                    }
                    if (block == Blocks.field_150435_aG) {
                        this.applyBlockCollision(x, y, z, 0.75f);
                        continue;
                    }
                    if (block == Blocks.field_150376_bx) {
                        this.applyBlockCollision(x, y, z, 0.5f);
                        continue;
                    }
                    if (block == Blocks.field_150355_j) {
                        this.field_70124_G = false;
                        continue;
                    }
                    if (block == Blocks.field_150358_i) {
                        this.field_70124_G = false;
                        continue;
                    }
                    if (block == Blocks.field_150392_bi) {
                        Blocks.field_150392_bi.func_149690_a(this.field_70170_p, x, y, z, metadata, 0.3f, 0);
                        this.field_70170_p.func_147480_a(x, y, z, true);
                        continue;
                    }
                    if (block == Blocks.field_150395_bd) {
                        Blocks.field_150395_bd.func_149690_a(this.field_70170_p, x, y, z, metadata, 0.3f, 0);
                        this.field_70170_p.func_147480_a(x, y, z, true);
                        continue;
                    }
                    if (isAir) continue;
                    this.applyBlockCollision(x, y, z, 0.75f);
                }
            }
        }
    }

    public int getBoundingFlags() {
        return this.BoundingFlags;
    }

    public void setBoundingFlags(int _flags) {
        this.BoundingFlags = _flags;
    }

    protected void setBoundingBox() {
        double w = 0.5;
        double h = 0.5;
        double x1 = this.field_70165_t - w;
        double y1 = this.field_70163_u - h;
        double z1 = this.field_70161_v - w;
        double x2 = this.field_70165_t + w;
        double y2 = this.field_70163_u + h;
        double z2 = this.field_70161_v + w;
        switch (this.BoundingFlags) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                break;
            }
            case 64: {
                break;
            }
            case 128: {
                break;
            }
        }
        this.field_70121_D.func_72324_b(x1, y1, z1, x2, y2, z2);
        if (this.isDeck) {
            y1 -= (double)0.05f;
            y2 -= (double)0.05f;
        }
        if (this.collisionBox != null) {
            this.collisionBox.func_72324_b(x1, y1, z1, x2, y2, z2);
        }
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (this.Parent == null || !this.Parent.isUpdating) {
            return false;
        }
        if (this.field_70170_p.field_72995_K && this.Parent != null) {
            boolean shifted;
            boolean bl = shifted = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (this.Parent.isRider((Entity)par1EntityPlayer)) {
                if (this.canInteract) {
                    if (shifted) {
                        this.Parent.sendDismountRequest(par1EntityPlayer);
                    } else if (this.hasChest) {
                        this.Parent.sendOpenCargoRequest(this);
                    } else if (this.hasSeat) {
                        this.Parent.sendMountRequest(this, par1EntityPlayer, (byte)0);
                    } else if (this.Parent.field_70153_n == null) {
                        this.Parent.sendMountRequest(null, par1EntityPlayer, (byte)0);
                    }
                }
            } else if (this.canInteract && this.hasChest) {
                this.Parent.sendOpenCargoRequest(this);
            } else if (!shifted) {
                this.Parent.sendMountRequest(null, par1EntityPlayer, (byte)0);
            }
        }
        return true;
    }

    public void openCargo(EntityPlayer par1EntityPlayer) {
        AwgerLogger.info(SmallBoats.LogLevel, "%s.openCargo(...)", this.field_70170_p.field_72995_K ? "client" : "server");
        if (this.Parent.isRider((Entity)par1EntityPlayer) && this instanceof EntityBoatChest) {
            EntityBoatChest chest = (EntityBoatChest)this;
            if (chest.isOpen()) {
                par1EntityPlayer.func_71053_j();
            } else {
                par1EntityPlayer.func_71007_a((IInventory)chest);
            }
        }
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void func_70098_U() {
        super.func_70098_U();
    }

    public void func_70043_V() {
        if (this.hasSeat && this.field_70153_n != null) {
            double cos1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double sin1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            double cos2 = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double sin2 = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double var1 = cos1 * (double)this.riderOfsX + cos2 * (double)this.riderOfsZ;
            double var3 = sin1 * (double)this.riderOfsX + sin2 * (double)this.riderOfsZ;
            this.field_70153_n.func_70107_b(this.field_70165_t + var1, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + var3);
        }
    }

    protected void func_70076_C() {
        if (this.field_70153_n instanceof EntityPlayer) {
            this.Parent.disembark((EntityPlayer)this.field_70153_n);
        }
        this.func_70106_y();
    }
}

