/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.entity;

import awger.AwgerLogger;
import awger.smallboats.SmallBoats;
import awger.smallboats.client.SBKeyHandler;
import awger.smallboats.entity.EntityBoatChest;
import awger.smallboats.entity.EntityBoatGun;
import awger.smallboats.entity.EntityBoatPart;
import awger.smallboats.entity.PassengerData;
import awger.smallboats.network.EmbarkPacket;
import awger.smallboats.network.OpenCargoPacket;
import awger.smallboats.network.PacketDispatcher;
import awger.smallboats.network.SetFlagPacket;
import awger.smallboats.network.UpdateBoatPositionPacket;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySmallBoat
extends Entity
implements IEntityAdditionalSpawnData {
    public Level LogLevel = Level.ALL;
    protected UUID ParentPersistentID;
    public static final byte ptSyncChildren = 1;
    public static final byte ptSetFlags = 2;
    public static final byte ptSetPosition = 3;
    public static final byte ptMount = 4;
    public static final byte ptDismount = 5;
    public static final byte ptOpenChest = 6;
    public static final int bfNone = 0;
    public static final int bfPort = 1;
    public static final int bfStarboard = 2;
    public static final int bfFore = 4;
    public static final int bfAft = 8;
    public static final int bfTop = 16;
    public static final int bfBottom = 32;
    public static final int bfCenterX = 64;
    public static final int bfCenterY = 128;
    public static final int bfCenterZ = 256;
    public static final byte fNone = 0;
    public static final byte fPassenger = 1;
    private int TrackRider = 1;
    protected boolean isUpdating = false;
    protected boolean isStationary = true;
    public boolean Dev = false;
    private boolean Anchored;
    private boolean Docked;
    private double SpeedMultiplier;
    protected int Color;
    protected int Flags;
    protected float MaxDamage = 250.0f;
    protected double RiderXofs = 1.95;
    protected double RiderYofs = 1.95;
    protected double RiderZofs = 0.35;
    protected double Speed;
    protected double MaxSpeed;
    protected float TackAngle;
    protected float MaxTackAngle;
    protected float TackTarget;
    protected float TackSpeed;
    protected float Heel;
    protected float MaxHeel;
    protected float DefMaxYawDif;
    protected float MaxYawDif = this.DefMaxYawDif = 5.0f;
    protected float prevRotationDelta = 0.0f;
    protected double prevForwardSpeed = 0.0;
    protected double prevStrafeSpeed = 0.0;
    protected double Beam = 1.0;
    protected double LWL = 1.0;
    protected double Displacement = 1.0;
    protected Item BoatItem = null;
    public EntityBoatPart[] BoatParts;
    protected List Passengers;
    private int SavedId;
    private int PartsCount;
    private int SkipCount;
    private boolean PrintInfo;
    private boolean FirstUpdate;
    private Entity Remount;
    private int SaveSneakKeyCode;
    private boolean canBounce;
    private int SuicideCounter = 500;
    public float srvRotationAsst = 0.0f;
    private float srvRotationYaw = 0.0f;
    public boolean RenderChildren = true;
    private EntityPlayer Rider = null;

    private void ConstructorInit() {
        this.SpeedMultiplier = 0.07;
        this.field_70156_m = true;
        this.func_70105_a(0.75f, 0.75f);
        this.field_70129_M = this.field_70131_O * 0.5f;
        this.field_70144_Y = 0.75f;
        this.field_70155_l = 300.0;
        this.Flags = 0;
        this.SkipCount = 0;
        this.TackAngle = 0.0f;
        this.MaxTackAngle = 45.0f;
        this.TackTarget = 0.0f;
        this.TackSpeed = 5.0f;
        this.Heel = 0.0f;
        this.MaxHeel = 10.0f;
        this.MaxSpeed = 15.0;
        this.Color = 0;
        this.Passengers = new ArrayList();
        this.field_70145_X = true;
        this.field_70158_ak = true;
        this.PrintInfo = true;
        this.FirstUpdate = true;
        this.Remount = null;
        this.canBounce = true;
    }

    public EntitySmallBoat(World par1World) {
        super(par1World);
        AwgerLogger.log(this.LogLevel, String.format("%s: instantiating generic EntitySmallBoat(%d)", par1World.field_72995_K ? "client" : "server", this.func_145782_y()), new Object[0]);
        this.ConstructorInit();
        this.SavedId = this.func_145782_y();
    }

    public EntitySmallBoat(World par1World, double par2, double par4, double par6) {
        super(par1World);
        AwgerLogger.log(this.LogLevel, String.format("%s: instantiating EntitySmallBoat(%d) with position%s", par1World.field_72995_K ? "client" : "server", this.func_145782_y(), par1World.field_72995_K ? "" : " and children"), new Object[0]);
        this.ConstructorInit();
        this.generateParentPersistentID();
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.savePositionAndRotation();
        if (!par1World.field_72995_K) {
            this.createDescendentChildren();
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.ParentPersistentID != null) {
            buffer.writeLong(this.ParentPersistentID.getMostSignificantBits());
            buffer.writeLong(this.ParentPersistentID.getLeastSignificantBits());
        } else {
            AwgerLogger.log(this.LogLevel, String.format("%s: !! writing zero ParentUUID for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y()), new Object[0]);
            buffer.writeLong(0L);
            buffer.writeLong(0L);
        }
        buffer.writeInt(this.BoatParts.length);
        buffer.writeInt(this.Color);
        buffer.writeBoolean(this.Anchored);
        buffer.writeBoolean(this.Docked);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setParentPersistentID(new UUID(buffer.readLong(), buffer.readLong()));
        int count = buffer.readInt();
        this.BoatParts = new EntityBoatPart[count];
        this.PartsCount = 0;
        this.Color = buffer.readInt();
        this.Anchored = buffer.readBoolean();
        this.Docked = buffer.readBoolean();
        this.isStationary = true;
    }

    public UUID getParentPersistentID() {
        return this.ParentPersistentID;
    }

    public void generateParentPersistentID() {
        this.ParentPersistentID = UUID.randomUUID();
        AwgerLogger.log(this.LogLevel, String.format("%s.generateParentPersistentID for %d, = %s", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y(), this.ParentPersistentID.toString()), new Object[0]);
    }

    public void setParentPersistentID(UUID _uuid) {
        this.ParentPersistentID = _uuid;
        AwgerLogger.log(this.LogLevel, String.format("%s.setParentPersistentID for %d, = %s", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y(), this.ParentPersistentID.toString()), new Object[0]);
    }

    private void createDescendentChildren() {
        AwgerLogger.log(this.LogLevel, String.format("%s: createDescendentChildren() for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y()), new Object[0]);
        Class<?> c = ((Object)((Object)this)).getClass();
        Class[] paramTypes = new Class[]{};
        try {
            Method method = c.getMethod("createChildren", paramTypes);
            method.invoke(c.cast((Object)this), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPart(EntityBoatPart _part) {
        AwgerLogger.log(this.LogLevel, String.format("%s.addPart(%d)", this.field_70170_p.field_72995_K ? "client" : "server", _part.func_145782_y()), new Object[0]);
        if (this.PartsCount < this.BoatParts.length) {
            this.BoatParts[this.PartsCount] = _part instanceof EntityBoatGun ? (EntityBoatGun)_part : (_part instanceof EntityBoatChest ? (EntityBoatChest)_part : _part);
            ++this.PartsCount;
        } else {
            AwgerLogger.log(this.LogLevel, String.format("** too many parts", new Object[0]), new Object[0]);
        }
        if (this.PartsCount == this.BoatParts.length && !this.Dev) {
            AwgerLogger.log(this.LogLevel, String.format("** turning stationary OFF", new Object[0]), new Object[0]);
            this.isStationary = false;
            this.setAnchored(true);
        }
    }

    public void addToWorld(World world) {
        AwgerLogger.log(this.LogLevel, String.format("%s.EntitySmallBoat.addToWorld()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        world.func_72838_d((Entity)this);
        this.addChildrenToWorld(world);
    }

    public void addChildrenToWorld(World world) {
        AwgerLogger.log(this.LogLevel, String.format("%s.addChildrenToWorld()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        if (this.BoatParts == null) {
            AwgerLogger.log(this.LogLevel, String.format("\t** BoatParts not initialized", new Object[0]), new Object[0]);
            return;
        }
        this.syncChildren();
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if (this.field_70170_p.field_72996_f.contains((Object)this.BoatParts[i])) continue;
            if (this.BoatParts[i] instanceof EntityBoatGun) {
                if (world.func_72838_d((Entity)((EntityBoatGun)this.BoatParts[i]))) {
                    AwgerLogger.log(this.LogLevel, String.format("\t** EntityBoatGun %d added to world", this.BoatParts[i].func_145782_y()), new Object[0]);
                    continue;
                }
                AwgerLogger.log(this.LogLevel, String.format("\t!! error adding EntityBoatGun %d to world", this.BoatParts[i].func_145782_y()), new Object[0]);
                continue;
            }
            if (this.BoatParts[i] instanceof EntityBoatChest) {
                if (world.func_72838_d((Entity)((EntityBoatChest)this.BoatParts[i]))) {
                    AwgerLogger.log(this.LogLevel, String.format("\t** EntityBoatChest %d added to world", this.BoatParts[i].func_145782_y()), new Object[0]);
                    continue;
                }
                AwgerLogger.log(this.LogLevel, String.format("\t!! error adding EntityBoatChest %d to world", this.BoatParts[i].func_145782_y()), new Object[0]);
                continue;
            }
            if (world.func_72838_d((Entity)this.BoatParts[i])) {
                AwgerLogger.log(this.LogLevel, String.format("\t** EntityBoatPart %d added to world", this.BoatParts[i].func_145782_y()), new Object[0]);
                continue;
            }
            AwgerLogger.log(this.LogLevel, String.format("\t!! error adding EntityBoatPart %d to world", this.BoatParts[i].func_145782_y()), new Object[0]);
        }
    }

    public boolean renderParent() {
        return true;
    }

    public void updateChildIds() {
        this.Flags |= 1;
        this.updateServerFlags();
    }

    private void updateServerFlags() {
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new SetFlagPacket(this));
        }
    }

    private void updateServerPosition() {
        if (this.field_70170_p.field_72995_K) {
            this.srvRotationYaw = this.field_70177_z;
            PacketDispatcher.sendToServer(new UpdateBoatPositionPacket(this));
        }
    }

    public void updateClientPosition() {
        AwgerLogger.log(this.LogLevel, String.format("%s.updateClientPosition()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        if (!this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToAllAround(new UpdateBoatPositionPacket(this), this.field_70170_p.func_72912_H().func_76076_i(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0);
        }
    }

    public void sendMountRequest(Entity child, EntityPlayer player, byte flags) {
        AwgerLogger.log(this.LogLevel, String.format("%s.sendMountRequest()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new EmbarkPacket(player, this, child, flags));
        }
    }

    private void sendMountUpdate(Entity child, EntityPlayer player, byte flags) {
        AwgerLogger.log(this.LogLevel, String.format("%s.sendMountUpdate()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        if (!this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToAllAround(new EmbarkPacket(player, this, child, flags), player, 128.0);
        }
    }

    public void sendDismountRequest(EntityPlayer player) {
        AwgerLogger.log(this.LogLevel, String.format("%s.sendDismountRequest()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new EmbarkPacket(player, this));
        }
    }

    private void sendDismountUpdate(EntityPlayer player) {
        AwgerLogger.log(this.LogLevel, String.format("%s.sendDismountUpdate()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        if (!this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToAllAround(new EmbarkPacket(player, this), player, 128.0);
        }
    }

    public void sendOpenCargoRequest(Entity child) {
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new OpenCargoPacket(this, child));
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        AwgerLogger.log(this.LogLevel, String.format("%s(%d).attackEntityFrom()", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y()), new Object[0]);
        return false;
    }

    public boolean attackEntityFromPart(DamageSource par1DamageSource, float par2) {
        AwgerLogger.log(SmallBoats.LogLevel, String.format("%s(%d).attackEntityFromPart(%f)", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y(), Float.valueOf(par2)), new Object[0]);
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + par2);
            this.func_70018_K();
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.setDamageTaken(this.MaxDamage + 1.0f);
            }
            if (this.getDamageTaken() > this.MaxDamage) {
                this.killBoat(true);
            } else {
                AwgerLogger.log(SmallBoats.LogLevel, String.format("\t*** damage = %f of %f", Float.valueOf(this.getDamageTaken()), Float.valueOf(this.MaxDamage)), new Object[0]);
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    protected void func_70076_C() {
        if (this.field_70153_n instanceof EntityPlayer) {
            this.disembark((EntityPlayer)this.field_70153_n);
        }
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if (this.BoatParts[i] == null) continue;
            this.BoatParts[i].func_70076_C();
        }
        this.func_70106_y();
    }

    public void recreateBoat() {
        Class<?> c = ((Object)((Object)this)).getClass();
        Class[] paramTypes = new Class[]{World.class, Double.TYPE, Double.TYPE, Double.TYPE};
        try {
            Constructor<?> constructor = c.getConstructor(paramTypes);
            EntitySmallBoat copy = (EntitySmallBoat)((Object)constructor.newInstance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            copy.setItem(this.getItem());
            copy.setColor(this.getColor());
            copy.addToWorld(this.field_70170_p);
            copy.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.func_70076_C();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void killBoat(boolean _dropboat) {
        AwgerLogger.log(this.LogLevel, String.format("%s: killBoat(%s)", this.field_70170_p.field_72995_K ? "client" : "server", _dropboat ? "true" : "false"), new Object[0]);
        this.func_70076_C();
        if (_dropboat) {
            this.func_70099_a(new ItemStack(this.getItem()), 0.0f);
        }
    }

    public void setBoundingBox() {
        float var7 = this.field_70130_N / 2.0f;
        double top = this.field_70163_u - (double)this.field_70131_O + (double)this.field_70129_M;
        double bottom = this.field_70163_u + (double)this.field_70129_M;
        this.field_70121_D.func_72324_b(this.field_70165_t - (double)var7, top, this.field_70161_v - (double)var7, this.field_70165_t + (double)var7, bottom, this.field_70161_v + (double)var7);
    }

    public void func_70107_b(double _x, double _y, double _z) {
        this.field_70165_t = _x;
        this.field_70163_u = _y;
        this.field_70161_v = _z;
        this.setBoundingBox();
    }

    protected void func_70101_b(float par1, float par2) {
        this.field_70177_z = par1 % 360.0f;
        this.field_70125_A = par2 % 360.0f;
    }

    protected void setRotation2(float par1, float par2) {
        this.field_70177_z = par1 % 360.0f;
        this.field_70125_A = par2 % 360.0f;
    }

    protected void setRotation3(float par1, float par2) {
        this.field_70177_z = par1 % 360.0f;
        this.field_70125_A = par2 % 360.0f;
    }

    public void savePositionAndRotation() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_70080_a(double _x, double _y, double _z, float _yaw, float _pitch) {
        this.func_70107_b(_x, _y, _z);
        this.func_70101_b(_yaw, _pitch);
    }

    public void func_70056_a(double _x, double _y, double _z, float _yaw, float _pitch, int par9) {
        this.isUpdating = true;
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (this.field_70153_n != mc.field_71439_g) {
            this.func_70107_b(_x, _y, _z);
            this.setRotation2(_yaw, _pitch);
        }
    }

    public void setPositionAndRotation3(double _x, double _y, double _z, float _yaw, float _pitch) {
        this.func_70107_b(_x, _y, _z);
        this.setRotation3(_yaw, _pitch);
    }

    private void syncChildren() {
        if (this.BoatParts == null) {
            return;
        }
        double cos1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
        double sin1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
        double cos2 = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
        double sin2 = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if (this.BoatParts[i] == null) continue;
            double var1 = cos1 * (double)this.BoatParts[i].posOfsX + cos2 * (double)this.BoatParts[i].posOfsZ;
            double var2 = this.BoatParts[i].posOfsY;
            double var3 = sin1 * (double)this.BoatParts[i].posOfsX + sin2 * (double)this.BoatParts[i].posOfsZ;
            this.BoatParts[i].func_70012_b(this.field_70165_t + var1, this.field_70163_u + var2, this.field_70161_v + var3, this.field_70177_z, 0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        return p_70112_1_ < 64.0 * this.field_70155_l;
    }

    public void func_70071_h_() {
        float m;
        boolean isWater;
        this.savePositionAndRotation();
        this.func_70072_I();
        if (this.PrintInfo) {
            AwgerLogger.log(Level.FINEST, String.format("%s.onUpdate(), Flags = %d, DamageTaken = %f", this.field_70170_p.field_72995_K ? "client" : "server", this.getFlags(), Float.valueOf(this.getDamageTaken())), new Object[0]);
            AwgerLogger.log(Level.FINEST, String.format("\tuuid = %s", this.getParentPersistentID().toString()), new Object[0]);
            AwgerLogger.log(Level.FINEST, String.format("\tentityId = %d", this.func_145782_y()), new Object[0]);
            this.PrintInfo = false;
        }
        if (this.field_70128_L) {
            AwgerLogger.log(this.LogLevel, String.format("\t!! %s.parent is dead!", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
            return;
        }
        if (this.BoatParts == null) {
            AwgerLogger.log(this.LogLevel, String.format("\t!! %s.parent has no parts", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
            return;
        }
        if (this.PartsCount != this.BoatParts.length) {
            if (this.SuicideCounter % 100 == 0) {
                AwgerLogger.log(this.LogLevel, String.format("!! parent %d (%s) is missing parts", this.func_145782_y(), this.getParentPersistentID().toString()), new Object[0]);
            }
            --this.SuicideCounter;
            if (this.SuicideCounter <= 0) {
                AwgerLogger.log(Level.SEVERE, String.format("!! parent %d (%s) couldn't find children -- killing & recreating boat", this.func_145782_y(), this.getParentPersistentID().toString()), new Object[0]);
                this.recreateBoat();
            }
            return;
        }
        if (this.SavedId != this.func_145782_y()) {
            AwgerLogger.log(this.LogLevel, String.format("!! %s.EntitySmallBoat.entityId changed to %d", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y()), new Object[0]);
            this.SavedId = this.func_145782_y();
            this.updateChildIds();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.isStationary && !this.Dev) {
            AwgerLogger.log(this.LogLevel, String.format("!! %s: isStationary", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
            return;
        }
        if (this.FirstUpdate) {
            AwgerLogger.log(this.LogLevel, String.format("!! %s: FirstUpdate", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
            this.calcDisplacement();
            this.setBoundingBox();
            this.addChildrenToWorld(this.field_70170_p);
            this.syncChildren();
            if (this.field_70153_n != null) {
                AwgerLogger.log(this.LogLevel, String.format("!! rider already mounted, scheduling remount", new Object[0]), new Object[0]);
                this.Remount = this.field_70153_n;
                this.field_70153_n.func_70078_a((Entity)this);
                this.field_70153_n = null;
            }
            this.FirstUpdate = false;
        }
        if (this.Rider != null && this.field_70153_n == null) {
            AwgerLogger.log(this.LogLevel, String.format("!! %s lost my rider!", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
            this.disembark(this.Rider);
            this.Rider = null;
        }
        if (!this.field_70170_p.field_72995_K) {
            --this.SkipCount;
            if (this.SkipCount <= 0) {
                if (this.BoatParts == null || this.PartsCount != this.BoatParts.length) {
                    this.func_70106_y();
                }
                this.SkipCount = 48;
            }
        } else if (this.BoatParts != null) {
            --this.SkipCount;
            if (this.SkipCount <= 0) {
                Minecraft mc = FMLClientHandler.instance().getClient();
                if (this.field_70153_n == mc.field_71439_g) {
                    this.updateServerPosition();
                }
                if (this.getDamageTaken() > 0.0f) {
                    this.setDamageTaken(this.getDamageTaken() - 1.0f);
                }
                this.SkipCount = 8;
            }
        }
        if (this.Remount instanceof EntityPlayer && this.isUpdating) {
            this.sendMountRequest(null, (EntityPlayer)this.Remount, (byte)0);
            this.Remount = null;
        }
        int var1 = 5;
        double var2 = 0.0;
        for (int var4 = 0; var4 < var1; ++var4) {
            double var5 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var4 + 0) / (double)var1 - 0.125;
            double var7 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var4 + 1) / (double)var1 - 0.125;
            AxisAlignedBB var9 = AxisAlignedBB.func_72330_a((double)this.field_70121_D.field_72340_a, (double)var5, (double)this.field_70121_D.field_72339_c, (double)this.field_70121_D.field_72336_d, (double)var7, (double)this.field_70121_D.field_72334_f);
            if (this.PrintInfo) {
                AwgerLogger.log(this.LogLevel, String.format("\t minY=%f, maxY=%f", this.field_70121_D.field_72338_b, this.field_70121_D.field_72337_e), new Object[0]);
                AwgerLogger.log(this.LogLevel, String.format("\t var5=%f, var7=%f", var5, var7), new Object[0]);
                this.PrintInfo = false;
            }
            if (this.field_70170_p.func_72830_b(var9, Material.field_151586_h)) {
                var2 += 1.0 / (double)var1;
                continue;
            }
            if (!this.field_70170_p.func_72830_b(var9, Material.field_151579_a)) continue;
            var2 += 0.01;
        }
        double var24 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.Speed = var24 * 60.0;
        double var6 = 0.0;
        double var8 = 0.0;
        if (var24 > 0.25) {
            var6 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            var8 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            int var10 = 0;
            while ((double)var10 < 1.0 + this.Speed) {
                double var17;
                double var15;
                double var11 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double var13 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    var15 = this.field_70165_t - var6 * var11 * 0.8 + var8 * var13;
                    var17 = this.field_70161_v - var8 * var11 * 0.8 - var6 * var13;
                    this.field_70170_p.func_72869_a("splash", var15, this.field_70163_u - 0.125, var17, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                } else {
                    var15 = this.field_70165_t + var6 + var8 * var11 * 0.7;
                    var17 = this.field_70161_v + var8 - var6 * var11 * 0.7;
                    this.field_70170_p.func_72869_a("splash", var15, this.field_70163_u - 0.125, var17, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                ++var10;
            }
        }
        double var12 = 0.0;
        double var26 = 0.0;
        double disp_delta = this.Displacement / 10.0;
        if (disp_delta < 2.0) {
            disp_delta = 2.0;
        }
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.75));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        int metadata = this.field_70170_p.func_72805_g(x, y, z);
        boolean isAir = block == Blocks.field_150350_a;
        boolean bl = isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
        if (this.childIsOnGround() || this.field_70123_F || this.field_70124_G) {
            this.field_70122_E = true;
            this.field_70132_H = true;
        } else {
            this.field_70122_E = false;
            this.field_70132_H = false;
        }
        if (this.canBounce) {
            if (var2 < 0.5) {
                var6 = var2 * 2.0 - 1.0;
                this.field_70181_x += (double)0.04f * var6 / disp_delta;
            } else {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x /= 2.0;
                }
                this.field_70181_x += (double)0.007f / disp_delta;
            }
            if (isAir) {
                this.field_70181_x = -0.025;
            } else if (!isWater) {
                this.field_70122_E = true;
                this.field_70181_x = 0.0;
            }
        } else if (this.field_70153_n != null) {
            this.field_70181_x = 0.0;
        } else if (isAir) {
            this.field_70181_x = -0.0025;
        } else if (isWater) {
            this.field_70181_x = 0.0025;
        }
        if (this.field_70153_n == null) {
            this.setAnchored(true);
        }
        float heading = this.yaw2heading(this.field_70177_z);
        float rider_yaw = 0.0f;
        float dif = 0.0f;
        if (!(this.Docked || this.Anchored || this.field_70122_E)) {
            double max_vector;
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                if (this.field_70170_p.field_72995_K) {
                    var12 = Math.sin(heading * (float)Math.PI / 180.0f);
                    var26 = Math.cos(heading * (float)Math.PI / 180.0f);
                    var6 = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
                    if (this.prevForwardSpeed > 0.05 && var6 < 0.0) {
                        disp_delta = this.prevForwardSpeed - var6;
                        if (disp_delta > 0.03) {
                            disp_delta = 0.03;
                        }
                        var6 -= this.prevForwardSpeed;
                    } else if (this.prevForwardSpeed < 0.05 && var6 > 0.0) {
                        disp_delta = var6 - this.prevForwardSpeed;
                        if (disp_delta > 0.03) {
                            disp_delta = 0.03;
                        }
                        var6 += this.prevForwardSpeed;
                    }
                    if (var6 > 0.0) {
                        this.field_70159_w += var26 * this.SpeedMultiplier * 0.05;
                        this.field_70179_y += var12 * this.SpeedMultiplier * 0.05;
                    } else if (var6 < 0.0 && (var6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) < 0.25) {
                        this.field_70159_w -= var26 * this.SpeedMultiplier * 0.05;
                        this.field_70179_y -= var12 * this.SpeedMultiplier * 0.05;
                    }
                    this.prevForwardSpeed = var6;
                    if (SBKeyHandler.keys[0].func_151470_d()) {
                        float limit;
                        rider_yaw = this.yaw2heading(this.field_70153_n.field_70177_z + 90.0f);
                        dif = this.getHeadingDif(heading, rider_yaw);
                        if (dif > (limit = 65.0f)) {
                            dif = limit;
                        }
                        if (dif < -limit) {
                            dif = -limit;
                        }
                        var12 = Math.sin((heading += dif) * (float)Math.PI / 180.0f);
                        var26 = Math.cos(heading * (float)Math.PI / 180.0f);
                        var6 = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
                        if (var6 > 0.0) {
                            this.field_70159_w += var26 * this.SpeedMultiplier * 0.025;
                            this.field_70179_y += var12 * this.SpeedMultiplier * 0.025;
                        } else if (var6 < 0.0) {
                            this.field_70159_w -= var26 * this.SpeedMultiplier * 0.025;
                            this.field_70179_y -= var12 * this.SpeedMultiplier * 0.025;
                        }
                    } else {
                        var6 = (double)((EntityLivingBase)this.field_70153_n).field_70702_br * 0.25;
                        if (this.prevStrafeSpeed > 0.25 && var6 >= 0.0) {
                            disp_delta = this.prevStrafeSpeed - var6;
                            if (disp_delta > 0.15) {
                                var6 += disp_delta * 0.5;
                            }
                        } else if (this.prevStrafeSpeed < 0.25 && var6 <= 0.0 && (disp_delta = var6 - this.prevStrafeSpeed) > 0.15) {
                            var6 -= disp_delta * 0.5;
                        }
                        if (var6 > 0.0) {
                            this.field_70159_w += var12 * this.SpeedMultiplier * 0.025;
                            this.field_70179_y -= var26 * this.SpeedMultiplier * 0.025;
                        } else if (var6 < 0.0) {
                            this.field_70159_w -= var12 * this.SpeedMultiplier * 0.025;
                            this.field_70179_y += var26 * this.SpeedMultiplier * 0.025;
                        }
                        this.prevStrafeSpeed = var6;
                    }
                }
            } else {
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.99;
                this.field_70179_y *= 0.99;
            }
            if ((var6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > (max_vector = this.MaxSpeed / 60.0)) {
                var8 = max_vector / var6;
                this.field_70159_w *= var8;
                this.field_70179_y *= var8;
                var6 = max_vector;
            }
            if (var6 > var24 && this.SpeedMultiplier < 0.35) {
                this.SpeedMultiplier += (0.35 - this.SpeedMultiplier) / 35.0;
                if (this.SpeedMultiplier > 0.35) {
                    this.SpeedMultiplier = 0.35;
                }
            } else {
                this.SpeedMultiplier -= (this.SpeedMultiplier - 0.07) / 35.0;
                if (this.SpeedMultiplier < 0.07) {
                    this.SpeedMultiplier = 0.07;
                }
            }
        }
        if (this.Docked || this.Anchored) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        this.updatePassengerOffset();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70123_F && var24 > 0.5) {
            if (!this.field_70170_p.field_72995_K) {
                int var25;
                this.killBoat(false);
                for (var25 = 0; var25 < 3; ++var25) {
                    this.func_70099_a(new ItemStack(Blocks.field_150344_f), 0.0f);
                }
                for (var25 = 0; var25 < 2; ++var25) {
                    this.func_70099_a(new ItemStack(Items.field_151055_y), 0.0f);
                }
            }
        } else {
            this.field_70159_w *= (double)0.99f;
            this.field_70181_x *= (double)0.95f;
            this.field_70179_y *= (double)0.99f;
        }
        this.field_70125_A = 0.0f;
        double d4 = this.field_70177_z;
        double d11 = this.field_70169_q - this.field_70165_t;
        double d12 = this.field_70166_s - this.field_70161_v;
        float RotDelta = 0.0f;
        if (d11 * d11 + d12 * d12 > 0.001) {
            d4 = (float)(Math.atan2(-d12, -d11) * 180.0 / Math.PI);
        }
        if ((dif = (float)MathHelper.func_76138_g((double)(d4 - (double)this.field_70177_z))) > (m = this.MaxYawDif / 1.25f)) {
            dif = m;
        } else if (dif < -m) {
            dif = -m;
        }
        RotDelta += dif;
        if (this.field_70170_p.field_72995_K) {
            m = 0.0f;
            dif = 0.0f;
            if (RotDelta > this.MaxYawDif) {
                RotDelta = this.MaxYawDif;
            } else if (RotDelta < -this.MaxYawDif) {
                RotDelta = -this.MaxYawDif;
            }
            this.field_70177_z += RotDelta;
            this.setRotation2(this.field_70177_z, this.field_70125_A);
            this.srvRotationAsst = this.field_70177_z - this.srvRotationYaw;
            if (this.srvRotationAsst > 5.0f || this.srvRotationAsst < -5.0f) {
                this.updateServerPosition();
            }
            this.prevRotationDelta = RotDelta;
        } else {
            this.srvRotationAsst = this.srvRotationAsst > 1.0f ? (this.srvRotationAsst -= 1.0f) : (this.srvRotationAsst < -1.0f ? (this.srvRotationAsst += 1.0f) : 0.0f);
            this.func_70101_b(this.field_70177_z + this.srvRotationAsst * 0.65f, this.field_70125_A);
        }
        m = this.MaxYawDif / 3.0f;
        if (this.field_70153_n == null) {
            this.TackTarget = 0.0f;
        } else if (RotDelta > m) {
            this.TackTarget = -this.MaxTackAngle;
        } else if (RotDelta < -m) {
            this.TackTarget = this.MaxTackAngle;
        }
        if (this.TackAngle > this.TackTarget) {
            this.TackAngle -= this.TackSpeed;
            if (this.TackAngle < this.TackTarget) {
                this.TackAngle = this.TackTarget;
            }
        } else if (this.TackAngle < this.TackTarget) {
            this.TackAngle += this.TackSpeed;
            if (this.TackAngle > this.TackTarget) {
                this.TackAngle = this.TackTarget;
            }
        }
        float lastheel = this.Heel;
        this.Heel = this.Speed < 5.0 ? 0.0f : this.MaxHeel * (float)((this.Speed - 5.0) / this.MaxSpeed) * (float)(this.TackAngle > 0.0f ? 1 : -1);
        if (this.Heel > lastheel && this.Heel - lastheel > 1.0f) {
            this.Heel = lastheel + 2.0f;
        } else if (lastheel > this.Heel && lastheel - this.Heel > 1.0f) {
            this.Heel = lastheel - 2.0f;
        }
        if (this.Heel > this.MaxHeel) {
            this.Heel = this.MaxHeel;
        }
        if (this.Heel < -this.MaxHeel) {
            this.Heel = -this.MaxHeel;
        }
        this.setBoundingBox();
        this.syncChildren();
        this.updatePassengerPosition();
        if (!this.field_70170_p.field_72995_K && !this.Docked && !this.Anchored && this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
    }

    protected boolean childIsOnGround() {
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !this.BoatParts[i].field_70122_E && !this.BoatParts[i].field_70124_G) continue;
                return true;
            }
        }
        return false;
    }

    public void func_70108_f(Entity par1Entity) {
        double var4;
        double var2;
        double var6;
        if (this.isStationary) {
            return;
        }
        if ((this.Docked || this.Anchored) && par1Entity instanceof EntityLiving) {
            return;
        }
        if (this.isChild(par1Entity)) {
            return;
        }
        if (!this.isRider(par1Entity) && (var6 = MathHelper.func_76132_a((double)(var2 = par1Entity.field_70165_t - this.field_70165_t), (double)(var4 = par1Entity.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            var6 = MathHelper.func_76133_a((double)var6);
            var2 /= var6;
            var4 /= var6;
            double var8 = 1.0 / var6;
            if (var8 > 1.0) {
                var8 = 1.0;
            }
            var2 *= var8;
            var4 *= var8;
            var2 *= (double)0.05f;
            var4 *= (double)0.05f;
            this.func_70024_g(-((var2 *= (double)(1.0f - this.field_70144_Y)) * 0.1), 0.0, -((var4 *= (double)(1.0f - this.field_70144_Y)) * 0.1));
            par1Entity.func_70024_g(var2, 0.0, var4);
        }
        this.updateServerPosition();
    }

    public void applyBlockCollision(float x, float y, float z, float magnitude) {
        if (this.isStationary) {
            return;
        }
        double var2 = (double)x - this.field_70165_t;
        double var4 = (double)z - this.field_70161_v;
        double var6 = MathHelper.func_76132_a((double)var2, (double)var4);
        if (!this.Docked && !this.Anchored) {
            double var14;
            var6 = MathHelper.func_76133_a((double)var6);
            var2 /= var6;
            var4 /= var6;
            double var8 = 1.0 / var6;
            if (var8 > 1.0) {
                var8 = 1.0;
            }
            var2 *= var8;
            var4 *= var8;
            var2 *= (double)0.05f;
            var4 *= (double)0.05f;
            this.func_70024_g(-(var2 *= (double)(1.0f - this.field_70144_Y)), 0.0, -(var4 *= (double)(1.0f - this.field_70144_Y)));
            this.field_70159_w *= (double)magnitude;
            this.field_70181_x = 0.0;
            this.field_70179_y *= (double)magnitude;
            var8 = this.field_70177_z;
            double var26 = (double)x - this.field_70165_t;
            double var12 = (double)z - this.field_70161_v;
            if (var26 * var26 + var12 * var12 > 1.0) {
                var8 = (float)(Math.atan2(var12, var26) * 180.0 / Math.PI);
            }
            if ((var14 = MathHelper.func_76138_g((double)(var8 - (double)this.field_70177_z)) * (double)0.35f) > 2.5) {
                var14 = 2.5;
            }
            if (var14 < -2.5) {
                var14 = -2.5;
            }
            this.func_70101_b(this.field_70177_z + (float)var14, this.field_70125_A);
        }
        this.updateServerPosition();
    }

    public void func_70043_V() {
        this.updateRiderPosition(this.RiderXofs, this.RiderZofs);
    }

    public void updateRiderPosition(double _xOfs, double _zOfs) {
        this.updateRiderPosition(_xOfs, _zOfs, false);
    }

    public void updateRiderPosition(double _xOfs, double _zOfs, boolean _force) {
        if (this.Rider == null) {
            AwgerLogger.log(this.LogLevel, String.format("\t** no rider", new Object[0]), new Object[0]);
            this.TackTarget = 0.0f;
        } else {
            double cos1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double sin1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            double cos2 = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double sin2 = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double z = _zOfs;
            if (this.TackTarget > 0.0f) {
                z *= -1.0;
            }
            double x = cos1 * _xOfs + cos2 * z;
            z = sin1 * _xOfs + sin2 * z;
            double y = this.field_70163_u + this.RiderYofs + this.Rider.func_70033_W();
            while (!this.field_70170_p.func_147437_c((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z))) {
                y += 1.0;
            }
            if (_force) {
                this.Rider.func_70634_a(this.field_70165_t + x, y, this.field_70161_v + z);
            } else {
                this.Rider.func_70107_b(this.field_70165_t + x, y, this.field_70161_v + z);
            }
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74772_a("ParentUUID_MSB", this.getParentPersistentID().getMostSignificantBits());
        compound.func_74772_a("ParentUUID_LSB", this.getParentPersistentID().getLeastSignificantBits());
        compound.func_74768_a("boatItem", Item.func_150891_b((Item)this.BoatItem));
        compound.func_74768_a("Color", this.Color);
        if (this.BoatParts != null) {
            compound.func_74768_a("ChildCount", this.BoatParts.length);
        } else {
            compound.func_74768_a("ChildCount", 0);
        }
        compound.func_74757_a("Anchored", this.Anchored);
        compound.func_74757_a("Docked", this.Docked);
        AwgerLogger.log(this.LogLevel, String.format("** wrote parent %s to NBT", this.getParentPersistentID().toString()), new Object[0]);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setParentPersistentID(new UUID(compound.func_74763_f("ParentUUID_MSB"), compound.func_74763_f("ParentUUID_LSB")));
        this.BoatItem = Item.func_150899_d((int)compound.func_74762_e("boatItem"));
        this.Color = compound.func_74762_e("Color");
        int count = compound.func_74762_e("ChildCount");
        this.BoatParts = new EntityBoatPart[count];
        this.PartsCount = 0;
        this.Anchored = compound.func_74767_n("Anchored");
        this.Docked = compound.func_74767_n("Docked");
        AwgerLogger.log(this.LogLevel, String.format("** read parent %s from NBT", this.getParentPersistentID().toString()), new Object[0]);
        this.SkipCount = 96;
        this.PrintInfo = true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        AwgerLogger.log(this.LogLevel, String.format("%s.parent.interactFirst()", this.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        return true;
    }

    public void openCargo(Entity child, EntityPlayer player) {
        AwgerLogger.log(this.LogLevel, String.format("%s.parent.openCargo(%s, %s)", this.field_70170_p.field_72995_K ? "client" : "server", child, player.func_70005_c_()), new Object[0]);
        if (this.isChild(child)) {
            ((EntityBoatPart)child).openCargo(player);
        } else {
            AwgerLogger.log(this.LogLevel, String.format("\t*** not a child", new Object[0]), new Object[0]);
        }
    }

    public void embark(int _childID, EntityPlayer player, byte _flags) {
        AwgerLogger.log(this.LogLevel, String.format("%s.parent.embark(%d, %s, %02X)", this.field_70170_p.field_72995_K ? "client" : "server", _childID, player.func_70005_c_(), _flags), new Object[0]);
        Entity seat = null;
        Entity child = this.getChildById(_childID);
        if (this.func_145782_y() == _childID) {
            child = this;
        } else if (child == null && (child = this.field_70170_p.func_73045_a(_childID)) == null) {
            AwgerLogger.log(this.LogLevel, String.format("\t!! child %d not found in world", _childID), new Object[0]);
        }
        this.Rider = player;
        if (this.field_70170_p.field_72995_K) {
            AwgerLogger.log(Level.FINE, String.format("\t** player %d boarded %d.%d", player.func_145782_y(), this.func_145782_y(), _childID), new Object[0]);
            if (_flags == 0) {
                this.setAnchored(false);
                this.setDocked(false);
            } else {
                this.addPassenger((Entity)player);
                this.updateServerPosition();
            }
        } else if (player != null && (_flags & 2) == 0) {
            if ((_flags & 1) != 0) {
                this.addPassenger((Entity)player);
            } else {
                if (player.field_70154_o != null) {
                    player.func_70078_a(null);
                }
                if (this.isChild(child)) {
                    if (child.field_70153_n != null) {
                        AwgerLogger.log(this.LogLevel, String.format("\t!! child %d already has rider %d", _childID, child.field_70153_n.func_145782_y()), new Object[0]);
                    }
                    AwgerLogger.log(this.LogLevel, String.format("\t** mounting child %d", _childID), new Object[0]);
                    player.func_70078_a(child);
                    seat = child;
                } else if (this.field_70153_n == null) {
                    AwgerLogger.log(this.LogLevel, String.format("\t** mounting parent", new Object[0]), new Object[0]);
                    player.func_70078_a((Entity)this);
                    seat = this;
                    this.setAnchored(false);
                    this.setDocked(false);
                } else if (this.BoatParts != null) {
                    AwgerLogger.log(this.LogLevel, String.format("\t** mounting next available", new Object[0]), new Object[0]);
                    for (int i = 0; i < this.BoatParts.length; ++i) {
                        if (this.BoatParts[i] == null || !this.BoatParts[i].hasSeat || this.BoatParts[i].field_70153_n != null) continue;
                        seat = this.BoatParts[i];
                        AwgerLogger.log(this.LogLevel, String.format("\t** mounting %d", seat.func_145782_y()), new Object[0]);
                        player.func_70078_a(seat);
                        i = this.BoatParts.length;
                    }
                } else {
                    AwgerLogger.log(this.LogLevel, String.format("\t** no entity to mount?", new Object[0]), new Object[0]);
                }
            }
            if (seat != null) {
                this.sendMountUpdate(seat, player, _flags);
            }
        } else {
            AwgerLogger.log(this.LogLevel, "\t** embarking player was null", new Object[0]);
        }
    }

    public void disembark(EntityPlayer player) {
        AwgerLogger.log(this.LogLevel, String.format("%s.Dismount(%s)", this.field_70170_p.field_72995_K ? "client" : "server", player.func_70005_c_()), new Object[0]);
        this.updateServerPosition();
        if (player != null) {
            AwgerLogger.log(this.LogLevel, String.format("\t** player %d disembarked %d", player.func_145782_y(), this.func_145782_y()), new Object[0]);
            if (this.field_70153_n == player) {
                player.func_70078_a(null);
            } else if (this.BoatParts != null) {
                for (int i = 0; i < this.BoatParts.length; ++i) {
                    if (this.BoatParts[i].field_70153_n != player) continue;
                    player.func_70078_a((Entity)this.BoatParts[i]);
                }
            }
            double ofs = this.TackTarget > 0.0f ? this.Beam / 2.0 : -(this.Beam / 2.0);
            AwgerLogger.log(this.LogLevel, String.format("\tTackTarget=%f, ofs=%f", Float.valueOf(this.TackTarget), ofs), new Object[0]);
            this.updateRiderPosition(this.RiderXofs, ofs, true);
            this.Rider = null;
            this.setAnchored(true);
        }
    }

    public void setFlags(int _flags) {
        this.Flags = _flags;
    }

    public int getFlags() {
        return this.Flags;
    }

    public void setDamageTaken(float par1) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(par1));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    public Entity[] func_70021_al() {
        boolean loaded = true;
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] != null) continue;
                loaded = false;
            }
        } else {
            loaded = false;
        }
        if (loaded) {
            return this.BoatParts;
        }
        return null;
    }

    public Entity getChildByOfs(float _x, float _y, float _z) {
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || this.BoatParts[i].posOfsX != _x || this.BoatParts[i].posOfsY != _y || this.BoatParts[i].posOfsZ != _z) continue;
                return this.BoatParts[i];
            }
        }
        return null;
    }

    public Entity getChildById(int _id) {
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || this.BoatParts[i].func_145782_y() != _id) continue;
                return this.BoatParts[i];
            }
        }
        return null;
    }

    public boolean isAnchored() {
        return this.Anchored;
    }

    public void setAnchored(boolean _anchored) {
        this.Anchored = _anchored;
    }

    public boolean isDocked() {
        return this.Docked;
    }

    public void setDocked(boolean _docked) {
        this.Docked = _docked;
    }

    public boolean isChild(Entity _part) {
        if (this.BoatParts != null && _part != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] != _part) continue;
                return true;
            }
        }
        return false;
    }

    public float getTackAngle() {
        return this.TackAngle;
    }

    public double getSpeed() {
        return this.Speed;
    }

    public double getMaxSpeed() {
        return this.MaxSpeed;
    }

    public float getHeel() {
        return this.Heel;
    }

    public float getPitch() {
        return this.field_70125_A;
    }

    public float getMaxHeel() {
        return this.MaxHeel;
    }

    public int getColor() {
        return this.Color;
    }

    public void setColor(int _color) {
        this.Color = _color;
    }

    public Item getItem() {
        return this.BoatItem;
    }

    public void setItem(Item item) {
        this.BoatItem = item;
    }

    public boolean isRider(Entity _entity) {
        if (_entity == null) {
            return false;
        }
        if (_entity == this.field_70153_n) {
            return true;
        }
        if (this.Passengers != null && this.Passengers.size() > 0) {
            for (PassengerData pd : this.Passengers) {
                if (_entity != pd.Passenger) continue;
                return true;
            }
        }
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !this.BoatParts[i].hasSeat || this.BoatParts[i].field_70153_n != _entity) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRider(int _entityID) {
        if (_entityID == 0) {
            return false;
        }
        if (this.field_70153_n != null && _entityID == this.field_70153_n.func_145782_y()) {
            return true;
        }
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !this.BoatParts[i].hasSeat || this.BoatParts[i].field_70153_n == null || this.BoatParts[i].field_70153_n.func_145782_y() != _entityID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPassenger(Entity _entity) {
        return this.Passengers.contains(_entity);
    }

    public PassengerData getPassengerData(Entity _entity) {
        if (this.Passengers.size() > 0) {
            for (PassengerData pd : this.Passengers) {
                if (pd.Passenger != _entity) continue;
                return pd;
            }
        }
        return null;
    }

    public void addPassenger(Entity _entity) {
        PassengerData pd = this.getPassengerData(_entity);
        if (pd == null) {
            AwgerLogger.log(this.LogLevel, String.format("%s.addPassenger(%d)", this.field_70170_p.field_72995_K ? "client" : "server", _entity.func_145782_y()), new Object[0]);
            pd = new PassengerData(_entity, this);
            this.Passengers.add(pd);
        } else {
            pd.resetCountdown();
        }
    }

    public void addPassenger(int _entityID) {
        Entity entity = this.field_70170_p.func_73045_a(_entityID);
        if (entity != null) {
            this.addPassenger(entity);
        }
    }

    public void updatePassengerOffset() {
        if (!this.field_70170_p.field_72995_K && this.Passengers.size() > 0) {
            Iterator itr = this.Passengers.iterator();
            while (itr.hasNext()) {
                PassengerData pd = (PassengerData)itr.next();
                if (pd.isExpired() || pd.Passenger.field_70128_L) {
                    AwgerLogger.log(this.LogLevel, String.format("%s.removePassenger(%d)", this.field_70170_p.field_72995_K ? "client" : "server", pd.Passenger.func_145782_y()), new Object[0]);
                    itr.remove();
                    continue;
                }
                pd.updatePassengerOffset();
            }
        }
    }

    public void updatePassengerPosition() {
        if (!this.field_70170_p.field_72995_K && this.Passengers.size() > 0) {
            Iterator itr = this.Passengers.iterator();
            while (itr.hasNext()) {
                PassengerData pd = (PassengerData)itr.next();
                if (pd.isExpired() || pd.Passenger.field_70128_L) {
                    AwgerLogger.log(this.LogLevel, String.format("%s.removePassenger(%d)", this.field_70170_p.field_72995_K ? "client" : "server", pd.Passenger.func_145782_y()), new Object[0]);
                    itr.remove();
                    continue;
                }
                pd.updatePassengerPosition();
            }
        }
    }

    protected void calcDisplacement() {
        double min_x = 0.0;
        double min_y = 0.0;
        double min_z = 0.0;
        double max_x = 0.0;
        double max_y = 0.0;
        double max_z = 0.0;
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if ((double)this.BoatParts[i].posOfsX < min_x) {
                min_x = this.BoatParts[i].posOfsX;
            }
            if ((double)this.BoatParts[i].posOfsX > max_x) {
                max_x = this.BoatParts[i].posOfsX;
            }
            if ((double)this.BoatParts[i].posOfsY < min_y) {
                min_y = this.BoatParts[i].posOfsY;
            }
            if ((double)this.BoatParts[i].posOfsY > max_y) {
                max_y = this.BoatParts[i].posOfsY;
            }
            if ((double)this.BoatParts[i].posOfsZ < min_z) {
                min_z = this.BoatParts[i].posOfsZ;
            }
            if (!((double)this.BoatParts[i].posOfsZ > max_z)) continue;
            max_z = this.BoatParts[i].posOfsZ;
        }
        double x = max_x + Math.abs(min_x);
        double y = max_y + Math.abs(min_y);
        double z = max_z + Math.abs(min_z);
        this.Beam = x;
        this.LWL = y;
        this.Displacement = x * y * z;
        if (this.Displacement <= 0.0) {
            this.Displacement = 1.0;
        }
        AwgerLogger.log(this.LogLevel, String.format("Displacement = %f", this.Displacement), new Object[0]);
    }

    public void setCanBounce(boolean _canbounce) {
        this.canBounce = _canbounce;
    }

    public float getCompassHeading() {
        float yaw;
        for (yaw = this.field_70177_z; yaw < 0.0f; yaw += 360.0f) {
        }
        while (yaw > 360.0f) {
            yaw -= 360.0f;
        }
        if ((yaw += 90.0f) > 360.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    public float yaw2heading(float _yaw) {
        if ((_yaw = MathHelper.func_76142_g((float)_yaw)) < 0.0f) {
            _yaw += 360.0f;
        }
        if (_yaw > 360.0f) {
            _yaw -= 360.0f;
        }
        return _yaw;
    }

    public float heading2yaw(float _heading) {
        if (_heading >= 180.0f) {
            _heading -= 360.0f;
        }
        return _heading;
    }

    public float getHeadingDif(float _ref, float _heading) {
        float dif = 0.0f;
        _heading = _ref > 180.0f ? (_heading += 360.0f - _ref) : (_heading -= _ref);
        dif = _heading < 0.0f ? _heading : (_heading > 360.0f ? _heading - 360.0f : (_heading > 180.0f ? -(360.0f - _heading) : _heading));
        return dif;
    }

    public void makeReady() {
        int pause = 0;
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !(this.BoatParts[i] instanceof EntityBoatGun)) continue;
                EntityBoatGun gun = (EntityBoatGun)this.BoatParts[i];
                gun.MakeReady(pause);
                pause += 3;
            }
        }
    }

    public void makeSafe() {
        int pause = 0;
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !(this.BoatParts[i] instanceof EntityBoatGun)) continue;
                EntityBoatGun gun = (EntityBoatGun)this.BoatParts[i];
                gun.MakeSafe(pause);
                ++pause;
            }
        }
    }

    public void Fire(int _group) {
        int pause = 0;
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !(this.BoatParts[i] instanceof EntityBoatGun)) continue;
                EntityBoatGun gun = (EntityBoatGun)this.BoatParts[i];
                gun.Fire(_group, pause);
                ++pause;
            }
        }
    }

    public void setMaxDamage(float _damage) {
        this.MaxDamage = _damage;
    }
}

