/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.network;

import awger.AwgerLogger;
import awger.network.AbstractServerMessageHandler;
import awger.smallboats.SmallBoats;
import awger.smallboats.entity.EntitySmallBoat;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class OpenCargoPacket
implements IMessage {
    private int childId;
    private int BoatID;
    private EntitySmallBoat boat;

    public OpenCargoPacket() {
    }

    public OpenCargoPacket(EntitySmallBoat boat, Entity child) {
        this.boat = boat;
        this.BoatID = this.boat.func_145782_y();
        this.childId = child != null ? child.func_145782_y() : -1;
    }

    public void fromBytes(ByteBuf buffer) {
        this.BoatID = buffer.readInt();
        this.childId = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.BoatID);
        buffer.writeInt(this.childId);
    }

    public static class ServerMessageHandler
    extends AbstractServerMessageHandler {
        @Override
        public IMessage handleServerMessage(IMessage message, MessageContext ctx) {
            EntityPlayer player = SmallBoats.proxy.getPlayerEntity(ctx);
            OpenCargoPacket p = (OpenCargoPacket)message;
            p.boat = (EntitySmallBoat)player.field_70170_p.func_73045_a(p.BoatID);
            if (p.boat != null) {
                Entity child = player.field_70170_p.func_73045_a(p.childId);
                if (child != null) {
                    p.boat.openCargo(child, player);
                } else {
                    AwgerLogger.log(Level.FINE, "Child part not found while opening cargo server side!", new Object[0]);
                }
            }
            return null;
        }
    }
}

