/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.network;

import awger.network.AbstractClientMessageHandler;
import awger.network.AbstractServerMessageHandler;
import awger.smallboats.SmallBoats;
import awger.smallboats.entity.EntitySmallBoat;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class UpdateBoatPositionPacket
implements IMessage {
    private double x;
    private double y;
    private double z;
    private double dx;
    private double dy;
    private double dz;
    private float pitch;
    private float yaw;
    private float rdelta;
    private int BoatID;
    private EntitySmallBoat boat;

    public UpdateBoatPositionPacket() {
    }

    public UpdateBoatPositionPacket(EntitySmallBoat boat) {
        this.boat = boat;
        this.BoatID = this.boat.func_145782_y();
    }

    public void fromBytes(ByteBuf buffer) {
        this.BoatID = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.dx = buffer.readDouble();
        this.dy = buffer.readDouble();
        this.dz = buffer.readDouble();
        this.pitch = buffer.readFloat();
        this.yaw = buffer.readFloat();
        this.rdelta = buffer.readFloat();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.BoatID);
        buffer.writeDouble(this.boat.field_70165_t);
        buffer.writeDouble(this.boat.field_70163_u);
        buffer.writeDouble(this.boat.field_70161_v);
        buffer.writeDouble(this.boat.field_70159_w);
        buffer.writeDouble(this.boat.field_70181_x);
        buffer.writeDouble(this.boat.field_70179_y);
        buffer.writeFloat(this.boat.field_70125_A);
        buffer.writeFloat(this.boat.field_70177_z);
        buffer.writeFloat(this.boat.srvRotationAsst);
    }

    public static class ServerMessageHandler
    extends AbstractServerMessageHandler {
        @Override
        public IMessage handleServerMessage(IMessage message, MessageContext ctx) {
            EntityPlayer player = SmallBoats.proxy.getPlayerEntity(ctx);
            UpdateBoatPositionPacket p = (UpdateBoatPositionPacket)message;
            p.boat = (EntitySmallBoat)player.field_70170_p.func_73045_a(p.BoatID);
            if (p.boat != null) {
                float dif = Math.abs(Math.abs(p.yaw) - Math.abs(((UpdateBoatPositionPacket)p).boat.field_70177_z));
                ((UpdateBoatPositionPacket)p).boat.srvRotationAsst = dif < Math.abs(p.rdelta) ? 0.0f : p.rdelta;
                p.boat.func_70080_a(p.x, p.y, p.z, p.yaw, p.pitch);
            }
            return null;
        }
    }

    public static class ClientMessageHandler
    extends AbstractClientMessageHandler {
        @Override
        public IMessage handleClientMessage(IMessage message, MessageContext ctx) {
            EntityPlayer player = SmallBoats.proxy.getPlayerEntity(ctx);
            UpdateBoatPositionPacket p = (UpdateBoatPositionPacket)message;
            p.boat = (EntitySmallBoat)player.field_70170_p.func_73045_a(p.BoatID);
            if (p.boat != null && ((UpdateBoatPositionPacket)p).boat.field_70153_n != player) {
                p.boat.func_70056_a(p.x, p.y, p.z, p.yaw, p.pitch, 0);
            }
            return null;
        }
    }
}

