/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei;

import bletch.pixelmoninformation.core.ModConfig;
import bletch.pixelmoninformation.core.ModDetails;
import bletch.pixelmoninformation.jei.BlankRecipeCategory;
import bletch.pixelmoninformation.jei.anvil.AnvilCategory;
import bletch.pixelmoninformation.jei.anvil.AnvilEntry;
import bletch.pixelmoninformation.jei.anvil.AnvilRegistry;
import bletch.pixelmoninformation.jei.anvil.AnvilWrapper;
import bletch.pixelmoninformation.jei.brewing.BrewingCategory;
import bletch.pixelmoninformation.jei.brewing.BrewingEntry;
import bletch.pixelmoninformation.jei.brewing.BrewingRegistry;
import bletch.pixelmoninformation.jei.brewing.BrewingWrapper;
import bletch.pixelmoninformation.jei.dungeon.DungeonCategory;
import bletch.pixelmoninformation.jei.dungeon.DungeonEntry;
import bletch.pixelmoninformation.jei.dungeon.DungeonRegistry;
import bletch.pixelmoninformation.jei.dungeon.DungeonWrapper;
import bletch.pixelmoninformation.jei.infuser.InfuserCategory;
import bletch.pixelmoninformation.jei.infuser.InfuserEntry;
import bletch.pixelmoninformation.jei.infuser.InfuserRegistry;
import bletch.pixelmoninformation.jei.infuser.InfuserWrapper;
import bletch.pixelmoninformation.jei.mechanicalanvil.MechanicalAnvilCategory;
import bletch.pixelmoninformation.jei.mechanicalanvil.MechanicalAnvilEntry;
import bletch.pixelmoninformation.jei.mechanicalanvil.MechanicalAnvilRegistry;
import bletch.pixelmoninformation.jei.mechanicalanvil.MechanicalAnvilWrapper;
import bletch.pixelmoninformation.jei.pokechest.PokeChestCategory;
import bletch.pixelmoninformation.jei.pokechest.PokeChestEntry;
import bletch.pixelmoninformation.jei.pokechest.PokeChestRegistry;
import bletch.pixelmoninformation.jei.pokechest.PokeChestWrapper;
import bletch.pixelmoninformation.jei.pokemon.PokemonCategory;
import bletch.pixelmoninformation.jei.pokemon.PokemonEntry;
import bletch.pixelmoninformation.jei.pokemon.PokemonRegistry;
import bletch.pixelmoninformation.jei.pokemon.PokemonWrapper;
import bletch.pixelmoninformation.jei.pokemonboss.PokemonBossCategory;
import bletch.pixelmoninformation.jei.pokemonboss.PokemonBossEntry;
import bletch.pixelmoninformation.jei.pokemonboss.PokemonBossRegistry;
import bletch.pixelmoninformation.jei.pokemonboss.PokemonBossWrapper;
import bletch.pixelmoninformation.jei.shopkeeper.ShopKeeperCategory;
import bletch.pixelmoninformation.jei.shopkeeper.ShopKeeperEntry;
import bletch.pixelmoninformation.jei.shopkeeper.ShopKeeperRegistry;
import bletch.pixelmoninformation.jei.shopkeeper.ShopKeeperWrapper;
import bletch.pixelmoninformation.utils.DebugUtils;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.pixelmonmod.pixelmon.blocks.machines.BlockAnvil;
import com.pixelmonmod.pixelmon.blocks.machines.BlockInfuser;
import com.pixelmonmod.pixelmon.blocks.machines.BlockMechanicalAnvil;
import com.pixelmonmod.pixelmon.client.gui.machines.infuser.GuiInfuser;
import com.pixelmonmod.pixelmon.client.gui.machines.mechanicalanvil.GuiMechanicalAnvil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;

@ParametersAreNonnullByDefault
@JEIPlugin
public class PixelmonJei
implements IModPlugin {
    private static final String KEY_SUFFIX = ".pinformation";
    private static IJeiHelpers jeiHelpers;
    private static IJeiRuntime jeiRuntime;
    private static List<BlankRecipeCategory<?>> categories;

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        PixelmonJei.jeiRuntime = jeiRuntime;
    }

    public void register(IModRegistry registry) {
        if (!ModConfig.jei.enableJeiIntegration) {
            return;
        }
        if (ModConfig.jei.showJeiInformationTab) {
            try {
                PixelmonJei.registerPixelmonIngredientInfo(registry);
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiRecipeTabs) {
            try {
                PixelmonJei.registerPixelmonRecipes(registry);
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiDungeonChestTab && (ModConfig.jei.removeJeiDungeonChestTabModCheck || !Loader.isModLoaded((String)"jeresources"))) {
            try {
                PixelmonJei.registerDungeonLoot(registry);
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiPokeChestTab) {
            try {
                PixelmonJei.registerPokeChestLoot(registry);
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiShopKeeperTab) {
            try {
                PixelmonJei.registerShopKeepers(registry);
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiPokemonBossTab) {
            try {
                PixelmonJei.registerPokemonBossDrops(registry);
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiPokemonTab) {
            try {
                PixelmonJei.registerPokemonDrops(registry);
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        if (!ModConfig.jei.enableJeiIntegration) {
            return;
        }
        if (ModConfig.jei.showJeiRecipeTabs) {
            try {
                categories.add(new AnvilCategory());
                categories.add(new MechanicalAnvilCategory());
                categories.add(new InfuserCategory());
                categories.add(new BrewingCategory());
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiDungeonChestTab && (ModConfig.jei.removeJeiDungeonChestTabModCheck || !Loader.isModLoaded((String)"jeresources"))) {
            try {
                categories.add(new DungeonCategory());
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiPokeChestTab) {
            try {
                categories.add(new PokeChestCategory());
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiShopKeeperTab) {
            try {
                categories.add(new ShopKeeperCategory());
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiPokemonBossTab) {
            try {
                categories.add(new PokemonBossCategory());
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (ModConfig.jei.showJeiPokemonTab) {
            try {
                categories.add(new PokemonCategory());
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        categories.forEach(c -> registry.addRecipeCategories(new IRecipeCategory[]{c}));
    }

    public static BlankRecipeCategory<?> getCategory(Class<?> categoryClass) {
        return categories.stream().filter(categoryClass::isInstance).findFirst().orElse(null);
    }

    public static IGuiHelper getGuiHelper() {
        return jeiHelpers.getGuiHelper();
    }

    public static IJeiHelpers getJeiHelper() {
        return jeiHelpers;
    }

    public static IJeiRuntime getJeiRuntime() {
        return jeiRuntime;
    }

    public static String getJeiUid(String category) {
        return "pixelmoninformation:" + category;
    }

    private static void registerPixelmonIngredientInfo(IModRegistry registry) {
        ArrayList<String> processed = new ArrayList<String>();
        ModDetails.MOD_LOGGER.info("Registering item/block information with JEI");
        ArrayList<ItemStack> pixelmonItemStacks = new ArrayList<ItemStack>();
        pixelmonItemStacks.addAll(PixelmonUtils.getPixelmonBlockStacks());
        pixelmonItemStacks.addAll(PixelmonUtils.getPixelmonItemStacks());
        ArrayList<String> missingInformation = new ArrayList<String>();
        ArrayList<String> registeredInformation = new ArrayList<String>();
        int count = 0;
        for (ItemStack pixelmonItemStack : pixelmonItemStacks) {
            NonNullList itemStackList = NonNullList.func_191196_a();
            if (pixelmonItemStack.func_77981_g()) {
                Item item = pixelmonItemStack.func_77973_b();
                item.func_150895_a(item.func_77640_w(), itemStackList);
            } else {
                itemStackList.add((Object)pixelmonItemStack);
            }
            for (ItemStack itemStack : itemStackList) {
                String key = itemStack.func_77977_a() + KEY_SUFFIX;
                if (processed.contains(key)) continue;
                processed.add(key);
                if (!itemStack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("pixelmon")) continue;
                if (TextUtils.canTranslate(key) || ModConfig.debug.enableDebug && ModConfig.debug.registerJeiMissingInformation) {
                    try {
                        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new String[]{key});
                        ++count;
                        if (!ModConfig.debug.enableDebug || !ModConfig.debug.showJeiRegisteredInformation) continue;
                        registeredInformation.add("Registered JEI information for " + itemStack.func_82833_r() + "; key: " + key);
                    }
                    catch (Exception e) {
                        if (!ModConfig.debug.enableDebug) continue;
                        DebugUtils.writeLine("Error registering JEI information for " + itemStack.func_82833_r() + "; key: " + key, true);
                    }
                    continue;
                }
                if (!ModConfig.debug.enableDebug || !ModConfig.debug.showJeiMissingInformation) continue;
                missingInformation.add("Missing JEI information for " + itemStack.func_82833_r() + "; key: " + key);
            }
        }
        if (ModConfig.debug.enableDebug && registeredInformation != null && registeredInformation.size() > 0) {
            registeredInformation.sort((i1, i2) -> i1.compareTo((String)i2));
            DebugUtils.writeLines(registeredInformation, true);
        }
        if (ModConfig.debug.enableDebug && missingInformation != null && missingInformation.size() > 0) {
            missingInformation.sort((i1, i2) -> i1.compareTo((String)i2));
            DebugUtils.writeLines(missingInformation, true);
        }
        ModDetails.MOD_LOGGER.info("Registered item/block information with JEI - count: " + count);
    }

    private static void registerPixelmonRecipes(IModRegistry registry) {
        try {
            Optional<BlockAnvil> blockAnvil = StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(BlockAnvil.class::isInstance).map(BlockAnvil.class::cast).findFirst();
            if (blockAnvil.isPresent()) {
                ModDetails.MOD_LOGGER.info("Registering anvil recipes with JEI");
                AnvilRegistry.initialize();
                registry.handleRecipes(AnvilEntry.class, AnvilWrapper::new, PixelmonJei.getJeiUid("anvil"));
                registry.addRecipes(AnvilRegistry.getValidEntries(), PixelmonJei.getJeiUid("anvil"));
                registry.addRecipeCatalyst((Object)new ItemStack((Block)blockAnvil.get()), new String[]{PixelmonJei.getJeiUid("anvil")});
                ModDetails.MOD_LOGGER.info("Registered anvil recipes with JEI - count: " + AnvilRegistry.getValidEntries().size());
            }
        }
        catch (Exception e) {
            ModDetails.MOD_LOGGER.error("Error registering anvil recipes with JEI");
        }
        try {
            Optional<BlockMechanicalAnvil> blockMechanicalAnvil = StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(BlockMechanicalAnvil.class::isInstance).map(BlockMechanicalAnvil.class::cast).findFirst();
            if (blockMechanicalAnvil.isPresent()) {
                ModDetails.MOD_LOGGER.info("Registering mechanical anvil recipes with JEI");
                MechanicalAnvilRegistry.initialize();
                registry.handleRecipes(MechanicalAnvilEntry.class, MechanicalAnvilWrapper::new, PixelmonJei.getJeiUid("mechanicalanvil"));
                registry.addRecipes(MechanicalAnvilRegistry.getValidEntries(), PixelmonJei.getJeiUid("mechanicalanvil"));
                registry.addRecipeCatalyst((Object)new ItemStack((Block)blockMechanicalAnvil.get()), new String[]{PixelmonJei.getJeiUid("mechanicalanvil")});
                registry.addRecipeClickArea(GuiMechanicalAnvil.class, 80, 35, 22, 15, new String[]{PixelmonJei.getJeiUid("mechanicalanvil")});
                ModDetails.MOD_LOGGER.info("Registered mechanical anvil recipes with JEI - count: " + MechanicalAnvilRegistry.getValidEntries().size());
            }
        }
        catch (Exception e) {
            ModDetails.MOD_LOGGER.error("Error registering mechanical anvil recipes with JEI");
        }
        try {
            Optional<BlockInfuser> blockInfuser = StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(BlockInfuser.class::isInstance).map(BlockInfuser.class::cast).findFirst();
            if (blockInfuser.isPresent()) {
                ModDetails.MOD_LOGGER.info("Registering infuser recipes with JEI");
                InfuserRegistry.initialize();
                registry.handleRecipes(InfuserEntry.class, InfuserWrapper::new, PixelmonJei.getJeiUid("infuser"));
                registry.addRecipes(InfuserRegistry.getValidEntries(), PixelmonJei.getJeiUid("infuser"));
                registry.addRecipeCatalyst((Object)new ItemStack((Block)blockInfuser.get()), new String[]{PixelmonJei.getJeiUid("infuser")});
                registry.addRecipeClickArea(GuiInfuser.class, 107, 32, 14, 12, new String[]{PixelmonJei.getJeiUid("infuser")});
                ModDetails.MOD_LOGGER.info("Registered infuser recipes with JEI - count: " + InfuserRegistry.getValidEntries().size());
            }
        }
        catch (Exception e) {
            ModDetails.MOD_LOGGER.error("Error registering infuser recipes with JEI");
        }
        try {
            ModDetails.MOD_LOGGER.info("Registering brewing recipes with JEI");
            BrewingRegistry.initialize();
            registry.handleRecipes(BrewingEntry.class, BrewingWrapper::new, PixelmonJei.getJeiUid("brewer"));
            registry.addRecipes(BrewingRegistry.getValidEntries(), PixelmonJei.getJeiUid("brewer"));
            registry.addRecipeCatalyst((Object)new ItemStack(Items.field_151067_bt), new String[]{PixelmonJei.getJeiUid("brewer")});
            registry.addRecipeClickArea(GuiBrewingStand.class, 63, 15, 12, 27, new String[]{PixelmonJei.getJeiUid("brewer")});
            ModDetails.MOD_LOGGER.info("Registered brewing recipes with JEI - count: " + BrewingRegistry.getValidEntries().size());
        }
        catch (Exception e) {
            ModDetails.MOD_LOGGER.error("Error registering brewing recipes with JEI");
        }
    }

    private static void registerDungeonLoot(IModRegistry registry) {
        ModDetails.MOD_LOGGER.info("Registering dungeon loot with JEI");
        DungeonRegistry.initialize();
        registry.handleRecipes(DungeonEntry.class, DungeonWrapper::new, PixelmonJei.getJeiUid("dungeonchest"));
        registry.addRecipes(DungeonRegistry.getValidEntries(), PixelmonJei.getJeiUid("dungeonchest"));
        ModDetails.MOD_LOGGER.info("Registered dungeon loot with JEI - count: " + DungeonRegistry.getValidEntries().size());
    }

    private static void registerPokeChestLoot(IModRegistry registry) {
        ModDetails.MOD_LOGGER.info("Registering pok\u00c3\u00a9 chest loot with JEI");
        PokeChestRegistry.initialize();
        registry.handleRecipes(PokeChestEntry.class, PokeChestWrapper::new, PixelmonJei.getJeiUid("pokechest"));
        registry.addRecipes(PokeChestRegistry.getValidEntries(), PixelmonJei.getJeiUid("pokechest"));
        ModDetails.MOD_LOGGER.info("Registered pok\u00c3\u00a9 chest loot with JEI - count: " + PokeChestRegistry.getValidEntries().size());
    }

    private static void registerShopKeepers(IModRegistry registry) {
        ModDetails.MOD_LOGGER.info("Registering shop keepers with JEI");
        ShopKeeperRegistry.initialize();
        registry.handleRecipes(ShopKeeperEntry.class, ShopKeeperWrapper::new, PixelmonJei.getJeiUid("shopkeeper"));
        registry.addRecipes(ShopKeeperRegistry.getValidEntries(), PixelmonJei.getJeiUid("shopkeeper"));
        ModDetails.MOD_LOGGER.info("Registered shop keepers with JEI - count: " + ShopKeeperRegistry.getValidEntries().size());
    }

    private static void registerPokemonBossDrops(IModRegistry registry) {
        ModDetails.MOD_LOGGER.info("Registering pok\u00c3\u00a9mon boss drops with JEI");
        PokemonBossRegistry.initialize();
        registry.handleRecipes(PokemonBossEntry.class, PokemonBossWrapper::new, PixelmonJei.getJeiUid("pokemonboss"));
        registry.addRecipes(PokemonBossRegistry.getValidEntries(), PixelmonJei.getJeiUid("pokemonboss"));
        ModDetails.MOD_LOGGER.info("Registered pok\u00c3\u00a9mon boss drops with JEI - count: " + PokemonBossRegistry.getValidEntries().size());
    }

    private static void registerPokemonDrops(IModRegistry registry) {
        ModDetails.MOD_LOGGER.info("Registering pok\u00c3\u00a9mon drops with JEI");
        PokemonRegistry.initialize();
        registry.handleRecipes(PokemonEntry.class, PokemonWrapper::new, PixelmonJei.getJeiUid("pokemon"));
        registry.addRecipes(PokemonRegistry.getValidEntries(), PixelmonJei.getJeiUid("pokemon"));
        ModDetails.MOD_LOGGER.info("Registered pok\u00c3\u00a9mon drops with JEI - count: " + PokemonRegistry.getValidEntries().size());
    }

    static {
        categories = new ArrayList();
    }
}

