/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.anvil;

import bletch.pixelmoninformation.jei.anvil.AnvilEntry;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import com.pixelmonmod.pixelmon.items.ItemPokeballDisc;
import com.pixelmonmod.pixelmon.items.ItemPokeballLid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class AnvilRegistry {
    public static IForgeRegistry<AnvilEntry> REGISTRY;

    private AnvilRegistry() {
    }

    public static void addEntry(ItemStack input, ItemStack output) {
        REGISTRY.register((IForgeRegistryEntry)new AnvilEntry(input, output));
    }

    public static void setRegistry(IForgeRegistry<AnvilEntry> registry) {
        REGISTRY = registry;
    }

    public static Collection<AnvilEntry> getEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static Collection<AnvilEntry> getValidEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static void initialize() {
        if (REGISTRY == null) {
            return;
        }
        ArrayList<ItemStack> pixelmonItemStacks = new ArrayList<ItemStack>();
        pixelmonItemStacks.addAll(PixelmonUtils.getPixelmonItemStacks());
        for (ItemStack pixelmonItemStack : pixelmonItemStacks) {
            NonNullList itemStackList = NonNullList.func_191196_a();
            if (pixelmonItemStack.func_77981_g()) {
                Item item = pixelmonItemStack.func_77973_b();
                item.func_150895_a(item.func_77640_w(), itemStackList);
            } else {
                itemStackList.add((Object)pixelmonItemStack);
            }
            for (ItemStack itemStack : itemStackList) {
                Optional<ItemStack> itemBase;
                if (itemStack.func_77973_b() instanceof ItemPokeballDisc) {
                    ItemPokeballDisc itemPokeballDisc = (ItemPokeballDisc)itemStack.func_77973_b();
                    Optional<ItemPokeballLid> itemPokeballLid = pixelmonItemStacks.stream().filter(s -> s.func_77973_b() instanceof ItemPokeballLid).map(s -> (ItemPokeballLid)s.func_77973_b()).filter(i -> i.pokeball.equals((Object)itemPokeballDisc.pokeball)).findFirst();
                    if (itemPokeballLid.isPresent()) {
                        AnvilRegistry.addEntry(itemStack, new ItemStack((Item)itemPokeballLid.get()));
                    }
                }
                if (itemStack.func_77977_a().equalsIgnoreCase("item.iron_disc") && (itemBase = pixelmonItemStacks.stream().filter(s -> s.func_77977_a().equalsIgnoreCase("item.iron_base")).findFirst()).isPresent()) {
                    AnvilRegistry.addEntry(itemStack, itemBase.get());
                }
                if (itemStack.func_77977_a().equalsIgnoreCase("item.aluminum_disc") && (itemBase = pixelmonItemStacks.stream().filter(s -> s.func_77977_a().equalsIgnoreCase("item.aluminum_base")).findFirst()).isPresent()) {
                    AnvilRegistry.addEntry(itemStack, itemBase.get());
                }
                if (!itemStack.func_77977_a().equalsIgnoreCase("item.aluminium_ingot") || !(itemBase = pixelmonItemStacks.stream().filter(s -> s.func_77977_a().equalsIgnoreCase("item.aluminium_plate")).findFirst()).isPresent()) continue;
                AnvilRegistry.addEntry(itemStack, itemBase.get());
            }
        }
    }
}

