/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.brewing;

import bletch.pixelmoninformation.jei.brewing.BrewingEntry;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class BrewingRegistry {
    public static IForgeRegistry<BrewingEntry> REGISTRY;

    private BrewingRegistry() {
    }

    public static void addEntry(ItemStack input1, ItemStack input2, ItemStack output) {
        REGISTRY.register((IForgeRegistryEntry)new BrewingEntry(input1, input2, output));
    }

    public static void setRegistry(IForgeRegistry<BrewingEntry> registry) {
        REGISTRY = registry;
    }

    public static Collection<BrewingEntry> getEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static Collection<BrewingEntry> getValidEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static void initialize() {
        if (REGISTRY == null) {
            return;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        inputs.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b));
        inputs.addAll(PixelmonItems.getPotionElixirList().stream().map(i -> new ItemStack(i)).collect(Collectors.toList()));
        List<ItemStack> pixelmonStacks = PixelmonUtils.getPixelmonItemStacks();
        for (ItemStack pixelmonStack : pixelmonStacks) {
            for (ItemStack input : inputs) {
                ItemStack output = BrewingRecipeRegistry.getOutput((ItemStack)input, (ItemStack)pixelmonStack);
                if (output == ItemStack.field_190927_a) continue;
                BrewingRegistry.addEntry(pixelmonStack, input, output);
            }
        }
    }
}

