/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.common;

import bletch.pixelmoninformation.jei.common.Condition;
import bletch.pixelmoninformation.jei.enums.EnumItemDropType;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ItemDrop
implements Comparable<ItemDrop> {
    public ItemStack itemStack;
    public int minDrop;
    public int maxDrop;
    public float chance;
    public EnumItemDropType dropType;
    protected Set<Condition> conditions;
    protected float sortIndex;

    public ItemDrop(ItemStack itemStack, EnumItemDropType dropType) {
        this(itemStack, dropType, itemStack.func_190916_E());
    }

    public ItemDrop(ItemStack itemStack, EnumItemDropType dropType, float chance) {
        this(itemStack, (int)Math.floor(chance), (int)Math.ceil(chance), dropType, chance, new Condition[0]);
    }

    public ItemDrop(ItemStack itemStack, int minDrop, int maxDrop, EnumItemDropType dropType) {
        this(itemStack, minDrop, maxDrop, dropType, 1.0f, new Condition[0]);
    }

    public ItemDrop(ItemStack itemStack, int minDrop, int maxDrop, EnumItemDropType dropType, Condition ... conditions) {
        this(itemStack, minDrop, maxDrop, dropType, 1.0f, conditions);
    }

    public ItemDrop(ItemStack itemStack, int minDrop, int maxDrop, EnumItemDropType dropType, float chance, Condition ... conditions) {
        this.itemStack = itemStack;
        this.minDrop = minDrop;
        this.maxDrop = maxDrop;
        this.dropType = dropType;
        this.chance = chance;
        this.sortIndex = Math.min(chance, 1.0f) * (float)(minDrop + maxDrop);
        this.conditions = new HashSet<Condition>();
        Collections.addAll(this.conditions, conditions);
    }

    public ItemDrop(Item item, int minDrop, int maxDrop, EnumItemDropType dropType, Condition ... conditions) {
        this(new ItemStack(item), minDrop, maxDrop, dropType, 1.0f, conditions);
    }

    public ItemDrop(Item item, int itemDamage, int minDrop, int maxDrop, EnumItemDropType dropType, Condition ... conditions) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, dropType, 1.0f, conditions);
    }

    public ItemDrop(Item item, int minDrop, int maxDrop, EnumItemDropType dropType, float chance, Condition ... conditions) {
        this(new ItemStack(item), minDrop, maxDrop, dropType, chance, conditions);
    }

    public ItemDrop(Item item, int itemDamage, int minDrop, int maxDrop, EnumItemDropType dropType, float chance, Condition ... conditions) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, dropType, chance, conditions);
    }

    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        if (this.itemStack != null) {
            list.add(this.itemStack);
        }
        return list;
    }

    public String toString() {
        if (this.minDrop == this.maxDrop) {
            return (this.dropType == EnumItemDropType.MAIN ? "" : this.dropType.getColor() + this.dropType.getLocalisedName() + " ") + TextFormatting.RESET + this.minDrop + this.getDropChance();
        }
        return (this.dropType == EnumItemDropType.MAIN ? "" : this.dropType.getColor() + this.dropType.getLocalisedName() + " ") + TextFormatting.RESET + this.minDrop + "-" + this.maxDrop + this.getDropChance();
    }

    private String getDropChance() {
        return this.chance < 1.0f ? " (" + this.formatChance() + "%)" : "";
    }

    private String formatChance() {
        float chance = this.chance * 100.0f;
        if (chance < 10.0f) {
            return String.format("%.1f", Float.valueOf(chance));
        }
        return String.format("%2d", (int)chance);
    }

    public String chanceString() {
        if (this.chance >= 0.995f) {
            return String.format("%.2G", Float.valueOf(this.chance));
        }
        return String.format("%.2G%%", Float.valueOf(this.chance * 100.0f));
    }

    public List<String> getTooltipText() {
        return this.conditions.stream().map(Condition::toString).collect(Collectors.toList());
    }

    public void addConditional(Condition conditional) {
        this.conditions.add(conditional);
    }

    public void addConditionals(List<Condition> conditionals) {
        this.conditions.addAll(conditionals);
    }

    public float getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public int compareTo(@Nonnull ItemDrop o) {
        if (ItemStack.func_77989_b((ItemStack)this.itemStack, (ItemStack)o.itemStack)) {
            return Float.compare(o.getSortIndex(), this.getSortIndex());
        }
        int cmp = Float.compare(o.getSortIndex(), this.getSortIndex());
        return cmp != 0 ? cmp : this.itemStack.func_82833_r().compareTo(o.itemStack.func_82833_r());
    }
}

