/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.common;

import bletch.pixelmoninformation.jei.common.Condition;
import bletch.pixelmoninformation.jei.common.ItemDrop;
import bletch.pixelmoninformation.jei.common.LootHelper;
import bletch.pixelmoninformation.jei.enums.EnumItemDropType;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootDrop
extends ItemDrop {
    public ItemStack smeltedItem = null;
    public int fortuneLevel;
    public boolean enchanted;

    public LootDrop(ItemStack itemStack) {
        this(itemStack, itemStack.func_190916_E());
    }

    public LootDrop(ItemStack itemStack, float chance) {
        this(itemStack, chance, 0);
    }

    public LootDrop(ItemStack itemStack, float chance, int fortuneLevel) {
        this(itemStack, (int)Math.floor(chance), (int)Math.ceil(chance), chance, fortuneLevel, new Condition[0]);
    }

    public LootDrop(ItemStack itemStack, int minDrop, int maxDrop, Condition ... conditions) {
        this(itemStack, minDrop, maxDrop, 1.0f, 0, conditions);
    }

    public LootDrop(ItemStack itemStack, int minDrop, int maxDrop, float chance, int fortuneLevel, Condition ... conditions) {
        super(itemStack, minDrop, maxDrop, EnumItemDropType.MAIN, chance, conditions);
        this.fortuneLevel = fortuneLevel;
    }

    public LootDrop(Item item, int minDrop, int maxDrop, Condition ... conditions) {
        this(new ItemStack(item), minDrop, maxDrop, 1.0f, 0, conditions);
    }

    public LootDrop(Item item, int itemDamage, int minDrop, int maxDrop, Condition ... conditions) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, 1.0f, 0, conditions);
    }

    public LootDrop(Item item, int minDrop, int maxDrop, float chance, Condition ... conditions) {
        this(new ItemStack(item), minDrop, maxDrop, chance, 0, conditions);
    }

    public LootDrop(Item item, int itemDamage, int minDrop, int maxDrop, float chance, Condition ... conditions) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, chance, 0, conditions);
    }

    public LootDrop(ItemStack itemStack, int minDrop, int maxDrop, float chance, Condition ... conditions) {
        this(itemStack, minDrop, maxDrop, chance, 0, conditions);
    }

    public LootDrop(Item item, float chance, LootFunction ... lootFunctions) {
        this(new ItemStack(item), chance);
        this.enchanted = false;
        this.addLootFunctions(lootFunctions);
    }

    public LootDrop(Item item, float chance, LootCondition[] lootConditions, LootFunction ... lootFunctions) {
        this(item, chance, lootFunctions);
        this.addLootConditions(lootConditions);
    }

    public LootDrop addLootConditions(LootCondition[] lootFunctions) {
        return this.addLootConditions(Arrays.asList(lootFunctions));
    }

    public LootDrop addLootConditions(Collection<LootCondition> lootFunctions) {
        lootFunctions.forEach(this::addLootCondition);
        return this;
    }

    public LootDrop addLootCondition(LootCondition condition) {
        LootHelper.applyCondition(condition, this);
        return this;
    }

    public LootDrop addLootFunctions(LootFunction[] lootFunctions) {
        return this.addLootFunctions(Arrays.asList(lootFunctions));
    }

    public LootDrop addLootFunctions(Collection<LootFunction> lootFunctions) {
        lootFunctions.forEach(this::addLootFunction);
        return this;
    }

    public LootDrop addLootFunction(LootFunction lootFunction) {
        LootHelper.applyFunction(lootFunction, this);
        return this;
    }

    public boolean canBeCooked() {
        return this.smeltedItem != null;
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        if (this.itemStack != null) {
            list.add(this.itemStack);
        }
        if (this.smeltedItem != null) {
            list.add(this.smeltedItem);
        }
        return list;
    }

    @Override
    public List<String> getTooltipText() {
        return this.getTooltipText(false);
    }

    public List<String> getTooltipText(boolean smelted) {
        List<String> list = this.conditions.stream().map(Condition::toString).collect(Collectors.toList());
        if (smelted) {
            list.add(Condition.burning.toString());
        }
        return list;
    }

    @Override
    public void addConditional(Condition condition) {
        this.conditions.add(condition);
    }

    @Override
    public void addConditionals(List<Condition> conditions) {
        this.conditions.addAll(conditions);
    }

    @Override
    public float getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public int compareTo(@Nonnull LootDrop o) {
        if (ItemStack.func_77989_b((ItemStack)this.itemStack, (ItemStack)o.itemStack)) {
            return Integer.compare(o.fortuneLevel, this.fortuneLevel);
        }
        int cmp = Float.compare(o.getSortIndex(), this.getSortIndex());
        return cmp != 0 ? cmp : this.itemStack.func_82833_r().compareTo(o.itemStack.func_82833_r());
    }
}

