/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.common;

import bletch.pixelmoninformation.core.ModDetails;
import bletch.pixelmoninformation.jei.common.Condition;
import bletch.pixelmoninformation.jei.common.FakeWorld;
import bletch.pixelmoninformation.jei.common.LootDrop;
import bletch.pixelmoninformation.jei.common.PokeChestDrop;
import bletch.pixelmoninformation.jei.common.PokemonBossDrop;
import bletch.pixelmoninformation.jei.common.PokemonDrop;
import bletch.pixelmoninformation.jei.enums.EnumPokeChestTier;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonDropInformation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.Smelt;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@ParametersAreNonnullByDefault
public class LootHelper {
    private static FakeWorld fakeWorld;

    public static void applyCondition(LootCondition condition, LootDrop lootDrop) {
        if (condition instanceof RandomChance) {
            lootDrop.chance = ((RandomChance)condition).field_186630_a;
        } else if (condition instanceof RandomChanceWithLooting) {
            lootDrop.chance = ((RandomChanceWithLooting)condition).field_186627_a;
            lootDrop.addConditional(Condition.affectedByLooting);
        }
    }

    public static void applyFunction(LootFunction lootFunction, LootDrop lootDrop) {
        if (lootFunction instanceof EnchantRandomly || lootFunction instanceof EnchantWithLevels) {
            lootDrop.enchanted = true;
        } else if (lootFunction instanceof LootingEnchantBonus) {
            lootDrop.addConditional(Condition.affectedByLooting);
        } else if (lootFunction instanceof SetCount) {
            lootDrop.minDrop = MathHelper.func_76141_d((float)((SetCount)lootFunction).field_186568_a.func_186509_a());
            if (lootDrop.minDrop < 0) {
                lootDrop.minDrop = 0;
            }
            lootDrop.itemStack.func_190920_e(lootDrop.minDrop < 1 ? 1 : lootDrop.minDrop);
            lootDrop.maxDrop = MathHelper.func_76141_d((float)((SetCount)lootFunction).field_186568_a.func_186512_b());
        } else if (lootFunction instanceof SetMetadata) {
            lootDrop.itemStack.func_77964_b(MathHelper.func_76141_d((float)((SetMetadata)lootFunction).field_186573_b.func_186509_a()));
        } else if (lootFunction instanceof Smelt) {
            lootDrop.smeltedItem = lootFunction.func_186553_a(lootDrop.itemStack, null, null);
            if (ItemStack.func_77989_b((ItemStack)lootDrop.itemStack, (ItemStack)lootDrop.smeltedItem)) {
                lootDrop.smeltedItem = null;
            }
        } else {
            try {
                lootDrop.itemStack = lootFunction.func_186553_a(lootDrop.itemStack, null, null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public static List<ResourceLocation> getAllChestLootTablesResourceLocations() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(LootTableList.field_186420_b);
        list.add(LootTableList.field_186423_e);
        list.add(LootTableList.field_186422_d);
        list.add(LootTableList.field_186424_f);
        list.add(LootTableList.field_186429_k);
        list.add(LootTableList.field_186430_l);
        list.add(LootTableList.field_186428_j);
        list.add(LootTableList.field_186427_i);
        list.add(LootTableList.field_186426_h);
        list.add(LootTableList.field_186431_m);
        list.add(LootTableList.field_191192_o);
        list.add(LootTableList.field_186425_g);
        list.add(LootTableList.field_186421_c);
        return list;
    }

    public static List<PokeChestDrop> getAllPixelmonPokeChestDrops() {
        ArrayList<PokeChestDrop> list = new ArrayList<PokeChestDrop>();
        try {
            list.add(new PokeChestDrop(EnumPokeChestTier.TIER1, DropItemRegistry.tier1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            list.add(new PokeChestDrop(EnumPokeChestTier.TIER2, DropItemRegistry.tier2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            list.add(new PokeChestDrop(EnumPokeChestTier.TIER3, DropItemRegistry.tier3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            list.add(new PokeChestDrop(EnumPokeChestTier.TIER4, DropItemRegistry.ultraSpace));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static List<ShopkeeperData> getAllPixelmonShopKeepers() {
        try {
            return ServerNPCRegistry.getEnglishShopkeepers();
        }
        catch (Exception ex) {
            return new ArrayList<ShopkeeperData>();
        }
    }

    public static List<PokemonBossDrop> getAllPixelmonPokemonBossDrops() {
        ArrayList<PokemonBossDrop> drops = new ArrayList<PokemonBossDrop>();
        try {
            HashMap bossDrops = DropItemRegistry.bossDrops;
            if (bossDrops == null) {
                ModDetails.MOD_LOGGER.error("An issue occured on fetching DropItemRegistry.bossDrops.");
                return new ArrayList<PokemonBossDrop>();
            }
            bossDrops.entrySet().stream().filter(d -> ((EnumBossMode)d.getKey()).isBossPokemon() && d.getValue() != null && ((ArrayList)d.getValue()).size() > 0).sorted((d1, d2) -> ((EnumBossMode)d1.getKey()).compareTo((Enum)d2.getKey())).map(d -> new PokemonBossDrop((EnumBossMode)d.getKey(), (ArrayList)d.getValue())).forEach(drops::add);
            return drops;
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Error processing bossDrops.\n" + ex.getMessage());
            return new ArrayList<PokemonBossDrop>();
        }
    }

    public static List<PokemonDrop> getAllPixelmonDrops() {
        Field pokemonDropsField = null;
        try {
            pokemonDropsField = DropItemRegistry.class.getDeclaredField("pokemonDrops");
            if (pokemonDropsField == null) {
                ModDetails.MOD_LOGGER.error("An issue occured on getDeclaredField(pokemonDrops) from DropItemRegistry.");
                return new ArrayList<PokemonDrop>();
            }
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Encountered an issue fetching field pokemonDrops from DropItemRegistry.\n" + ex.getMessage());
            return new ArrayList<PokemonDrop>();
        }
        Object pokemonDropsValue = null;
        try {
            if (!pokemonDropsField.isAccessible()) {
                pokemonDropsField.setAccessible(true);
            }
            if ((pokemonDropsValue = pokemonDropsField.get(null)) == null) {
                ModDetails.MOD_LOGGER.error("Field value of pokemonDrops is null.");
                return new ArrayList<PokemonDrop>();
            }
            if (!(pokemonDropsValue instanceof Map)) {
                ModDetails.MOD_LOGGER.error("Field value of pokemonDrops is not a Map.");
                return new ArrayList<PokemonDrop>();
            }
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Encountered an issue fetching field value of pokemonDrops.\n" + ex.getMessage());
            return new ArrayList<PokemonDrop>();
        }
        Map pokemonDrops = null;
        try {
            pokemonDrops = (Map)pokemonDropsValue;
            if (pokemonDrops == null || pokemonDrops.size() == 0) {
                return new ArrayList<PokemonDrop>();
            }
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Encountered an issue assigning field value pokemonDrops to Map.\n" + ex.getMessage());
            return new ArrayList<PokemonDrop>();
        }
        ArrayList<PokemonDrop> drops = new ArrayList<PokemonDrop>();
        try {
            List values = pokemonDrops.values().stream().collect(Collectors.toList());
            Object value = values.get(0);
            if (value instanceof PokemonDropInformation) {
                ModDetails.MOD_LOGGER.info("pokemonDrops is a Map of PokemonDropInformation.");
                int[] sequence = new int[]{1};
                pokemonDrops.entrySet().stream().filter(d -> d.getKey() instanceof EnumSpecies).map(d -> new PokemonDrop((EnumSpecies)d.getKey(), sequence[0], (PokemonDropInformation)d.getValue())).forEach(drops::add);
            } else if (value instanceof Set) {
                ModDetails.MOD_LOGGER.info("pokemonDrops is a Map of Set<PokemonDropInformation>.");
                int[] sequence = new int[]{1};
                pokemonDrops.entrySet().stream().filter(d -> d.getKey() instanceof EnumSpecies).forEach(d -> {
                    sequence[0] = 1;
                    ((Set)d.getValue()).stream().filter(PokemonDropInformation.class::isInstance).map(i -> {
                        int n = sequence[0];
                        sequence[0] = n + 1;
                        return new PokemonDrop((EnumSpecies)d.getKey(), n, (PokemonDropInformation)i);
                    }).forEach(drops::add);
                });
            } else if (value instanceof List) {
                ModDetails.MOD_LOGGER.info("pokemonDrops is a Map of List<PokemonDropInformation>.");
                int[] sequence = new int[]{1};
                pokemonDrops.entrySet().stream().filter(d -> d.getKey() instanceof EnumSpecies).forEach(d -> {
                    sequence[0] = 1;
                    ((List)d.getValue()).stream().filter(PokemonDropInformation.class::isInstance).map(i -> {
                        int n = sequence[0];
                        sequence[0] = n + 1;
                        return new PokemonDrop((EnumSpecies)d.getKey(), n, (PokemonDropInformation)i);
                    }).forEach(drops::add);
                });
            } else {
                ModDetails.MOD_LOGGER.error("pokemonDrops is a Map of unknown type.");
            }
            drops.sort((i1, i2) -> i1.compareTo((PokemonDrop)i2));
            return drops;
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Error processing pokemonDrops.\n" + ex.getMessage());
            return new ArrayList<PokemonDrop>();
        }
    }

    public static Item getItem(LootEntryItem lootEntry) {
        return (Item)ReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String)"item", (String)"field_186368_a");
    }

    public static List<LootCondition> getLootConditions(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"poolConditions", (String)"field_186454_b");
    }

    public static List<LootEntry> getLootEntries(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"lootEntries", (String)"field_186453_a");
    }

    public static LootFunction[] getLootFunctions(LootEntryItem lootEntry) {
        return (LootFunction[])ReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String)"functions", (String)"field_186369_b");
    }

    public static List<LootPool> getLootPools(LootTable table) {
        return (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"pools", (String)"field_186466_c");
    }

    public static LootTableManager getLootTableManager() {
        return LootHelper.getLootTableManager(LootHelper.getWorld());
    }

    public static LootTableManager getLootTableManager(@Nullable World world) {
        if (world == null || world.func_184146_ak() == null) {
            return LootHelper.getWorld().func_184146_ak();
        }
        return world.func_184146_ak();
    }

    public static World getWorld() {
        Object world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            if (fakeWorld == null) {
                fakeWorld = new FakeWorld();
            }
            world = fakeWorld;
        }
        return world;
    }

    public static void postInitialise() {
        if (fakeWorld != null) {
            fakeWorld = null;
        }
    }
}

