/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.common;

import bletch.pixelmoninformation.jei.common.ItemDrop;
import bletch.pixelmoninformation.jei.enums.EnumItemDropType;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonDropInformation;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
public class PokemonDrop
implements Comparable<PokemonDrop> {
    private static final String FIELD_POKEMON = "pokemon";
    private static final String FIELD_MAIN_DROP = "mainDrop";
    private static final String FIELD_RARE_DROP = "rareDrop";
    private static final String FIELD_OPT_DROP1 = "optDrop1";
    private static final String FIELD_OPT_DROP2 = "optDrop2";
    private static final String FIELD_MAIN_DROP_MIN = "mainDropMin";
    private static final String FIELD_MAIN_DROP_MAX = "mainDropMax";
    private static final String FIELD_RARE_DROP_MIN = "rareDropMin";
    private static final String FIELD_RARE_DROP_MAX = "rareDropMax";
    private static final String FIELD_OPT_DROP1_MIN = "optDrop1Min";
    private static final String FIELD_OPT_DROP1_MAX = "optDrop1Max";
    private static final String FIELD_OPT_DROP2_MIN = "optDrop2Min";
    private static final String FIELD_OPT_DROP2_MAX = "optDrop2Max";
    private static final String[] FIELD_NAMES = new String[]{"pokemon", "mainDrop", "rareDrop", "optDrop1", "optDrop2", "mainDropMin", "mainDropMax", "rareDropMin", "rareDropMax", "optDrop1Min", "optDrop1Max", "optDrop2Min", "optDrop2Max"};
    private static List<Field> fields = null;
    private EnumSpecies species;
    private int speciesSequence;
    private ArrayList<ItemDrop> drops;

    public PokemonDrop(EnumSpecies species, int speciesSequence) {
        this(species, speciesSequence, new ArrayList<ItemDrop>());
    }

    public PokemonDrop(EnumSpecies species, int speciesSequence, ArrayList<ItemDrop> drops) {
        this.species = species;
        this.speciesSequence = speciesSequence;
        this.drops = drops;
    }

    public PokemonDrop(EnumSpecies species, int speciesSequence, PokemonDropInformation dropInfo) {
        this(species, speciesSequence, new ArrayList<ItemDrop>());
        this.processPokemonDropInformation(dropInfo);
    }

    public PokemonDrop(PokemonSpec pokemonSpec, int speciesSequence, ArrayList<ItemDrop> drops) {
        this.species = EnumSpecies.getFromNameAnyCase((String)pokemonSpec.name);
        this.speciesSequence = speciesSequence;
        this.drops = drops;
    }

    public PokemonDrop(PokemonSpec pokemonSpec, int speciesSequence, PokemonDropInformation dropInfo) {
        this(pokemonSpec, speciesSequence, new ArrayList<ItemDrop>());
        this.processPokemonDropInformation(dropInfo);
    }

    public EnumSpecies getSpecies() {
        return this.species;
    }

    public int getSpeciesSequence() {
        return this.speciesSequence;
    }

    public ArrayList<ItemDrop> getDrops() {
        return this.drops;
    }

    private void processPokemonDropInformation(PokemonDropInformation dropInfo) {
        if (fields == null) {
            PokemonDrop.openPokemonDropInformationFields();
        }
        HashMap fieldValues = new HashMap();
        fields.stream().forEach(f -> {
            try {
                fieldValues.put(f.getName(), f.get(dropInfo));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (fieldValues.containsKey(FIELD_POKEMON)) {
            Object pokemonValue = fieldValues.get(FIELD_POKEMON);
            if (pokemonValue instanceof EnumSpecies) {
                this.species = (EnumSpecies)pokemonValue;
            }
            if (pokemonValue instanceof PokemonSpec) {
                this.species = EnumSpecies.getFromNameAnyCase((String)((PokemonSpec)pokemonValue).name);
            }
        }
        if (fieldValues.containsKey(FIELD_MAIN_DROP) && fieldValues.get(FIELD_MAIN_DROP) != null && fieldValues.containsKey(FIELD_MAIN_DROP_MIN) && fieldValues.containsKey(FIELD_MAIN_DROP_MAX)) {
            this.drops.add(new ItemDrop((ItemStack)fieldValues.get(FIELD_MAIN_DROP), (Integer)fieldValues.get(FIELD_MAIN_DROP_MIN), (Integer)fieldValues.get(FIELD_MAIN_DROP_MAX), EnumItemDropType.MAIN));
        }
        if (fieldValues.containsKey(FIELD_OPT_DROP1) && fieldValues.get(FIELD_OPT_DROP1) != null && fieldValues.containsKey(FIELD_OPT_DROP1_MIN) && fieldValues.containsKey(FIELD_OPT_DROP1_MAX)) {
            this.drops.add(new ItemDrop((ItemStack)fieldValues.get(FIELD_OPT_DROP1), (Integer)fieldValues.get(FIELD_OPT_DROP1_MIN), (Integer)fieldValues.get(FIELD_OPT_DROP1_MAX), EnumItemDropType.OPTIONAL));
        }
        if (fieldValues.containsKey(FIELD_OPT_DROP2) && fieldValues.get(FIELD_OPT_DROP2) != null && fieldValues.containsKey(FIELD_OPT_DROP2_MIN) && fieldValues.containsKey(FIELD_OPT_DROP2_MAX)) {
            this.drops.add(new ItemDrop((ItemStack)fieldValues.get(FIELD_OPT_DROP2), (Integer)fieldValues.get(FIELD_OPT_DROP2_MIN), (Integer)fieldValues.get(FIELD_OPT_DROP2_MAX), EnumItemDropType.OPTIONAL));
        }
        if (fieldValues.containsKey(FIELD_RARE_DROP) && fieldValues.get(FIELD_RARE_DROP) != null && fieldValues.containsKey(FIELD_RARE_DROP_MIN) && fieldValues.containsKey(FIELD_RARE_DROP_MAX)) {
            this.drops.add(new ItemDrop((ItemStack)fieldValues.get(FIELD_RARE_DROP), (Integer)fieldValues.get(FIELD_RARE_DROP_MIN), (Integer)fieldValues.get(FIELD_RARE_DROP_MAX), EnumItemDropType.RARE));
        }
    }

    private static void openPokemonDropInformationFields() {
        List<String> fieldNames = Arrays.asList(FIELD_NAMES);
        try {
            fields = Arrays.asList(PokemonDropInformation.class.getDeclaredFields());
            fields.removeIf(f -> !fieldNames.contains(f.getName()));
            fields.stream().filter(f -> !f.isAccessible()).forEach(f -> f.setAccessible(true));
        }
        catch (Exception ex) {
            fields = new ArrayList<Field>();
        }
    }

    @Override
    public int compareTo(@Nonnull PokemonDrop o) {
        return this.species.name.compareToIgnoreCase(o.species.name);
    }
}

