/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.dungeon;

import bletch.pixelmoninformation.jei.common.LootHelper;
import bletch.pixelmoninformation.jei.dungeon.DungeonEntry;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class DungeonRegistry {
    public static IForgeRegistry<DungeonEntry> REGISTRY;

    private DungeonRegistry() {
    }

    public static void addEntry(DungeonEntry entry) {
        REGISTRY.register((IForgeRegistryEntry)entry);
    }

    public static void setRegistry(IForgeRegistry<DungeonEntry> registry) {
        REGISTRY = registry;
    }

    public static Collection<DungeonEntry> getEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static Collection<DungeonEntry> getValidEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static void initialize() {
        if (REGISTRY == null) {
            return;
        }
        LootTableManager manager = LootHelper.getLootTableManager();
        if (manager != null) {
            LootHelper.getAllChestLootTablesResourceLocations().stream().map(resourceLocation -> new DungeonEntry(resourceLocation.func_110623_a(), manager.func_186521_a(resourceLocation))).forEach(e -> DungeonRegistry.addEntry(e));
        }
    }
}

