/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.enums;

import bletch.pixelmoninformation.utils.TextUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.text.TextFormatting;

@ParametersAreNonnullByDefault
public enum EnumItemDropType {
    MAIN("main", "gui.itemdroptype.main.name"),
    OPTIONAL("optional", "gui.itemdroptype.optional.name"),
    RARE("rare", "gui.itemdroptype.rare.name");

    protected final String name;
    protected final String localiseKey;

    private EnumItemDropType(String name, String localiseKey) {
        this.name = name;
        this.localiseKey = localiseKey;
    }

    public TextFormatting getColor() {
        return EnumItemDropType.getColor(this);
    }

    public String getName() {
        return this.name;
    }

    public String getUnlocalisedName() {
        return this.localiseKey;
    }

    public String getLocalisedName() {
        return TextUtils.translate(this.localiseKey);
    }

    public String toString() {
        return this.getLocalisedName();
    }

    public static TextFormatting getColor(EnumItemDropType type) {
        switch (type) {
            case OPTIONAL: {
                return TextFormatting.GREEN;
            }
            case RARE: {
                return TextFormatting.GOLD;
            }
        }
        return TextFormatting.WHITE;
    }
}

