/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.infuser;

import bletch.pixelmoninformation.core.ModDetails;
import bletch.pixelmoninformation.jei.infuser.InfuserEntry;
import com.pixelmonmod.pixelmon.api.recipe.InfuserRecipes;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class InfuserRegistry {
    public static IForgeRegistry<InfuserEntry> REGISTRY;

    private InfuserRegistry() {
    }

    public static void addEntry(ItemStack input1, ItemStack input2, ItemStack output) {
        REGISTRY.register((IForgeRegistryEntry)new InfuserEntry(input1, input2, output));
    }

    public static void setRegistry(IForgeRegistry<InfuserEntry> registry) {
        REGISTRY = registry;
    }

    public static Collection<InfuserEntry> getEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static Collection<InfuserEntry> getValidEntries() {
        return REGISTRY.getValuesCollection();
    }

    public static void initialize() {
        if (REGISTRY == null) {
            return;
        }
        Map<?, ?> infuserRecipes = InfuserRegistry.getInfuserRecipeList(InfuserRecipes.instance());
        if (infuserRecipes == null || infuserRecipes.isEmpty()) {
            return;
        }
        for (Map.Entry<?, ?> recipe : infuserRecipes.entrySet()) {
            InfuserRegistry.addEntry((ItemStack)((Tuple)recipe.getKey()).func_76341_a(), (ItemStack)((Tuple)recipe.getKey()).func_76340_b(), (ItemStack)((Tuple)recipe.getValue()).func_76341_a());
        }
    }

    private static Map<?, ?> getInfuserRecipeList(InfuserRecipes infuserRecipes) {
        Field resultsListField = null;
        try {
            resultsListField = InfuserRecipes.class.getDeclaredField("resultsList");
            if (resultsListField == null) {
                ModDetails.MOD_LOGGER.error("An issue occured on getDeclaredField(resultsList) from InfuserRecipes.");
                return null;
            }
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Encountered an issue fetching field pokemonDrops from DropItemRegistry.\n" + ex.getMessage());
            return null;
        }
        Object resultsListValue = null;
        try {
            if (!resultsListField.isAccessible()) {
                resultsListField.setAccessible(true);
            }
            if ((resultsListValue = resultsListField.get(infuserRecipes)) == null) {
                ModDetails.MOD_LOGGER.error("Field value of resultsList is null.");
                return null;
            }
            if (!(resultsListValue instanceof Map)) {
                ModDetails.MOD_LOGGER.error("Field value of resultsList is not a Map.");
                return null;
            }
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Encountered an issue fetching field value of resultsList.\n" + ex.getMessage());
            return null;
        }
        Map resultsList = null;
        try {
            resultsList = (Map)resultsListValue;
            if (resultsList == null || resultsList.size() == 0) {
                return null;
            }
            return resultsList;
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error("Encountered an issue assigning field value resultsList to Map.\n" + ex.getMessage());
            return null;
        }
    }
}

