/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.pokemon;

import bletch.pixelmoninformation.core.ModDetails;
import bletch.pixelmoninformation.jei.PixelmonJei;
import bletch.pixelmoninformation.jei.pokemon.PokemonEntry;
import bletch.pixelmoninformation.utils.Font;
import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import org.lwjgl.opengl.GL11;

@ParametersAreNonnullByDefault
public class PokemonWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private static ResourceLocation[] pokemonGenerationTextures = null;
    private final PokemonEntry entry;
    private IFocus<ItemStack> focus;
    private GuiButton buttonPrev;
    private GuiButton buttonNext;
    private int pageIndex;
    private GuiButton buttonPrevBiome;
    private GuiButton buttonNextBiome;
    private int pageIndexBiome;

    public PokemonWrapper(PokemonEntry entry) {
        GuiHelper guiHelper;
        this.entry = entry;
        this.focus = null;
        this.pageIndex = 1;
        this.pageIndexBiome = 1;
        if (pokemonGenerationTextures == null) {
            this.populatePokemonGenerationTextures();
        }
        if ((guiHelper = (GuiHelper)PixelmonJei.getGuiHelper()) != null) {
            IDrawableStatic arrowPrevious = guiHelper.getArrowPrevious();
            IDrawableStatic arrowNext = guiHelper.getArrowNext();
            if (arrowPrevious != null && arrowNext != null) {
                this.buttonPrev = new GuiIconButtonSmall(0, 3, 97, 13, 13, (IDrawable)arrowPrevious);
                this.buttonNext = new GuiIconButtonSmall(1, 45, 97, 13, 13, (IDrawable)arrowNext);
                this.updateButtonsState();
            }
            IDrawableStatic arrowPreviousBiome = guiHelper.getArrowPrevious();
            IDrawableStatic arrowNextBiome = guiHelper.getArrowNext();
            if (arrowPreviousBiome != null && arrowNextBiome != null) {
                this.buttonPrevBiome = new GuiIconButtonSmall(2, 62, 97, 13, 13, (IDrawable)arrowPreviousBiome);
                this.buttonNextBiome = new GuiIconButtonSmall(3, 150, 97, 13, 13, (IDrawable)arrowNextBiome);
                this.updateButtonsStateBiomes();
            }
        }
    }

    public PokemonEntry getEntry() {
        return this.entry;
    }

    public IFocus<ItemStack> getFocus() {
        return this.focus;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageIndexBiome() {
        return this.pageIndexBiome;
    }

    public IFocus<ItemStack> setFocus(IFocus<ItemStack> focus) {
        if (!(this.focus == null && focus == null || this.focus != null && focus != null && this.focus.equals(focus))) {
            this.pageIndex = 1;
        }
        this.focus = focus;
        return this.focus;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, this.entry.getItemStacks(null));
    }

    public int amountOfItems() {
        return this.amountOfItems(this.focus);
    }

    public int amountOfItems(@Nullable IFocus<ItemStack> focus) {
        return this.getItems(focus).size();
    }

    public List<ItemStack> getItems() {
        return this.getItems(this.focus);
    }

    public List<ItemStack> getItems(@Nullable IFocus<ItemStack> focus) {
        List<ItemStack> stacks = this.entry.getItemStacks(focus);
        stacks.removeIf(Objects::isNull);
        return stacks;
    }

    public List<ItemStack> getItems(int startIndex, int count) {
        return this.getItems(this.focus, startIndex, count);
    }

    public List<ItemStack> getItems(@Nullable IFocus<ItemStack> focus, int startIndex, int count) {
        List<ItemStack> stacks = this.getItems(focus);
        if (stacks.size() <= startIndex) {
            return new ArrayList<ItemStack>(0);
        }
        if (stacks.size() <= startIndex + count) {
            count = stacks.size() - startIndex;
        }
        return stacks.subList(startIndex, startIndex + count);
    }

    public int amountOfBiomes() {
        return this.getBiomes().size();
    }

    public List<Biome> getBiomes() {
        List<Biome> biomes = this.entry.getBiomeList();
        biomes.removeIf(Objects::isNull);
        return biomes;
    }

    public List<Biome> getBiomes(int startIndex, int count) {
        List<Biome> biomes = this.getBiomes();
        if (biomes.size() <= startIndex) {
            return new ArrayList<Biome>(0);
        }
        if (biomes.size() <= startIndex + count) {
            count = biomes.size() - startIndex;
        }
        return biomes.subList(startIndex, startIndex + count);
    }

    private void populatePokemonGenerationTextures() {
        pokemonGenerationTextures = new ResourceLocation[9];
        PokemonWrapper.pokemonGenerationTextures[0] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen1.png");
        PokemonWrapper.pokemonGenerationTextures[1] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen2.png");
        PokemonWrapper.pokemonGenerationTextures[2] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen3.png");
        PokemonWrapper.pokemonGenerationTextures[3] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen4.png");
        PokemonWrapper.pokemonGenerationTextures[4] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen5.png");
        PokemonWrapper.pokemonGenerationTextures[5] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen6.png");
        PokemonWrapper.pokemonGenerationTextures[6] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen7.png");
        PokemonWrapper.pokemonGenerationTextures[7] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen8.png");
        PokemonWrapper.pokemonGenerationTextures[8] = new ResourceLocation("pixelmoninformation", "textures/pokemon/generations/gen9.png");
    }

    public void updateButtonsState() {
        double temp = (double)this.amountOfItems() / 12.0;
        int pages = (int)Math.ceil(temp);
        if (pages > 1) {
            this.buttonPrev.field_146125_m = true;
            this.buttonNext.field_146125_m = true;
        } else {
            this.buttonPrev.field_146125_m = false;
            this.buttonNext.field_146125_m = false;
        }
    }

    public void updateButtonsStateBiomes() {
        double temp = (double)this.amountOfBiomes() / 6.0;
        int pages = (int)Math.ceil(temp);
        if (pages > 1) {
            this.buttonPrevBiome.field_146125_m = true;
            this.buttonNextBiome.field_146125_m = true;
        } else {
            this.buttonPrevBiome.field_146125_m = false;
            this.buttonNextBiome.field_146125_m = false;
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        Font.normal.printLeft(this.entry.getLocalisedName(), 2, 2);
        int x = 0;
        int y = 0;
        x = 2;
        y = 10;
        String delimiter = " ";
        String output = TextUtils.translate("gui.pokemon.type");
        Font.small.printLeft(output, x, y);
        x += Font.small.getStringWidth(output);
        for (EnumType type : this.entry.getTypeList()) {
            Font.small.printLeft(delimiter, x, y);
            output = type.getLocalizedName();
            Font.small.printLeft(output, x += Font.small.getStringWidth(delimiter), y, type.getColor());
            x += Font.small.getStringWidth(output);
            delimiter = ", ";
        }
        Font.small.printLeft(String.format(TextUtils.translate("gui.pokemon.dexnum"), this.entry.getSpecies().getNationalPokedexNumber()), 2, 18);
        Font.small.printLeft(String.format(TextUtils.translate("gui.pokemon.drops"), ""), 2, 28);
        double temp = (double)this.amountOfItems() / 12.0;
        int pages = (int)Math.ceil(temp);
        if (pages > 1) {
            Gui.func_73734_a((int)3, (int)97, (int)58, (int)110, (int)0x40FFFFFF);
            Font.normal.printCentered(this.pageIndex + "/" + pages, 30, 100, Color.WHITE.getRGB(), true);
        }
        this.buttonPrev.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
        this.buttonNext.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
        int startIndex = (this.pageIndexBiome - 1) * 6;
        List<Biome> biomes = this.getBiomes(startIndex, 6);
        x = 63;
        y = 38;
        temp = (double)this.amountOfBiomes() / 6.0;
        pages = (int)Math.ceil(temp);
        if (pages > 1) {
            Gui.func_73734_a((int)62, (int)97, (int)163, (int)110, (int)0x40FFFFFF);
            Font.normal.printCentered(this.pageIndexBiome + "/" + pages, 112, 100, Color.WHITE.getRGB(), true);
        }
        Font.small.printLeft(String.format(TextUtils.translate("gui.pokemon.biomes"), ""), 63, 28);
        for (int biomeIndex = 0; biomeIndex < biomes.size(); ++biomeIndex) {
            Font.small.printLeft(Font.small.trimStringToWidth(biomes.get(biomeIndex).func_185359_l(), 99, true), x, y, Color.WHITE.getRGB(), true);
            y += Font.small.fontRenderer.field_78288_b;
        }
        this.buttonPrevBiome.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
        this.buttonNextBiome.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
        int pokemonGeneration = this.entry.getGeneration();
        if (pokemonGeneration > 0 && pokemonGeneration < pokemonGenerationTextures.length) {
            boolean u = false;
            boolean v = false;
            int width = 24;
            int height = 11;
            x = recipeWidth - width;
            y = 0;
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            minecraft.func_110434_K().func_110577_a(pokemonGenerationTextures[pokemonGeneration - 1]);
            Gui.func_146110_a((int)x, (int)y, (float)((float)u), (float)((float)v), (int)width, (int)height, (float)width, (float)height);
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        String output;
        LinkedList<String> tooltip = new LinkedList<String>();
        int height = Font.normal.fontRenderer.field_78288_b;
        if (mouseY >= 2 && mouseY <= height + 2) {
            String name = this.entry.getLocalisedName();
            int width = Font.normal.getStringWidth(name);
            if (mouseX >= 2 && mouseX <= width + 2 && !StringUtils.isNullOrWhitespace(output = this.entry.getLocalizedDescription()).booleanValue()) {
                tooltip.add(TextFormatting.DARK_AQUA + name);
                tooltip.add(output);
            }
        }
        height = Font.small.fontRenderer.field_78288_b;
        if (mouseY >= 10 && mouseY <= height + 10) {
            String delimiter = " ";
            int x = 2;
            output = TextUtils.translate("gui.pokemon.type");
            x += Font.small.getStringWidth(output);
            for (EnumType type : this.entry.getTypeList()) {
                String typeValue = type.name().toLowerCase();
                output = type.getLocalizedName();
                int width = Font.small.getStringWidth(output);
                if (mouseX >= (x += Font.small.getStringWidth(delimiter)) && mouseX <= width + x) {
                    tooltip.add(TextFormatting.DARK_AQUA + output);
                    output = TextUtils.translate("pokemontype." + typeValue + ".strong");
                    if (!StringUtils.isNullOrWhitespace(output).booleanValue()) {
                        tooltip.add(output);
                    }
                    if (!StringUtils.isNullOrWhitespace(output = TextUtils.translate("pokemontype." + typeValue + ".weak")).booleanValue()) {
                        tooltip.add(output);
                    }
                    if (StringUtils.isNullOrWhitespace(output = TextUtils.translate("pokemontype." + typeValue + ".bad")).booleanValue()) break;
                    tooltip.add(output);
                    break;
                }
                x += width;
                delimiter = ", ";
            }
        }
        return tooltip;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        RecipesGui recipesGui;
        double temp = (double)this.amountOfItems() / 12.0;
        int pages = (int)Math.ceil(temp);
        if (this.buttonPrev.func_146116_c(minecraft, mouseX, mouseY)) {
            this.buttonPrev.func_146113_a(minecraft.func_147118_V());
            try {
                recipesGui = (RecipesGui)PixelmonJei.getJeiRuntime().getRecipesGui();
                if (recipesGui != null) {
                    --this.pageIndex;
                    if (this.pageIndex <= 0) {
                        this.pageIndex = pages;
                    }
                    recipesGui.onStateChange();
                    this.updateButtonsState();
                    return true;
                }
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (this.buttonNext.func_146116_c(minecraft, mouseX, mouseY)) {
            this.buttonNext.func_146113_a(minecraft.func_147118_V());
            try {
                recipesGui = (RecipesGui)PixelmonJei.getJeiRuntime().getRecipesGui();
                if (recipesGui != null) {
                    ++this.pageIndex;
                    if (this.pageIndex > pages) {
                        this.pageIndex = 1;
                    }
                    recipesGui.onStateChange();
                    this.updateButtonsState();
                    return true;
                }
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        temp = (double)this.amountOfBiomes() / 6.0;
        pages = (int)Math.ceil(temp);
        if (this.buttonPrevBiome.func_146116_c(minecraft, mouseX, mouseY)) {
            this.buttonPrevBiome.func_146113_a(minecraft.func_147118_V());
            try {
                --this.pageIndexBiome;
                if (this.pageIndexBiome <= 0) {
                    this.pageIndexBiome = pages;
                }
                this.updateButtonsStateBiomes();
                return true;
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (this.buttonNextBiome.func_146116_c(minecraft, mouseX, mouseY)) {
            this.buttonNextBiome.func_146113_a(minecraft.func_147118_V());
            try {
                ++this.pageIndexBiome;
                if (this.pageIndexBiome > pages) {
                    this.pageIndexBiome = 1;
                }
                this.updateButtonsStateBiomes();
                return true;
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        return false;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        tooltip.add(this.entry.getItemDrop(ingredient).toString());
    }
}

