/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.pokemonboss;

import bletch.pixelmoninformation.core.ModDetails;
import bletch.pixelmoninformation.jei.PixelmonJei;
import bletch.pixelmoninformation.jei.pokemonboss.PokemonBossEntry;
import bletch.pixelmoninformation.utils.Font;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
public class PokemonBossWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final PokemonBossEntry entry;
    private IFocus<ItemStack> focus;
    private GuiButton buttonPrev;
    private GuiButton buttonNext;
    private int pageIndex;

    public PokemonBossWrapper(PokemonBossEntry entry) {
        this.entry = entry;
        this.focus = null;
        this.pageIndex = 1;
        GuiHelper guiHelper = (GuiHelper)PixelmonJei.getGuiHelper();
        if (guiHelper != null) {
            IDrawableStatic arrowPrevious = guiHelper.getArrowPrevious();
            IDrawableStatic arrowNext = guiHelper.getArrowNext();
            if (arrowPrevious != null && arrowNext != null) {
                this.buttonPrev = new GuiIconButtonSmall(0, 3, 104, 13, 13, (IDrawable)arrowPrevious);
                this.buttonNext = new GuiIconButtonSmall(1, 153, 104, 13, 13, (IDrawable)arrowNext);
                this.updateButtonsState();
            }
        }
    }

    public PokemonBossEntry getEntry() {
        return this.entry;
    }

    public IFocus<ItemStack> getFocus() {
        return this.focus;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public IFocus<ItemStack> setFocus(IFocus<ItemStack> focus) {
        if (!(this.focus == null && focus == null || this.focus != null && focus != null && this.focus.equals(focus))) {
            this.pageIndex = 1;
        }
        this.focus = focus;
        return this.focus;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, this.entry.getItemStacks(null));
    }

    public int amountOfItems() {
        return this.amountOfItems(this.focus);
    }

    public int amountOfItems(@Nullable IFocus<ItemStack> focus) {
        return this.getItems(focus).size();
    }

    public List<ItemStack> getItems() {
        return this.getItems(this.focus);
    }

    public List<ItemStack> getItems(@Nullable IFocus<ItemStack> focus) {
        List<ItemStack> stacks = this.entry.getItemStacks(focus);
        stacks.removeIf(Objects::isNull);
        return stacks;
    }

    public List<ItemStack> getItems(int startIndex, int count) {
        return this.getItems(this.focus, startIndex, count);
    }

    public List<ItemStack> getItems(@Nullable IFocus<ItemStack> focus, int startIndex, int count) {
        List<ItemStack> stacks = this.getItems(focus);
        if (stacks.size() <= startIndex) {
            return new ArrayList<ItemStack>(0);
        }
        if (stacks.size() <= startIndex + count) {
            count = stacks.size() - startIndex;
        }
        return stacks.subList(startIndex, startIndex + count);
    }

    public void updateButtonsState() {
        double temp = (double)this.amountOfItems() / 45.0;
        int pages = (int)Math.ceil(temp);
        if (pages > 1) {
            this.buttonPrev.field_146125_m = true;
            this.buttonNext.field_146125_m = true;
        } else {
            this.buttonPrev.field_146125_m = false;
            this.buttonNext.field_146125_m = false;
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        Font.normal.printLeft(this.entry.getLocalisedName(), 2, 2);
        double temp = (double)this.amountOfItems() / 45.0;
        int pages = (int)Math.ceil(temp);
        if (pages > 1) {
            Gui.func_73734_a((int)3, (int)104, (int)166, (int)117, (int)0x40FFFFFF);
            Font.normal.printCentered(this.pageIndex + "/" + pages, 84, 107, Color.WHITE.getRGB(), true);
        }
        this.buttonPrev.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
        this.buttonNext.func_191745_a(minecraft, mouseX, mouseY, 1.0f);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        RecipesGui recipesGui;
        double temp = (double)this.amountOfItems() / 45.0;
        int pages = (int)Math.ceil(temp);
        if (this.buttonPrev.func_146116_c(minecraft, mouseX, mouseY)) {
            this.buttonPrev.func_146113_a(minecraft.func_147118_V());
            try {
                recipesGui = (RecipesGui)PixelmonJei.getJeiRuntime().getRecipesGui();
                if (recipesGui != null) {
                    --this.pageIndex;
                    if (this.pageIndex <= 0) {
                        this.pageIndex = pages;
                    }
                    recipesGui.onStateChange();
                    this.updateButtonsState();
                    return true;
                }
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        if (this.buttonNext.func_146116_c(minecraft, mouseX, mouseY)) {
            this.buttonNext.func_146113_a(minecraft.func_147118_V());
            try {
                recipesGui = (RecipesGui)PixelmonJei.getJeiRuntime().getRecipesGui();
                if (recipesGui != null) {
                    ++this.pageIndex;
                    if (this.pageIndex > pages) {
                        this.pageIndex = 1;
                    }
                    recipesGui.onStateChange();
                    this.updateButtonsState();
                    return true;
                }
            }
            catch (Exception ex) {
                ModDetails.MOD_LOGGER.error(ex.getMessage());
            }
        }
        return false;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
    }
}

