/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.jei.shopkeeper;

import bletch.pixelmoninformation.core.ModDetails;
import bletch.pixelmoninformation.utils.TextUtils;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class ShopKeeperEntry
extends IForgeRegistryEntry.Impl<ShopKeeperEntry> {
    private static Map<String, String> nameToLocalKeyMap = null;
    private ShopkeeperData shopkeeperData;
    private ArrayList<ShopItem> items;

    public ShopKeeperEntry(ShopkeeperData shopkeeperData) {
        this.shopkeeperData = shopkeeperData;
        this.items = new ArrayList();
        this.processShopItems(shopkeeperData);
        String resourcePath = "pixelmoninformation/shopkeeper_" + this.shopkeeperData.id;
        this.setRegistryName(new ResourceLocation("jei", resourcePath));
    }

    public ShopkeeperData getShopkeeperData() {
        return this.shopkeeperData;
    }

    public ShopItem getShopItem(ItemStack ingredient) {
        return this.items.stream().filter(shopItem -> ItemStack.func_179545_c((ItemStack)shopItem.getItemStack(), (ItemStack)ingredient)).findFirst().orElse(null);
    }

    public List<ItemStack> getItemStacks(@Nullable IFocus<ItemStack> focus) {
        return this.items.stream().map(shopItem -> shopItem.getItemStack()).filter(itemStack -> focus == null || ItemStack.func_77989_b((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)((ItemStack)focus.getValue()).func_190916_E()), (ItemStack)((ItemStack)focus.getValue()))).collect(Collectors.toList());
    }

    public String getLocalisedName() {
        String name;
        if (nameToLocalKeyMap == null) {
            ShopKeeperEntry.initializeShopKeepers();
        }
        return TextUtils.translate((name = nameToLocalKeyMap.get(this.shopkeeperData.id)) == null ? this.shopkeeperData.id : name);
    }

    private void processShopItems(ShopkeeperData shopkeeperData) {
        try {
            Field itemsField = ShopkeeperData.class.getDeclaredField("items");
            if (!itemsField.isAccessible()) {
                itemsField.setAccessible(true);
            }
            this.items = (ArrayList)itemsField.get(shopkeeperData);
        }
        catch (Exception ex) {
            ModDetails.MOD_LOGGER.error(ex.getMessage());
        }
    }

    private static void initializeShopKeepers() {
        nameToLocalKeyMap = new LinkedHashMap<String, String>();
        nameToLocalKeyMap.put("pokemartmain1", "jei.shopkeeper.pokemartmain1.name");
        nameToLocalKeyMap.put("pokemartmain2", "jei.shopkeeper.pokemartmain2.name");
        nameToLocalKeyMap.put("pokemartmain3", "jei.shopkeeper.pokemartmain3.name");
        nameToLocalKeyMap.put("pokemartsecond1", "jei.shopkeeper.pokemartsecond1.name");
        nameToLocalKeyMap.put("pokemartsecond2", "jei.shopkeeper.pokemartsecond2.name");
        nameToLocalKeyMap.put("pokemartsecond3", "jei.shopkeeper.pokemartsecond3.name");
        nameToLocalKeyMap.put("spawn1", "jei.shopkeeper.spawn1.name");
    }
}

