/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.top;

import bletch.pixelmoninformation.PixelmonInformation;
import bletch.pixelmoninformation.core.ModConfig;
import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.google.common.base.Function;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityApricornTree;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityBerryTree;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PixelmonBlockTop {

    public static class getTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static final String KEY_SUFFIX_INFORMATION = ".pinformation";
        public static final String KEY_SUFFIX_TOOLTIP = ".ptooltip";
        public static final int APRICORNTREE_MAX_STAGE = 6;
        public static final int BERRYTREE_MAX_STAGE = 5;
        public static ITheOneProbe probe;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "pixelmoninformation:default";
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
                    Block block = state.func_177230_c();
                    if (block.getRegistryName().func_110624_b().equalsIgnoreCase("pixelmon")) {
                        getTheOneProbe.addProbeInfo(mode, probeInfo, player, world, state, data);
                    }
                }
            });
            probe.registerBlockDisplayOverride((mode, probeInfo, player, world, state, data) -> {
                Block block = state.func_177230_c();
                if (block.getRegistryName().func_110624_b().equalsIgnoreCase("pixelmon")) {
                    return getTheOneProbe.overrideStandardInfo(mode, probeInfo, player, world, state, data);
                }
                return false;
            });
            return null;
        }

        private static boolean addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
            String output;
            List<String> results;
            Minecraft minecraft = null;
            if (PixelmonInformation.proxy.isRemote()) {
                minecraft = Minecraft.func_71410_x();
            }
            if (ModConfig.top.useSneaking && mode == ProbeMode.NORMAL) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            ItemStack itemStack = data.getPickBlock();
            if (!itemStack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("pixelmon")) {
                itemStack = tileEntity != null ? new ItemStack(state.func_177230_c(), 1, tileEntity.func_145832_p()) : new ItemStack(state.func_177230_c());
            }
            if (ModConfig.top.blocks.showBlockTooltip) {
                String translateKey_tooltip = itemStack.func_77977_a() + KEY_SUFFIX_TOOLTIP;
                if (ModConfig.debug.enableDebug && ModConfig.debug.showTopBlockTranslationKey) {
                    probeInfo.text(TextUtils.translate("gui.translationkey") + " " + translateKey_tooltip);
                }
                if ((results = StringUtils.split(output = TextUtils.translate(translateKey_tooltip), minecraft, 4, true, true)) != null && !results.isEmpty()) {
                    results.forEach(r -> probeInfo.text(r));
                }
            }
            if (ModConfig.top.blocks.showBlockInformation) {
                String translateKey_information = itemStack.func_77977_a() + KEY_SUFFIX_INFORMATION;
                if (ModConfig.debug.enableDebug && ModConfig.debug.showTopBlockTranslationKey) {
                    probeInfo.text(TextUtils.translate("gui.translationkey") + " " + translateKey_information);
                }
                if ((results = StringUtils.split(output = TextUtils.translate(translateKey_information), minecraft, 4)) != null && !results.isEmpty()) {
                    results.forEach(r -> probeInfo.text(r));
                }
            }
            if (tileEntity instanceof TileEntityApricornTree && ModConfig.top.blocks.showGrowthStages) {
                int stage = ((TileEntityApricornTree)tileEntity).getStage() + 1;
                if (stage < 6) {
                    probeInfo.text(TextUtils.translate("gui.growthstage") + " " + stage + " / " + 6);
                } else {
                    probeInfo.text(TextUtils.translate("gui.growthstage") + " " + TextUtils.translate("gui.growthcomplete"));
                }
            }
            if (tileEntity instanceof TileEntityBerryTree && ModConfig.top.blocks.showGrowthStages) {
                byte stage = ((TileEntityBerryTree)tileEntity).getStage();
                if (stage < 5) {
                    probeInfo.text(TextUtils.translate("gui.growthstage") + " " + stage + " / " + 5);
                } else {
                    probeInfo.text(TextUtils.translate("gui.growthstage") + " " + TextUtils.translate("gui.growthcomplete"));
                }
            }
            return true;
        }

        private static boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
            return false;
        }
    }
}

