/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.top;

import bletch.pixelmoninformation.PixelmonInformation;
import bletch.pixelmoninformation.core.ModConfig;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.google.common.base.Function;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class PixelmonEntityTop {

    public static class getTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerEntityProvider(new IProbeInfoEntityProvider(){

                public String getID() {
                    return "pixelmoninformation:default";
                }

                public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
                    if (entity instanceof EntityPixelmon) {
                        getTheOneProbe.addEntityPixelmonInfo(mode, probeInfo, player, world, (EntityPixelmon)entity, data);
                    }
                    if (entity instanceof EntityNPC) {
                        getTheOneProbe.addEntityNPCInfo(mode, probeInfo, player, world, (EntityNPC)entity, data);
                    }
                }
            });
            probe.registerEntityDisplayOverride((mode, probeInfo, player, world, entity, data) -> {
                if (entity instanceof EntityPixelmon) {
                    return getTheOneProbe.overrideEntityPixelmonInfo(mode, probeInfo, player, world, (EntityPixelmon)entity, data);
                }
                if (entity instanceof EntityNPC) {
                    return getTheOneProbe.overrideEntityNPCInfo(mode, probeInfo, player, world, (EntityNPC)entity, data);
                }
                return false;
            });
            return null;
        }

        private static boolean addEntityPixelmonInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, EntityPixelmon entity, IProbeHitEntityData data) {
            Minecraft minecraft = null;
            if (PixelmonInformation.proxy.isRemote()) {
                minecraft = Minecraft.func_71410_x();
            }
            if (ModConfig.top.useSneaking && mode == ProbeMode.NORMAL) {
                return false;
            }
            if (entity != null) {
                List<String> results;
                int percentage;
                int maxTotal;
                int value;
                int total;
                StatsType[] statTypes;
                Object output2;
                Object delimiter;
                String output;
                String output3;
                String output32;
                List<String> results2;
                EnumSpecies pokemonSpecies = entity.getSpecies();
                Pokemon pokemon = null;
                BaseStats baseStats = null;
                if (ModConfig.top.entities.showPokemonDescription && (results2 = StringUtils.split(output32 = EntityPixelmon.getLocalizedDescription((String)pokemonSpecies.getPokemonName()), minecraft, 4)) != null && !results2.isEmpty()) {
                    results2.forEach(r -> probeInfo.text(r));
                }
                if (ModConfig.top.entities.showPokemonOwner && entity.hasOwner()) {
                    String ownerName = entity.func_70902_q().func_70005_c_();
                    output3 = TextUtils.translate("gui.pokemon.owner") + " " + TextFormatting.WHITE + ownerName;
                    probeInfo.text(TextFormatting.DARK_AQUA + output3);
                }
                if (ModConfig.top.entities.showPokemonLevel) {
                    Level level = entity.getLvl();
                    output3 = TextUtils.translate("gui.pokemon.level") + " " + TextFormatting.WHITE + level.getLevel();
                    probeInfo.text(TextFormatting.DARK_AQUA + output3);
                }
                if (ModConfig.top.entities.showPokemonNationalPokedexNumber && !StringUtils.isNullOrWhitespace(output = String.format(TextUtils.translate("gui.pokemon.dexnum"), TextFormatting.WHITE + pokemonSpecies.getNationalPokedexNumber())).booleanValue()) {
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                }
                if (ModConfig.top.entities.showPokemonGeneration && !StringUtils.isNullOrWhitespace(output = TextUtils.translate("gui.pokemon.generation") + " " + TextFormatting.WHITE + pokemonSpecies.getGeneration()).booleanValue()) {
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                }
                if (ModConfig.top.entities.showPokemonEVs) {
                    delimiter = " ";
                    output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.evstats") + TextFormatting.YELLOW;
                    output2 = "";
                    if (pokemon == null) {
                        pokemon = entity.getPokemonData();
                    }
                    if (pokemon != null) {
                        EVStore eVStore = pokemon.getEVs();
                        statTypes = StatsType.getStatValues();
                        total = 0;
                        for (StatsType type : statTypes) {
                            value = eVStore.get(type);
                            total += value;
                            output2 = (String)output2 + (String)delimiter;
                            output2 = (String)output2 + type.getLocalizedName();
                            output2 = (String)output2 + " (" + value + ")";
                            delimiter = ", ";
                        }
                        maxTotal = EVStore.MAX_TOTAL_EVS;
                        percentage = (int)(100.0 / (double)maxTotal * (double)total);
                        results = StringUtils.split(output3 = output3 + " " + total + "/" + maxTotal + TextFormatting.WHITE + " (" + percentage + "%) - " + (String)output2, minecraft, 4, false);
                        if (results != null && !results.isEmpty()) {
                            results.forEach(r -> probeInfo.text(TextFormatting.WHITE + r));
                        }
                    }
                }
                if (ModConfig.top.entities.showPokemonIVs) {
                    delimiter = " ";
                    output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.ivstats") + TextFormatting.YELLOW;
                    output2 = "";
                    if (pokemon == null) {
                        pokemon = entity.getPokemonData();
                    }
                    if (pokemon != null) {
                        IVStore iVStore = pokemon.getIVs();
                        statTypes = StatsType.getStatValues();
                        total = 0;
                        for (StatsType type : statTypes) {
                            value = iVStore.get(type);
                            total += value;
                            output2 = (String)output2 + (String)delimiter;
                            output2 = (String)output2 + type.getLocalizedName();
                            output2 = (String)output2 + " (" + value + ")";
                            delimiter = ", ";
                        }
                        maxTotal = 31 * statTypes.length;
                        percentage = (int)(100.0 / (double)maxTotal * (double)total);
                        results = StringUtils.split(output3 = output3 + " " + total + "/" + maxTotal + TextFormatting.WHITE + " (" + percentage + "%) - " + (String)output2, minecraft, 4, false);
                        if (results != null && !results.isEmpty()) {
                            results.forEach(r -> probeInfo.text(TextFormatting.WHITE + r));
                        }
                    }
                }
                if (ModConfig.top.entities.showPokemonEVYield) {
                    delimiter = " ";
                    output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.evyield") + TextFormatting.WHITE;
                    if (baseStats == null) {
                        baseStats = pokemonSpecies.getBaseStats();
                    }
                    if (baseStats != null) {
                        for (Map.Entry entry : baseStats.evYields.entrySet()) {
                            output3 = output3 + (String)delimiter;
                            output3 = output3 + ((StatsType)entry.getKey()).getLocalizedName();
                            output3 = output3 + " (" + entry.getValue() + ")";
                            delimiter = ", ";
                        }
                        if (!StringUtils.isNullOrWhitespace(output3).booleanValue()) {
                            probeInfo.text(output3);
                        }
                    }
                }
                if (minecraft != null && ModConfig.top.entities.showPokemonNatureInformation) {
                    Object nature;
                    delimiter = " ";
                    output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.nature") + TextFormatting.WHITE;
                    if (pokemon == null) {
                        pokemon = entity.getPokemonData();
                    }
                    if (pokemon != null && (nature = pokemon.getNature()) != null) {
                        output3 = output3 + (String)delimiter;
                        output3 = output3 + nature.getLocalizedName();
                    }
                    if (!StringUtils.isNullOrWhitespace(output3).booleanValue()) {
                        probeInfo.text(output3);
                    }
                }
                if (ModConfig.top.entities.showPokemonTypeInformation) {
                    delimiter = " ";
                    output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.type") + TextFormatting.WHITE;
                    if (baseStats == null) {
                        baseStats = pokemonSpecies.getBaseStats();
                    }
                    if (baseStats != null) {
                        for (EnumType enumType : baseStats.getTypeList()) {
                            output3 = output3 + (String)delimiter;
                            output3 = output3 + enumType.getLocalizedName();
                            delimiter = ", ";
                        }
                        if (!StringUtils.isNullOrWhitespace(output3).booleanValue()) {
                            probeInfo.text(output3);
                        }
                    }
                }
                if (ModConfig.top.entities.showPokemonTypeMatchupInformation) {
                    if (baseStats == null) {
                        baseStats = pokemonSpecies.getBaseStats();
                    }
                    if (baseStats != null) {
                        for (EnumType type : baseStats.getTypeList()) {
                            String typeValue = type.name().toLowerCase();
                            String string = type.getLocalizedName();
                            String output4 = TextUtils.translate("pokemontype." + typeValue + ".strong");
                            if (!StringUtils.isNullOrWhitespace(output4).booleanValue()) {
                                probeInfo.text(TextFormatting.DARK_AQUA + string + ": " + output4);
                            }
                            if (!StringUtils.isNullOrWhitespace(output4 = TextUtils.translate("pokemontype." + typeValue + ".weak")).booleanValue()) {
                                probeInfo.text(TextFormatting.DARK_AQUA + string + ": " + output4);
                            }
                            if (StringUtils.isNullOrWhitespace(output4 = TextUtils.translate("pokemontype." + typeValue + ".bad")).booleanValue()) continue;
                            probeInfo.text(TextFormatting.DARK_AQUA + string + ": " + output4);
                        }
                    }
                }
                if (ModConfig.top.entities.showPokemonCaught) {
                    try {
                        String caughtStatus = TextUtils.SYMBOL_UNKNOWN;
                        Pokedex pokedex = PixelmonUtils.getClientPokedex();
                        if (pokedex != null) {
                            caughtStatus = pokedex.hasCaught(pokemonSpecies.getNationalPokedexInteger()) ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS;
                        }
                        String output5 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.caught") + " " + caughtStatus;
                        probeInfo.text(output5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }

        private static boolean addEntityNPCInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, EntityNPC entity, IProbeHitEntityData data) {
            return false;
        }

        private static boolean overrideEntityPixelmonInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, EntityPixelmon entity, IProbeHitEntityData data) {
            if (entity != null) {
                String tooltip = TextFormatting.RESET.toString();
                if (entity.isBossPokemon()) {
                    EnumBossMode bossMode = entity.getBossMode();
                    switch (bossMode) {
                        case Uncommon: {
                            tooltip = tooltip + TextFormatting.GREEN;
                            break;
                        }
                        case Rare: {
                            tooltip = tooltip + TextFormatting.YELLOW;
                            break;
                        }
                        case Legendary: {
                            tooltip = tooltip + TextFormatting.RED;
                            break;
                        }
                        case Ultimate: {
                            tooltip = tooltip + TextFormatting.GOLD;
                            break;
                        }
                        default: {
                            tooltip = tooltip + TextFormatting.WHITE;
                        }
                    }
                    tooltip = tooltip + bossMode.getLocalizedName() + " ";
                }
                tooltip = tooltip + TextFormatting.WHITE + entity.getLocalizedName();
                Pokemon pokemon = entity.getPokemonData();
                if (pokemon != null && !StringUtils.isNullOrWhitespace(pokemon.getNickname()).booleanValue()) {
                    tooltip = tooltip + TextFormatting.ITALIC + " (" + pokemon.getNickname() + ")";
                }
                if (pokemon != null) {
                    switch (pokemon.getGender()) {
                        case Female: {
                            tooltip = tooltip + " " + TextUtils.SYMBOL_FEMALE;
                            break;
                        }
                        case Male: {
                            tooltip = tooltip + " " + TextUtils.SYMBOL_MALE;
                            break;
                        }
                    }
                }
                probeInfo.vertical().text(tooltip).text(TextStyleClass.MODNAME + Tools.getModName((Entity)entity));
                return true;
            }
            return false;
        }

        private static boolean overrideEntityNPCInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, EntityNPC entity, IProbeHitEntityData data) {
            if (entity != null) {
                NPCNurseJoy npc;
                String npcText;
                String tooltip = TextFormatting.RESET.toString();
                if (entity instanceof NPCNurseJoy && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCNurseJoy)entity).getDisplayText()).booleanValue()) {
                    tooltip = tooltip + TextFormatting.WHITE + npcText;
                }
                if (entity instanceof NPCTrainer) {
                    npc = (NPCTrainer)entity;
                    EnumBossMode bossMode = npc.getBossMode();
                    switch (bossMode) {
                        case Uncommon: {
                            tooltip = tooltip + TextFormatting.GREEN + bossMode.getLocalizedName() + " ";
                            break;
                        }
                        case Rare: {
                            tooltip = tooltip + TextFormatting.YELLOW + bossMode.getLocalizedName() + " ";
                            break;
                        }
                        case Legendary: {
                            tooltip = tooltip + TextFormatting.RED + bossMode.getLocalizedName() + " ";
                            break;
                        }
                        case Ultimate: {
                            tooltip = tooltip + TextFormatting.GOLD + bossMode.getLocalizedName() + " ";
                            break;
                        }
                    }
                    String npcLevel = npc.getSubTitleText() + " " + npc.getLvl();
                    if (!StringUtils.isNullOrWhitespace(npcLevel).booleanValue()) {
                        tooltip = tooltip + TextFormatting.WHITE + npcLevel;
                    }
                }
                if (entity instanceof NPCShopkeeper && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCShopkeeper)entity).getDisplayText()).booleanValue()) {
                    tooltip = tooltip + TextFormatting.WHITE + npcText;
                }
                if (entity instanceof NPCRelearner && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCRelearner)entity).getDisplayText()).booleanValue()) {
                    tooltip = tooltip + TextFormatting.WHITE + npcText;
                }
                if (entity instanceof NPCTrader && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCTrader)entity).getDisplayText()).booleanValue()) {
                    tooltip = tooltip + TextFormatting.WHITE + npcText;
                }
                if (entity instanceof NPCTutor && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCTutor)entity).getDisplayText()).booleanValue()) {
                    tooltip = tooltip + TextFormatting.WHITE + npcText;
                }
                if (entity instanceof NPCChatting && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCChatting)entity).getDisplayText()).booleanValue()) {
                    tooltip = tooltip + TextFormatting.WHITE + npcText;
                }
                if (!StringUtils.isNullOrWhitespace(tooltip).booleanValue() && !tooltip.equalsIgnoreCase(TextFormatting.RESET.toString())) {
                    probeInfo.vertical().text(tooltip).text(TextStyleClass.MODNAME + Tools.getModName((Entity)entity));
                } else {
                    probeInfo.vertical().text(TextStyleClass.MODNAME + Tools.getModName((Entity)entity));
                }
                return true;
            }
            return false;
        }
    }
}

