/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.utils;

import bletch.pixelmoninformation.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

@ParametersAreNonnullByDefault
public class TextUtils {
    public static final String SEPARATOR_COLON = " : ";
    public static final String SEPARATOR_DASH = " - ";
    public static final String SEPARATOR_FSLASH = "/";
    public static final String SEPARATOR_TIMES = "x ";
    public static final String INDENT = "  ";
    public static final String SYMBOL_GREENTICK = TextFormatting.GREEN + "\u2714";
    public static final String SYMBOL_REDCROSS = TextFormatting.RED + "\u2718";
    public static final String SYMBOL_UNKNOWN = TextFormatting.GOLD + "?";
    public static final String SYMBOL_FEMALE = TextFormatting.LIGHT_PURPLE + "\u2640";
    public static final String SYMBOL_MALE = TextFormatting.BLUE + "\u2642";
    public static final String KEY_HELP = "gui.help";
    public static final String KEY_INFO = "gui.info";
    public static final String KEY_CONTROLHELP = "gui.showcontrolhelp";
    public static final String KEY_CONTROLINFO = "gui.showcontrolinfo";
    public static final String KEY_SHIFTHELP = "gui.showshifthelp";
    public static final String KEY_SHIFTINFO = "gui.showshiftinfo";

    public static boolean canTranslate(String key) {
        return I18n.func_94522_b((String)key);
    }

    public static String translate(String translateKey) {
        if (StringUtils.isNullOrWhitespace(translateKey).booleanValue() || !TextUtils.canTranslate(translateKey)) {
            return "";
        }
        String value = I18n.func_74838_a((String)translateKey);
        if (StringUtils.isNullOrWhitespace(value).booleanValue() || value.equalsIgnoreCase(translateKey)) {
            return "";
        }
        return value;
    }

    public static List<String> translateMulti(String translateKey) {
        if (StringUtils.isNullOrWhitespace(translateKey).booleanValue() || !TextUtils.canTranslate(translateKey)) {
            return null;
        }
        String value = I18n.func_74838_a((String)translateKey);
        if (StringUtils.isNullOrWhitespace(value).booleanValue() || value.equalsIgnoreCase(translateKey)) {
            return null;
        }
        String[] values = value.split("\\\\n");
        return Arrays.asList(values);
    }

    public static String getClientLocale() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }
}

