/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.waila;

import bletch.pixelmoninformation.PixelmonInformation;
import bletch.pixelmoninformation.core.ModConfig;
import bletch.pixelmoninformation.utils.DebugUtils;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityApricornTree;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityBerryTree;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class PixelmonBlockWaila
implements IWailaDataProvider {
    public static final String KEY_SUFFIX_INFORMATION = ".pinformation";
    public static final String KEY_SUFFIX_TOOLTIP = ".ptooltip";
    public static final int APRICORNTREE_MAX_STAGE = 6;
    public static final int BERRYTREE_MAX_STAGE = 5;

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String output;
        List<String> results;
        Minecraft minecraft = null;
        if (PixelmonInformation.proxy.isRemote()) {
            minecraft = Minecraft.func_71410_x();
        }
        if (ModConfig.waila.useSneaking && !accessor.getPlayer().func_70093_af()) {
            return currentTip;
        }
        TileEntity tileEntity = accessor.getTileEntity();
        if (ModConfig.waila.blocks.showBlockTooltip) {
            String translateKey_tooltip = itemStack.func_77977_a() + KEY_SUFFIX_TOOLTIP;
            if (ModConfig.debug.enableDebug && ModConfig.debug.showWailaBlockTranslationKey) {
                currentTip.add(TextUtils.translate("gui.translationkey") + " " + translateKey_tooltip);
            }
            if ((results = StringUtils.split(output = TextUtils.translate(translateKey_tooltip), minecraft, 4)) != null && !results.isEmpty()) {
                currentTip.addAll(results);
            }
        }
        if (ModConfig.waila.blocks.showBlockInformation) {
            String translateKey_information = itemStack.func_77977_a() + KEY_SUFFIX_INFORMATION;
            if (ModConfig.debug.enableDebug && ModConfig.debug.showWailaBlockTranslationKey) {
                currentTip.add(TextUtils.translate("gui.translationkey") + " " + translateKey_information);
            }
            if ((results = StringUtils.split(output = TextUtils.translate(translateKey_information), minecraft, 4)) != null && !results.isEmpty()) {
                currentTip.addAll(results);
            }
        }
        if (tileEntity instanceof TileEntityApricornTree && ModConfig.waila.blocks.showGrowthStages) {
            int stage = ((TileEntityApricornTree)tileEntity).getStage() + 1;
            if (stage < 6) {
                currentTip.add(TextUtils.translate("gui.growthstage") + " " + stage + " / " + 6);
            } else {
                currentTip.add(TextUtils.translate("gui.growthstage") + " " + TextUtils.translate("gui.growthcomplete"));
            }
        }
        if (tileEntity instanceof TileEntityBerryTree && ModConfig.waila.blocks.showGrowthStages) {
            byte stage = ((TileEntityBerryTree)tileEntity).getStage();
            if (stage < 5) {
                currentTip.add(TextUtils.translate("gui.growthstage") + " " + stage + " / " + 5);
            } else {
                currentTip.add(TextUtils.translate("gui.growthstage") + " " + TextUtils.translate("gui.growthcomplete"));
            }
        }
        return currentTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tag, World world, BlockPos position) {
        if (tileEntity != null) {
            tileEntity.func_189515_b(tag);
        }
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        PixelmonBlockWaila dataProvider = new PixelmonBlockWaila();
        ArrayList<String> processed = new ArrayList<String>();
        ArrayList pixelmonClassess = new ArrayList();
        pixelmonClassess.addAll(PixelmonUtils.getPixelmonBlockClasses());
        for (int i = pixelmonClassess.size() - 1; i >= 0; --i) {
            if (!pixelmonClassess.contains(((Class)pixelmonClassess.get(i)).getSuperclass())) continue;
            pixelmonClassess.remove(i);
        }
        for (Class clazz : pixelmonClassess) {
            String key = clazz.getTypeName();
            if (processed.contains(key)) continue;
            processed.add(key);
            registrar.registerNBTProvider((IWailaDataProvider)dataProvider, clazz);
            registrar.registerBodyProvider((IWailaDataProvider)dataProvider, clazz);
            if (!ModConfig.debug.enableDebug || !ModConfig.debug.showWailaBlocksRegistered) continue;
            DebugUtils.writeLine("Registered WAILA information for block " + key, true);
        }
    }
}

