/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.waila;

import bletch.pixelmoninformation.PixelmonInformation;
import bletch.pixelmoninformation.core.ModConfig;
import bletch.pixelmoninformation.utils.DebugUtils;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class PixelmonEntityWaila
implements IWailaEntityProvider {
    private static String NBT_TAG_EVSTORE = "pokemon_evstore";
    private static String NBT_TAG_IVSTORE = "pokemon_ivstore";
    private static String NBT_TAG_NATURE = "pokemon_nature";

    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return accessor.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> currentTip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        EnumBossMode bossMode;
        EntityPixelmon pixelmon;
        if (entity instanceof EntityPixelmon && (pixelmon = (EntityPixelmon)entity) != null) {
            String tooltip = TextFormatting.RESET.toString();
            if (pixelmon.isBossPokemon()) {
                bossMode = pixelmon.getBossMode();
                switch (bossMode) {
                    case Uncommon: {
                        tooltip = tooltip + TextFormatting.GREEN;
                        break;
                    }
                    case Rare: {
                        tooltip = tooltip + TextFormatting.YELLOW;
                        break;
                    }
                    case Legendary: {
                        tooltip = tooltip + TextFormatting.RED;
                        break;
                    }
                    case Ultimate: {
                        tooltip = tooltip + TextFormatting.GOLD;
                        break;
                    }
                    default: {
                        tooltip = tooltip + TextFormatting.WHITE;
                    }
                }
                tooltip = tooltip + bossMode.getLocalizedName() + " ";
            }
            tooltip = tooltip + TextFormatting.WHITE + pixelmon.getLocalizedName();
            Pokemon pokemon = pixelmon.getPokemonData();
            if (pokemon != null && !StringUtils.isNullOrWhitespace(pokemon.getNickname()).booleanValue()) {
                tooltip = tooltip + TextFormatting.ITALIC + " (" + pokemon.getNickname() + ")";
            }
            if (pokemon != null) {
                switch (pokemon.getGender()) {
                    case Female: {
                        tooltip = tooltip + " " + TextUtils.SYMBOL_FEMALE;
                        break;
                    }
                    case Male: {
                        tooltip = tooltip + " " + TextUtils.SYMBOL_MALE;
                        break;
                    }
                }
            }
            if (currentTip.size() > 0) {
                currentTip.set(0, tooltip);
            } else {
                currentTip.add(tooltip);
            }
        }
        if (entity instanceof EntityNPC) {
            NPCNurseJoy npc;
            String npcText;
            String tooltip = TextFormatting.RESET.toString();
            if (entity instanceof NPCNurseJoy && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCNurseJoy)entity).getDisplayText()).booleanValue()) {
                tooltip = tooltip + TextFormatting.WHITE + npcText;
            }
            if (entity instanceof NPCTrainer) {
                npc = (NPCTrainer)entity;
                bossMode = npc.getBossMode();
                switch (bossMode) {
                    case Uncommon: {
                        tooltip = tooltip + TextFormatting.GREEN + bossMode.getLocalizedName() + " ";
                        break;
                    }
                    case Rare: {
                        tooltip = tooltip + TextFormatting.YELLOW + bossMode.getLocalizedName() + " ";
                        break;
                    }
                    case Legendary: {
                        tooltip = tooltip + TextFormatting.RED + bossMode.getLocalizedName() + " ";
                        break;
                    }
                    case Ultimate: {
                        tooltip = tooltip + TextFormatting.GOLD + bossMode.getLocalizedName() + " ";
                        break;
                    }
                }
                String npcLevel = npc.getSubTitleText() + " " + npc.getLvl();
                if (!StringUtils.isNullOrWhitespace(npcLevel).booleanValue()) {
                    tooltip = tooltip + TextFormatting.WHITE + npcLevel;
                }
            }
            if (entity instanceof NPCShopkeeper && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCShopkeeper)entity).getDisplayText()).booleanValue()) {
                tooltip = tooltip + TextFormatting.WHITE + npcText;
            }
            if (entity instanceof NPCRelearner && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCRelearner)entity).getDisplayText()).booleanValue()) {
                tooltip = tooltip + TextFormatting.WHITE + npcText;
            }
            if (entity instanceof NPCTrader && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCTrader)entity).getDisplayText()).booleanValue()) {
                tooltip = tooltip + TextFormatting.WHITE + npcText;
            }
            if (entity instanceof NPCTutor && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCTutor)entity).getDisplayText()).booleanValue()) {
                tooltip = tooltip + TextFormatting.WHITE + npcText;
            }
            if (entity instanceof NPCChatting && !StringUtils.isNullOrWhitespace(npcText = (npc = (NPCChatting)entity).getDisplayText()).booleanValue()) {
                tooltip = tooltip + TextFormatting.WHITE + npcText;
            }
            if (!StringUtils.isNullOrWhitespace(tooltip).booleanValue() && !tooltip.equalsIgnoreCase(TextFormatting.RESET.toString())) {
                if (currentTip.size() > 0) {
                    currentTip.set(0, tooltip);
                } else {
                    currentTip.add(tooltip);
                }
            } else if (currentTip.size() > 0) {
                currentTip.remove(0);
            }
        }
        return currentTip;
    }

    public List<String> getWailaBody(Entity entity, List<String> currentTip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        Minecraft minecraft = null;
        if (PixelmonInformation.proxy.isRemote()) {
            minecraft = Minecraft.func_71410_x();
        }
        if (ModConfig.waila.useSneaking && !accessor.getPlayer().func_70093_af()) {
            return currentTip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        if (entity instanceof EntityPixelmon) {
            List<String> results;
            int percentage;
            int maxTotal;
            int value;
            int total;
            StatsType[] statTypes;
            Object output2;
            Object delimiter;
            String output;
            String output3;
            String output32;
            List<String> results2;
            EntityPixelmon pixelmon = (EntityPixelmon)entity;
            EnumSpecies pokemonSpecies = pixelmon.getSpecies();
            BaseStats baseStats = null;
            if (ModConfig.waila.entities.showPokemonDescription && (results2 = StringUtils.split(output32 = EntityPixelmon.getLocalizedDescription((String)pokemonSpecies.getPokemonName()), minecraft, 4)) != null && !results2.isEmpty()) {
                results2.forEach(r -> currentTip.add((String)r));
            }
            if (ModConfig.waila.entities.showPokemonOwner && ((EntityPixelmon)entity).hasOwner()) {
                String ownerName = ((EntityPixelmon)entity).func_70902_q().func_70005_c_();
                output3 = TextUtils.translate("gui.pokemon.owner") + " " + TextFormatting.WHITE + ownerName;
                currentTip.add(TextFormatting.DARK_AQUA + output3);
            }
            if (ModConfig.waila.entities.showPokemonLevel) {
                Level level = ((EntityPixelmon)entity).getLvl();
                output3 = TextUtils.translate("gui.pokemon.level") + " " + TextFormatting.WHITE + level.getLevel();
                currentTip.add(TextFormatting.DARK_AQUA + output3);
            }
            if (ModConfig.waila.entities.showPokemonNationalPokedexNumber && !StringUtils.isNullOrWhitespace(output = String.format(TextUtils.translate("gui.pokemon.dexnum"), TextFormatting.WHITE + pokemonSpecies.getNationalPokedexNumber())).booleanValue()) {
                currentTip.add(TextFormatting.DARK_AQUA + output);
            }
            if (ModConfig.waila.entities.showPokemonGeneration && !StringUtils.isNullOrWhitespace(output = TextUtils.translate("gui.pokemon.generation") + " " + TextFormatting.WHITE + pokemonSpecies.getGeneration()).booleanValue()) {
                currentTip.add(TextFormatting.DARK_AQUA + output);
            }
            if (tag.func_74764_b(NBT_TAG_EVSTORE) && ModConfig.waila.entities.showPokemonEVs) {
                delimiter = " ";
                output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.evstats") + TextFormatting.YELLOW;
                output2 = "";
                EVStore eVStore = new EVStore();
                eVStore.readFromNBT(tag.func_74775_l(NBT_TAG_EVSTORE));
                statTypes = StatsType.getStatValues();
                total = 0;
                for (StatsType type : statTypes) {
                    value = eVStore.get(type);
                    total += value;
                    output2 = (String)output2 + (String)delimiter;
                    output2 = (String)output2 + type.getLocalizedName();
                    output2 = (String)output2 + " (" + value + ")";
                    delimiter = ", ";
                }
                maxTotal = EVStore.MAX_TOTAL_EVS;
                percentage = (int)(100.0 / (double)maxTotal * (double)total);
                results = StringUtils.split(output3 = output3 + " " + total + "/" + maxTotal + TextFormatting.WHITE + " (" + percentage + "%) - " + (String)output2, minecraft, 4, false);
                if (results != null && !results.isEmpty()) {
                    results.forEach(r -> currentTip.add(TextFormatting.WHITE + r));
                }
            }
            if (tag.func_74764_b(NBT_TAG_IVSTORE) && ModConfig.waila.entities.showPokemonIVs) {
                delimiter = " ";
                output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.ivstats") + TextFormatting.YELLOW;
                output2 = "";
                IVStore iVStore = new IVStore();
                iVStore.readFromNBT(tag.func_74775_l(NBT_TAG_IVSTORE));
                statTypes = StatsType.getStatValues();
                total = 0;
                for (StatsType type : statTypes) {
                    value = iVStore.get(type);
                    total += value;
                    output2 = (String)output2 + (String)delimiter;
                    output2 = (String)output2 + type.getLocalizedName();
                    output2 = (String)output2 + " (" + value + ")";
                    delimiter = ", ";
                }
                maxTotal = 31 * statTypes.length;
                percentage = (int)(100.0 / (double)maxTotal * (double)total);
                results = StringUtils.split(output3 = output3 + " " + total + "/" + maxTotal + TextFormatting.WHITE + " (" + percentage + "%) - " + (String)output2, minecraft, 4, false);
                if (results != null && !results.isEmpty()) {
                    results.forEach(r -> currentTip.add(TextFormatting.WHITE + r));
                }
            }
            if (ModConfig.waila.entities.showPokemonEVYield) {
                delimiter = " ";
                output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.evyield") + TextFormatting.WHITE;
                if (baseStats == null) {
                    baseStats = pokemonSpecies.getBaseStats();
                }
                if (baseStats != null) {
                    for (Map.Entry entry : baseStats.evYields.entrySet()) {
                        output3 = output3 + (String)delimiter;
                        output3 = output3 + ((StatsType)entry.getKey()).getLocalizedName();
                        output3 = output3 + " (" + entry.getValue() + ")";
                        delimiter = ", ";
                    }
                    if (!StringUtils.isNullOrWhitespace(output3).booleanValue()) {
                        currentTip.add(output3);
                    }
                }
            }
            if (tag.func_74764_b(NBT_TAG_NATURE) && ModConfig.waila.entities.showPokemonNatureInformation) {
                int n;
                EnumNature nature;
                delimiter = " ";
                output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.nature") + TextFormatting.WHITE;
                Pokemon pokemon = pixelmon.getPokemonData();
                if (pokemon != null && (nature = EnumNature.getNatureFromIndex((int)(n = tag.func_74762_e(NBT_TAG_NATURE)))) != null) {
                    output3 = output3 + (String)delimiter;
                    output3 = output3 + nature.getLocalizedName();
                }
                if (!StringUtils.isNullOrWhitespace(output3).booleanValue()) {
                    currentTip.add(output3);
                }
            }
            if (ModConfig.waila.entities.showPokemonTypeInformation) {
                delimiter = " ";
                output3 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.type") + TextFormatting.WHITE;
                if (baseStats == null) {
                    baseStats = pokemonSpecies.getBaseStats();
                }
                if (baseStats != null) {
                    for (EnumType enumType : baseStats.getTypeList()) {
                        output3 = output3 + (String)delimiter;
                        output3 = output3 + enumType.getLocalizedName();
                        delimiter = ", ";
                    }
                    if (!StringUtils.isNullOrWhitespace(output3).booleanValue()) {
                        currentTip.add(output3);
                    }
                }
            }
            if (ModConfig.waila.entities.showPokemonTypeMatchupInformation) {
                if (baseStats == null) {
                    baseStats = pokemonSpecies.getBaseStats();
                }
                if (baseStats != null) {
                    for (EnumType type : baseStats.getTypeList()) {
                        String typeValue = type.name().toLowerCase();
                        String string = type.getLocalizedName();
                        String output4 = TextUtils.translate("pokemontype." + typeValue + ".strong");
                        if (!StringUtils.isNullOrWhitespace(output4).booleanValue()) {
                            currentTip.add(TextFormatting.DARK_AQUA + string + ": " + output4);
                        }
                        if (!StringUtils.isNullOrWhitespace(output4 = TextUtils.translate("pokemontype." + typeValue + ".weak")).booleanValue()) {
                            currentTip.add(TextFormatting.DARK_AQUA + string + ": " + output4);
                        }
                        if (StringUtils.isNullOrWhitespace(output4 = TextUtils.translate("pokemontype." + typeValue + ".bad")).booleanValue()) continue;
                        currentTip.add(TextFormatting.DARK_AQUA + string + ": " + output4);
                    }
                }
            }
            if (ModConfig.waila.entities.showPokemonCaught) {
                try {
                    String caughtStatus = TextUtils.SYMBOL_UNKNOWN;
                    Pokedex pokedex = PixelmonUtils.getClientPokedex();
                    if (pokedex != null) {
                        caughtStatus = pokedex.hasCaught(pokemonSpecies.getNationalPokedexInteger()) ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS;
                    }
                    String output5 = TextFormatting.DARK_AQUA + TextUtils.translate("gui.pokemon.caught") + " " + caughtStatus;
                    currentTip.add(output5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return currentTip;
    }

    public List<String> getWailaTail(Entity entity, List<String> currentTip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        EntityPixelmon pixelmon;
        Pokemon pokemon;
        if (entity != null) {
            entity.func_189511_e(tag);
        }
        if (entity instanceof EntityPixelmon && (pokemon = (pixelmon = (EntityPixelmon)entity).getPokemonData()) != null) {
            NBTTagCompound evTag = new NBTTagCompound();
            EVStore evStore = pokemon.getEVs();
            evStore.writeToNBT(evTag);
            NBTTagCompound ivTag = new NBTTagCompound();
            IVStore ivStore = pokemon.getIVs();
            ivStore.writeToNBT(ivTag);
            EnumNature nature = pokemon.getNature();
            tag.func_74782_a(NBT_TAG_EVSTORE, (NBTBase)evTag);
            tag.func_74782_a(NBT_TAG_IVSTORE, (NBTBase)ivTag);
            tag.func_74768_a(NBT_TAG_NATURE, nature.index);
        }
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        PixelmonEntityWaila entityProvider = new PixelmonEntityWaila();
        ArrayList<String> processed = new ArrayList<String>();
        for (Class<?> entity : PixelmonEntityWaila.getPixelmonEntities()) {
            String key = entity.getTypeName();
            if (processed.contains(key)) continue;
            processed.add(key);
            registrar.registerNBTProvider((IWailaEntityProvider)entityProvider, entity);
            registrar.registerHeadProvider((IWailaEntityProvider)entityProvider, entity);
            registrar.registerBodyProvider((IWailaEntityProvider)entityProvider, entity);
            if (!ModConfig.debug.enableDebug || !ModConfig.debug.showWailaEntitiesRegistered) continue;
            DebugUtils.writeLine("Registered WAILA information for entity " + key, true);
        }
    }

    private static ArrayList<Class<?>> getPixelmonEntities() {
        ArrayList list = new ArrayList();
        list.add(EntityPixelmon.class);
        list.add(EntityNPC.class);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.contains(((Class)list.get(i)).getSuperclass())) continue;
            list.remove(i);
        }
        list.sort((c1, c2) -> c1.getTypeName().compareTo(c2.getTypeName()));
        list.trimToSize();
        return list;
    }
}

