/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop;

import moe.plushie.armourers_workshop.common.command.CommandArmourers;
import moe.plushie.armourers_workshop.common.creativetab.CreativeTabMain;
import moe.plushie.armourers_workshop.common.creativetab.CreativeTabPaintingTools;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.proxies.CommonProxy;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="armourers_workshop", name="Armourer's Workshop", version="1.12.2-0.50.1", guiFactory="moe.plushie.armourers_workshop.client.gui.config.ModGuiFactory", dependencies="required-after:forge@[14.23.3.2694,);after:galacticraftcore;", acceptedMinecraftVersions="1.12.2", updateJSON="http://plushie.moe/app_update/minecraft_mods/armourers_workshop/update.json")
public class ArmourersWorkshop {
    @Mod.Instance(value="armourers_workshop")
    private static ArmourersWorkshop instance;
    private static Logger logger;
    @SidedProxy(clientSide="moe.plushie.armourers_workshop.proxies.ClientProxy", serverSide="moe.plushie.armourers_workshop.proxies.CommonProxy")
    private static CommonProxy proxy;
    public static final CreativeTabMain TAB_MAIN;
    public static final CreativeTabPaintingTools TAB_PAINTING_TOOLS;

    @Mod.EventHandler
    public void perInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ModLogger.log(String.format("Loading %s version %s.", "Armourer's Workshop", "1.12.2-0.50.1"));
        proxy.preInit(event);
        proxy.initLibraryManager();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        proxy.registerKeyBindings();
        proxy.initRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandArmourers());
        CommonSkinCache.INSTANCE.serverStarted();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        CommonSkinCache.INSTANCE.serverStopped();
    }

    public static boolean isDedicated() {
        return proxy.getClass() == CommonProxy.class;
    }

    public static CommonProxy getProxy() {
        return proxy;
    }

    public static ArmourersWorkshop getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        TAB_MAIN = new CreativeTabMain();
        TAB_PAINTING_TOOLS = new CreativeTabPaintingTools();
    }
}

