/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.config;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConfigHandlerClient {
    public static final String CATEGORY_MISC = "misc";
    public static final String CATEGORY_PERFORMANCE = "performance";
    public static final String CATEGORY_CACHE = "cache";
    public static final String CATEGORY_SKIN_PREVIEW = "skin-preview";
    public static final String CATEGORY_DEBUG = "debug";
    public static int renderDistanceSkin;
    public static int renderDistanceBlockSkin;
    public static int renderDistanceMannequinEquipment;
    public static int modelBakingThreadCount;
    public static AtomicInteger modelBakingUpdateRate;
    public static double lodDistance;
    public static boolean multipassSkinRendering;
    public static boolean slowModelBaking;
    public static int maxLodLevels;
    public static boolean useClassicBlockModels;
    public static int skinLoadAnimationTime;
    public static int skinCacheExpireTime;
    public static int skinCacheMaxSize;
    public static int modelPartCacheExpireTime;
    public static int modelPartCacheMaxSize;
    public static int textureCacheExpireTime;
    public static int textureCacheMaxSize;
    public static int maxSkinRequests;
    public static boolean skinPreEnabled;
    public static boolean skinPreDrawBackground;
    public static float skinPreSize;
    public static float skinPreLocHorizontal;
    public static float skinPreLocVertical;
    public static boolean skinPreLocFollowMouse;
    public static int texturePaintingType;
    public static boolean showF3DebugInfo;
    public static boolean showSkinTooltipDebugInfo;
    public static boolean showArmourerDebugRender;
    public static boolean wireframeRender;
    public static boolean showLodLevels;
    public static boolean showSkinBlockBounds;
    public static boolean showSkinRenderBounds;
    public static boolean showSortOrderToolTip;
    public static Configuration config;

    public static void init(File file) {
        if (config == null) {
            config = new Configuration(file, "1");
            ConfigHandlerClient.loadConfigFile();
        }
    }

    public static void loadConfigFile() {
        ConfigHandlerClient.loadCategoryMisc();
        ConfigHandlerClient.loadCategoryPerformance();
        ConfigHandlerClient.loadCategoryCache();
        ConfigHandlerClient.loadCategorySkinPreview();
        ConfigHandlerClient.loadCategoryDebug();
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void loadCategoryMisc() {
        config.setCategoryComment(CATEGORY_MISC, "Miscellaneous settings.");
        skinLoadAnimationTime = config.getInt("skinLoadAnimationTime", CATEGORY_MISC, 200, 0, 10000, "How long skins will display their loading animation for in milliseconds\nSettings this to 0 will disable loading animations.");
    }

    private static void loadCategoryPerformance() {
        config.setCategoryComment(CATEGORY_PERFORMANCE, "Change (visual quality/performance) ratio by category setting in this category.");
        renderDistanceSkin = config.getInt("renderDistanceSkin", CATEGORY_PERFORMANCE, 128, 16, 512, "The max distance in blocks that skins will render.");
        renderDistanceBlockSkin = config.getInt("renderDistanceBlockSkin", CATEGORY_PERFORMANCE, 128, 16, 512, "The max distance in blocks that block skins will be rendered.");
        renderDistanceBlockSkin *= renderDistanceBlockSkin;
        renderDistanceMannequinEquipment = config.getInt("renderDistanceMannequinEquipment", CATEGORY_PERFORMANCE, 64, 16, 512, "The max distance in blocks that equipment will be rendered on mannequins.");
        slowModelBaking = config.getBoolean("slowModelBaking", CATEGORY_PERFORMANCE, true, "Limits how fast models can be baked to provide a smoother frame rate.");
        int cores = Runtime.getRuntime().availableProcessors();
        int bakingCores = MathHelper.func_76123_f((float)((float)cores / 2.0f));
        bakingCores = MathHelper.func_76125_a((int)bakingCores, (int)1, (int)16);
        modelBakingThreadCount = config.getInt("modelBakingThreadCount", CATEGORY_PERFORMANCE, bakingCores, 1, 16, "");
        config.getCategory(CATEGORY_PERFORMANCE).get("modelBakingThreadCount").setComment("The maximum number of threads that will be used to bake models. [range: 1 ~ 16, default: core count / 2]");
        config.getCategory(CATEGORY_PERFORMANCE).get("modelBakingThreadCount").setRequiresMcRestart(true);
        int updateRate = config.getInt("modelBakingUpdateRate", CATEGORY_PERFORMANCE, 40, 10, 1000, "How fast models are allowed to bake. Lower values will give smoother frame rate but models will load slower.\nHas no effect if 'slowModelBaking' is turned off.");
        modelBakingUpdateRate.set(updateRate);
        multipassSkinRendering = config.getBoolean("multipassSkinRendering", CATEGORY_PERFORMANCE, true, "When enabled skin will render in multiple passes to reduce visual artifacts.\nDisabling this will improve skin rendering performance at the cost of visual quality.");
        lodDistance = config.getFloat("lodDistance", CATEGORY_PERFORMANCE, 32.0f, 8.0f, 128.0f, "Distance away that skins will have lod applied to them.");
        maxLodLevels = config.getInt("maxLodLevels", CATEGORY_PERFORMANCE, 4, 0, 4, "Number of LOD models to create. Higher number should give a boost to framerate at a small cost to VRAM.");
        useClassicBlockModels = config.getBoolean("useClassicBlockModels", CATEGORY_PERFORMANCE, false, "Use classic block models instead of the 3D model versions.");
    }

    private static void loadCategoryCache() {
        config.setCategoryComment(CATEGORY_CACHE, "Change (memory use/IO access) ratio by category setting in this category.");
        skinCacheExpireTime = config.getInt("skinCacheExpireTime", CATEGORY_CACHE, 600, 0, 3600, "How long in seconds the client will keep skins in it's cache.\nDefault 600 seconds is 10 minutes.\nSetting to 0 turns off this option.");
        config.getCategory(CATEGORY_CACHE).get("skinCacheExpireTime").setRequiresMcRestart(true);
        skinCacheMaxSize = config.getInt("skinCacheMaxSize", CATEGORY_CACHE, 2000, 0, 10000, "Max size the skin cache can reach before skins are removed.\nSetting to 0 turns off this option.");
        config.getCategory(CATEGORY_CACHE).get("skinCacheMaxSize").setRequiresMcRestart(true);
        modelPartCacheExpireTime = config.getInt("modelPartCacheExpireTime", CATEGORY_CACHE, 600, 0, 3600, "How long in seconds the client will keep model parts in it's cache.\nDefault 600 seconds is 10 minutes.\nSetting to 0 turns off this option.");
        config.getCategory(CATEGORY_CACHE).get("modelPartCacheExpireTime").setRequiresMcRestart(true);
        modelPartCacheMaxSize = config.getInt("modelPartCacheMaxSize", CATEGORY_CACHE, 2000, 0, 10000, "Max size the cache can reach before model parts are removed.\nSetting to 0 turns off this option.");
        config.getCategory(CATEGORY_CACHE).get("modelPartCacheMaxSize").setRequiresMcRestart(true);
        textureCacheExpireTime = config.getInt("textureCacheExpireTime", CATEGORY_CACHE, 600, 0, 3600, "How long in seconds the client will keep textures in it's cache.\nDefault 600 seconds is 10 minutes.\nSetting to 0 turns off this option.");
        config.getCategory(CATEGORY_CACHE).get("textureCacheExpireTime").setRequiresMcRestart(true);
        textureCacheMaxSize = config.getInt("textureCacheMaxSize", CATEGORY_CACHE, 1000, 0, 5000, "Max size the texture cache can reach before textures are removed.\nSetting to 0 turns off this option.");
        config.getCategory(CATEGORY_CACHE).get("textureCacheMaxSize").setRequiresMcRestart(true);
        maxSkinRequests = config.getInt("maxSkinRequests", CATEGORY_CACHE, 10, 1, 50, "Maximum number of skin the client can request at one time.");
    }

    private static void loadCategorySkinPreview() {
        config.setCategoryComment(CATEGORY_SKIN_PREVIEW, "Setting to configure the skin preview box.");
        skinPreEnabled = config.getBoolean("skinPreEnabled", CATEGORY_SKIN_PREVIEW, true, "Enables a larger skin preview box when hovering the mouse over a skin.");
        skinPreDrawBackground = config.getBoolean("skinPreDrawBackground", CATEGORY_SKIN_PREVIEW, true, "Draw a background box for the skin preview.");
        skinPreSize = config.getFloat("skinPreSize", CATEGORY_SKIN_PREVIEW, 96.0f, 16.0f, 256.0f, "Size of the skin preview.");
        skinPreLocHorizontal = config.getFloat("skinPreLocHorizontal", CATEGORY_SKIN_PREVIEW, 0.0f, 0.0f, 1.0f, "Horizontal location of the skin preview: 0 = left, 1 = right.");
        skinPreLocVertical = config.getFloat("skinPreLocVertical", CATEGORY_SKIN_PREVIEW, 0.5f, 0.0f, 1.0f, "Vertical location of the skin preview: 0 = top, 1 = bottom.");
        skinPreLocFollowMouse = config.getBoolean("skinPreLocFollowMouse", CATEGORY_SKIN_PREVIEW, true, "Skin preview will be rendered next to the mouse.");
    }

    private static void loadCategoryDebug() {
        config.setCategoryComment(CATEGORY_DEBUG, "Debug settings.");
        showF3DebugInfo = config.get(CATEGORY_DEBUG, "showF3DebugInfo", true, "Shows extra info on the F3 debug screen.").getBoolean(true);
        showSkinTooltipDebugInfo = config.get(CATEGORY_DEBUG, "showSkinTooltipDebugInfo", false, "Shows extra debug info on skin tooltips.").getBoolean(false);
        texturePaintingType = config.getInt("texturePaintingType", CATEGORY_DEBUG, 0, -1, 2, "Texture painting replacing the players texture with a painted version.\nTurning this off may fix issues with the players texture rendering\nincorrectly or showing the steve skin.\n\n-1 = disabled\n0 = auto\n1 = texture_replace (replaces the players texture - LEGACY)\n2 = model_replace_mc (render using a mc model - slower, more compatible - NOT IMPLEMENTED)\n3 = model_replace_aw (render using a aw model - faster, less compatible)\n");
    }

    static {
        modelBakingUpdateRate = new AtomicInteger(40);
        lodDistance = 32.0;
        multipassSkinRendering = true;
        slowModelBaking = true;
        maxLodLevels = 4;
        skinPreEnabled = false;
        skinPreDrawBackground = true;
        skinPreSize = 96.0f;
        skinPreLocHorizontal = 1.0f;
        skinPreLocVertical = 0.5f;
        skinPreLocFollowMouse = false;
    }
}

