/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiColourSelector;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiHSBSlider;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.ModGuiContainer;
import moe.plushie.armourers_workshop.common.inventory.ContainerColourMixer;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiButton;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiColourUpdate;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityColourMixer;
import moe.plushie.armourers_workshop.utils.UtilColour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiColourMixer
extends ModGuiContainer<ContainerColourMixer>
implements GuiHSBSlider.IHSBSliderCallback,
GuiDropDownList.IDropDownListCallback {
    private TileEntityColourMixer tileEntityColourMixer;
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/colour_mixer/colour-mixer.png");
    private Color colour;
    private GuiHSBSlider[] slidersHSB;
    private GuiTextField colourHex;
    private GuiColourSelector colourSelector;
    private GuiDropDownList colourFamilyList;
    private GuiDropDownList paintTypeDropDown;
    private GuiIconButton buttonPaletteAdd;
    private GuiIconButton buttonPaletteRemove;

    public GuiColourMixer(InventoryPlayer invPlayer, TileEntityColourMixer tileEntityColourMixer) {
        super(new ContainerColourMixer(invPlayer, tileEntityColourMixer));
        this.tileEntityColourMixer = tileEntityColourMixer;
        this.field_146999_f = 256;
        this.field_147000_g = 240;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.colour = new Color(this.tileEntityColourMixer.getColour(0));
        float[] hsbvals = Color.RGBtoHSB(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), null);
        this.slidersHSB = new GuiHSBSlider[3];
        this.slidersHSB[0] = new GuiHSBSlider(0, this.field_147003_i + 5, this.field_147009_r + 30, 150, 10, this, GuiHSBSlider.HSBSliderType.HUE, hsbvals[0], hsbvals[0], hsbvals[2]);
        this.slidersHSB[1] = new GuiHSBSlider(1, this.field_147003_i + 5, this.field_147009_r + 55, 150, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, hsbvals[1], hsbvals[0], hsbvals[2]);
        this.slidersHSB[2] = new GuiHSBSlider(2, this.field_147003_i + 5, this.field_147009_r + 80, 150, 10, this, GuiHSBSlider.HSBSliderType.BRIGHTNESS, hsbvals[2], hsbvals[0], hsbvals[2]);
        this.field_146292_n.add(this.slidersHSB[0]);
        this.field_146292_n.add(this.slidersHSB[1]);
        this.field_146292_n.add(this.slidersHSB[2]);
        this.colourHex = new GuiTextField(-1, this.field_146289_q, this.field_147003_i + 5, this.field_147009_r + 105, 50, 10);
        this.colourHex.func_146203_f(7);
        this.updateHexTextbox();
        this.colourSelector = new GuiColourSelector(3, this.field_147003_i + 166, this.field_147009_r + 80, 82, 42, 10, 10, 8, 4, GUI_TEXTURE);
        this.field_146292_n.add(this.colourSelector);
        this.colourFamilyList = new GuiDropDownList(4, this.field_147003_i + 164, this.field_147009_r + 60, 86, "", this);
        for (int i = 0; i < UtilColour.ColourFamily.values().length; ++i) {
            UtilColour.ColourFamily cf = UtilColour.ColourFamily.values()[i];
            this.colourFamilyList.addListItem(cf.getLocalizedName());
        }
        UtilColour.ColourFamily cf = this.tileEntityColourMixer.getColourFamily();
        this.colourFamilyList.setListSelectedIndex(cf.ordinal());
        this.colourSelector.setColourFamily(cf);
        this.field_146292_n.add(this.colourFamilyList);
        this.paintTypeDropDown = new GuiDropDownList(5, this.field_147003_i + 164, this.field_147009_r + 30, 86, "", this);
        this.paintTypeDropDown.setMaxDisplayCount(10);
        this.updatePaintTypeDropDown();
        this.field_146292_n.add(this.paintTypeDropDown);
        this.buttonPaletteAdd = new GuiIconButton((GuiScreen)this, -1, this.field_147003_i + 166, this.field_147009_r + 124, 20, 20, "Add Palette", GUI_TEXTURE).setIconLocation(223, 240, 16, 16);
        this.buttonPaletteRemove = new GuiIconButton((GuiScreen)this, -1, this.field_147003_i + 228, this.field_147009_r + 124, 20, 20, "Remove Palette", GUI_TEXTURE).setIconLocation(189, 240, 16, 16);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.colourFamilyList.drawForeground(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.paintTypeDropDown.drawForeground(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void checkForColourUpdates() {
        if (this.tileEntityColourMixer.getHasItemUpdateAndReset()) {
            this.colour = new Color(this.tileEntityColourMixer.getColour(0));
            this.updateSliders();
            this.updatePaintTypeDropDown();
        }
    }

    private void updatePaintTypeDropDown() {
        int paintCount = 0;
        this.paintTypeDropDown.clearList();
        for (IPaintType paintType : PaintTypeRegistry.getInstance().getRegisteredTypes()) {
            if (paintType == PaintTypeRegistry.PAINT_TYPE_TEXTURE) {
                this.paintTypeDropDown.addListItem(paintType.getLocalizedName(), "", true);
            } else {
                this.paintTypeDropDown.addListItem(paintType.getLocalizedName());
            }
            if (paintType == this.tileEntityColourMixer.getPaintType(0)) {
                this.paintTypeDropDown.setListSelectedIndex(paintCount);
            }
            ++paintCount;
        }
    }

    private void updateSliders() {
        float[] hsbvals = Color.RGBtoHSB(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), null);
        this.slidersHSB[0].setValue(hsbvals[0]);
        this.slidersHSB[1].setValue(hsbvals[1]);
        this.slidersHSB[2].setValue(hsbvals[2]);
    }

    private void updateHexTextbox() {
        if (!this.colourHex.func_146206_l()) {
            this.colourHex.func_146180_a(String.format("#%02x%02x%02x", this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue()));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 3) {
            this.colour = ((GuiColourSelector)button).getSelectedColour();
            this.updateHexTextbox();
            this.updateSliders();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.colourFamilyList.getIsDroppedDown()) {
            this.colourFamilyList.func_146116_c(this.field_146297_k, mouseX, mouseY);
            return;
        }
        if (this.paintTypeDropDown.getIsDroppedDown()) {
            this.paintTypeDropDown.func_146116_c(this.field_146297_k, mouseX, mouseY);
            return;
        }
        super.func_73864_a(mouseX, mouseY, button);
        this.colourHex.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.colourFamilyList.getIsDroppedDown()) {
            this.colourFamilyList.func_146118_a(mouseX, mouseY);
            return;
        }
        if (this.paintTypeDropDown.getIsDroppedDown()) {
            this.paintTypeDropDown.func_146118_a(mouseX, mouseY);
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
        if (state != 0) {
            return;
        }
        this.updateColour();
    }

    private void updateColour() {
        Color colourOld = new Color(this.tileEntityColourMixer.getColour(0));
        IPaintType paintType = PaintTypeRegistry.getInstance().getRegisteredTypes().get(this.paintTypeDropDown.getListSelectedIndex());
        if (this.colour.equals(colourOld) && paintType == this.tileEntityColourMixer.getPaintType(0)) {
            return;
        }
        MessageClientGuiColourUpdate message = new MessageClientGuiColourUpdate(this.colour.getRGB(), false, paintType);
        PacketHandler.networkWrapper.sendToServer((IMessage)message);
    }

    @Override
    protected void func_73869_a(char key, int keyCode) throws IOException {
        if (!this.colourHex.func_146201_a(key, keyCode)) {
            super.func_73869_a(key, keyCode);
        } else {
            Color newColour;
            String text = this.colourHex.func_146179_b();
            if (this.isValidHex(text) && !(newColour = Color.decode(text)).equals(this.colour)) {
                this.colour = newColour;
                this.updateSliders();
                this.updateColour();
            }
        }
    }

    private boolean isValidHex(String colorStr) {
        String hexPatten = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
        Pattern pattern = Pattern.compile(hexPatten);
        Matcher matcher = pattern.matcher(colorStr);
        return matcher.matches();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiHelper.renderLocalizedGuiName(this.field_146289_q, this.field_146999_f, this.tileEntityColourMixer.func_70005_c_());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 48, this.field_147000_g - 96 + 2, 0x404040);
        String labelHue = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.hue", new Object[0]);
        String labelSaturation = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.saturation", new Object[0]);
        String labelBrightness = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.brightness", new Object[0]);
        String labelHex = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.hex", new Object[0]);
        String labelPresets = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.presets", new Object[0]);
        String labelPaintType = GuiHelper.getLocalizedControlName(this.tileEntityColourMixer.func_70005_c_(), "label.paintType", new Object[0]);
        this.field_146289_q.func_78276_b(labelHue + ":", 5, 21, 0x404040);
        this.field_146289_q.func_78276_b(labelSaturation + ":", 5, 46, 0x404040);
        this.field_146289_q.func_78276_b(labelBrightness + ":", 5, 71, 0x404040);
        this.field_146289_q.func_78276_b(labelHex + ":", 5, 94, 0x404040);
        this.field_146289_q.func_78276_b(labelPresets + ":", 165, 51, 0x404040);
        this.field_146289_q.func_78276_b(labelPaintType + ":", 165, 21, 0x404040);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float f, int x, int y) {
        this.checkForColourUpdates();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        float red = (float)this.colour.getRed() / 255.0f;
        float green = (float)this.colour.getGreen() / 255.0f;
        float blue = (float)this.colour.getBlue() / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        this.func_73729_b(this.field_147003_i + 108, this.field_147009_r + 102, 108, 102, 13, 13);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.colourHex.func_146194_f();
    }

    @Override
    public void valueUpdated(GuiHSBSlider source, double sliderValue) {
        float[] hsbvals = new float[]{(float)this.slidersHSB[0].getValue(), (float)this.slidersHSB[1].getValue(), (float)this.slidersHSB[2].getValue()};
        hsbvals[source.getType().ordinal()] = (float)sliderValue;
        this.colour = Color.getHSBColor(hsbvals[0], hsbvals[1], hsbvals[2]);
        this.updateHexTextbox();
        if (source.getType() == GuiHSBSlider.HSBSliderType.HUE) {
            this.slidersHSB[1].setHue((float)source.getValue());
        }
        if (source.getType() == GuiHSBSlider.HSBSliderType.BRIGHTNESS) {
            this.slidersHSB[1].setBrightness((float)source.getValue());
        }
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
        if (dropDownList == this.colourFamilyList) {
            UtilColour.ColourFamily cf = UtilColour.ColourFamily.values()[dropDownList.getListSelectedIndex()];
            this.colourSelector.setColourFamily(cf);
            MessageClientGuiButton message = new MessageClientGuiButton((byte)cf.ordinal());
            PacketHandler.networkWrapper.sendToServer((IMessage)message);
        }
        if (dropDownList == this.paintTypeDropDown) {
            this.updateColour();
        }
    }

    @Override
    public String getName() {
        return this.tileEntityColourMixer.func_70005_c_();
    }
}

