/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui;

import java.util.List;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiHelper {
    private static final ResourceLocation PLAYER_TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/player_inventory.png");

    private GuiHelper() {
    }

    public static void drawPlayerHead(int x, int y, int size, String username) {
        ResourceLocation rl = DefaultPlayerSkin.func_177335_a();
        if (!StringUtils.func_151246_b((String)username)) {
            PlayerTexture playerTexture = GuiHelper.getPlayerTexture(username, TextureType.USER);
            rl = playerTexture.getResourceLocation();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(rl);
        int sourceSize = 8;
        Gui.func_152125_a((int)(x + 1), (int)(y + 1), (float)8.0f, (float)8.0f, (int)sourceSize, (int)sourceSize, (int)size, (int)size, (float)64.0f, (float)64.0f);
        Gui.func_152125_a((int)x, (int)y, (float)40.0f, (float)8.0f, (int)sourceSize, (int)sourceSize, (int)(size + 2), (int)(size + 2), (float)64.0f, (float)64.0f);
    }

    private static PlayerTexture getPlayerTexture(String textureString, TextureType textureType) {
        return ClientProxy.playerTextureDownloader.getPlayerTexture(textureString, textureType);
    }

    public static void renderPlayerInvTexture(int x, int y) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(PLAYER_TEXTURE);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)176, (int)98, (float)256.0f, (float)256.0f);
    }

    public static void renderPlayerInvlabel(int x, int y, FontRenderer fontRenderer) {
        GuiHelper.renderPlayerInvlabel(x, y, fontRenderer, 0x333333);
    }

    public static void renderPlayerInvlabel(int x, int y, FontRenderer fontRenderer, int colour) {
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), x + 8, y + 5, colour);
    }

    public static void renderLocalizedGuiName(FontRenderer fontRenderer, int xSize, String name) {
        GuiHelper.renderLocalizedGuiName(fontRenderer, xSize, name, null, 0x404040);
    }

    public static void renderLocalizedGuiName(FontRenderer fontRenderer, int xSize, String name, int colour) {
        GuiHelper.renderLocalizedGuiName(fontRenderer, xSize, name, null, colour);
    }

    public static void renderLocalizedGuiName(FontRenderer fontRenderer, int xSize, String name, String append) {
        GuiHelper.renderLocalizedGuiName(fontRenderer, xSize, name, append, 0x404040);
    }

    public static void renderLocalizedGuiName(FontRenderer fontRenderer, int xSize, String name, String append, int colour) {
        String unlocalizedName = "inventory." + "armourers_workshop".toLowerCase() + ":" + name + ".name";
        String localizedName = I18n.func_135052_a((String)unlocalizedName, (Object[])new Object[0]);
        String renderText = unlocalizedName;
        if (!unlocalizedName.equals(localizedName)) {
            renderText = localizedName;
        }
        if (append != null) {
            renderText = renderText + " - " + append;
        }
        int xPos = xSize / 2 - fontRenderer.func_78256_a(renderText) / 2;
        fontRenderer.func_78276_b(renderText, xPos, 6, colour);
    }

    public static String getLocalizedControlName(String guiName, String controlName, Object ... args) {
        String unlocalizedName = "inventory." + "armourers_workshop".toLowerCase() + ":" + guiName + "." + controlName;
        String localizedName = I18n.func_135052_a((String)unlocalizedName, (Object[])args);
        localizedName = localizedName.replace("%n", "\n");
        if (!unlocalizedName.equals(localizedName = localizedName.replace("\\n", "\n"))) {
            return localizedName;
        }
        return unlocalizedName;
    }

    public static void drawHoveringText(List textList, int xPos, int yPos, FontRenderer font, int width, int height, float zLevel) {
        if (!textList.isEmpty()) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int textWidth = 0;
            for (String line : textList) {
                int sWidth = font.func_78256_a(line);
                if (sWidth <= textWidth) continue;
                textWidth = sWidth;
            }
            int renderX = xPos + 12;
            int renderY = yPos - 12;
            int textHeight = 8;
            if (textList.size() > 1) {
                textHeight += 2 + (textList.size() - 1) * 10;
            }
            if (renderX + textWidth > width - 2) {
                renderX = width - textWidth - 2;
            }
            if (renderY + textHeight + 6 > height) {
                renderY = height - textHeight - 6;
            }
            if (renderY < 5) {
                renderY = 5;
            }
            zLevel = 300.0f;
            int j1 = -267386864;
            GuiHelper.drawGradientRect(renderX - 3, renderY - 4, renderX + textWidth + 3, renderY - 3, j1, j1, zLevel);
            GuiHelper.drawGradientRect(renderX - 3, renderY + textHeight + 3, renderX + textWidth + 3, renderY + textHeight + 4, j1, j1, zLevel);
            GuiHelper.drawGradientRect(renderX - 3, renderY - 3, renderX + textWidth + 3, renderY + textHeight + 3, j1, j1, zLevel);
            GuiHelper.drawGradientRect(renderX - 4, renderY - 3, renderX - 3, renderY + textHeight + 3, j1, j1, zLevel);
            GuiHelper.drawGradientRect(renderX + textWidth + 3, renderY - 3, renderX + textWidth + 4, renderY + textHeight + 3, j1, j1, zLevel);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            GuiHelper.drawGradientRect(renderX - 3, renderY - 3 + 1, renderX - 3 + 1, renderY + textHeight + 3 - 1, k1, l1, zLevel);
            GuiHelper.drawGradientRect(renderX + textWidth + 2, renderY - 3 + 1, renderX + textWidth + 3, renderY + textHeight + 3 - 1, k1, l1, zLevel);
            GuiHelper.drawGradientRect(renderX - 3, renderY - 3, renderX + textWidth + 3, renderY - 3 + 1, k1, k1, zLevel);
            GuiHelper.drawGradientRect(renderX - 3, renderY + textHeight + 2, renderX + textWidth + 3, renderY + textHeight + 3, l1, l1, zLevel);
            for (int i2 = 0; i2 < textList.size(); ++i2) {
                String line = (String)textList.get(i2);
                font.func_175063_a(line, (float)renderX, (float)renderY, -1);
                if (i2 == 0) {
                    renderY += 2;
                }
                renderY += 10;
            }
            zLevel = 0.0f;
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    private static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }
}

