/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTextFieldCustom
extends GuiButtonExt {
    private int cursorCounter;
    private boolean isFocused;
    private String text = "";
    private float scrollAmount;
    private String emptyLabel = "";
    private int maxStringLength = 100;

    public GuiTextFieldCustom(int xPos, int yPos, int width, int height) {
        super(-1, xPos, yPos, width, height, "");
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        String s;
        if (!this.field_146125_m) {
            return;
        }
        GuiTextFieldCustom.func_73734_a((int)(this.field_146128_h - 1), (int)(this.field_146129_i - 1), (int)(this.field_146128_h + this.field_146120_f + 1), (int)(this.field_146129_i + this.field_146121_g + 1), (int)-6250336);
        GuiTextFieldCustom.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-16777216);
        if (this.getText().trim().isEmpty() && (s = mc.field_71466_p.func_78269_a(this.emptyLabel, this.field_146120_f)).length() > 0 & !this.isFocused()) {
            mc.field_71466_p.func_175063_a(this.emptyLabel, (float)(this.field_146128_h + 4), (float)(this.field_146129_i + 3), -8421505);
        }
        s = this.text;
        if (this.isFocused() && this.cursorCounter / 6 % 2 == 0) {
            s = s + "_";
        }
        ModRenderHelper.enableScissorScaled(this.field_146128_h + 2, this.field_146129_i + 2, this.field_146120_f - 4, this.field_146121_g - 4);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-this.scrollAmount), (float)0.0f);
        mc.field_71466_p.func_78279_b(s, this.field_146128_h + 5, this.field_146129_i + 4, this.field_146120_f - 8, 0x444444);
        mc.field_71466_p.func_78279_b(s, this.field_146128_h + 4, this.field_146129_i + 3, this.field_146120_f - 8, 0xFFFFFF);
        GlStateManager.func_179121_F();
        ModRenderHelper.disableScissor();
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean keyTyped(char c, int keycode) {
        if (!this.field_146125_m | !this.isFocused) {
            return false;
        }
        switch (keycode) {
            case 14: {
                this.removeText(1);
                break;
            }
            case 28: {
                this.text = this.text + "\n";
                break;
            }
            case 30: {
                if (GuiScreen.func_146271_m()) break;
            }
            case 45: {
                if (GuiScreen.func_146271_m()) break;
            }
            case 46: {
                if (GuiScreen.func_146271_m()) break;
            }
            case 47: {
                if (GuiScreen.func_146271_m()) {
                    this.addText(GuiScreen.func_146277_j());
                    break;
                }
            }
            default: {
                if (GuiScreen.func_146271_m()) break;
                this.addText(Character.toString(c));
            }
        }
        return true;
    }

    private void removeText(int count) {
        if (!this.text.isEmpty()) {
            if (count > this.text.length()) {
                this.clearText();
            } else {
                this.text = this.text.substring(0, this.text.length() - count);
            }
        }
    }

    private void addText(String s) {
        s = s.replace("\n", "%n");
        s = ChatAllowedCharacters.func_71565_a((String)s);
        if (!(s = s.replace("%n", "\n")).isEmpty()) {
            this.text = this.text + s;
        }
        if (this.text.length() > this.maxStringLength) {
            this.text = this.text.substring(0, this.maxStringLength);
        }
    }

    private void clearText() {
        this.text = "";
    }

    private String trimStringNewline(String text) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public int getTextLineCount(FontRenderer fontRenderer) {
        return fontRenderer.func_78271_c(this.trimStringNewline(this.text + " "), this.field_146120_f - 4).size();
    }

    public int getTextHeight(FontRenderer fontRenderer) {
        return this.getTextLineCount(fontRenderer) * fontRenderer.field_78288_b;
    }

    public int getScrollHeight(FontRenderer fontRenderer) {
        return Math.max(0, this.getTextHeight(fontRenderer) - this.field_146121_g - 4 + fontRenderer.field_78288_b);
    }

    public float getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(float amount) {
        this.scrollAmount = amount;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked;
        this.isFocused = clicked = mouseX >= this.field_146128_h && mouseX < this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g;
        return clicked;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text.length() > this.maxStringLength ? text.substring(0, this.maxStringLength) : text;
    }

    public void setEmptyLabel(String emptyLabel) {
        this.emptyLabel = emptyLabel;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }
}

