/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.model.bake;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.model.bake.SkinBaker;
import moe.plushie.armourers_workshop.client.skin.ClientSkinPartData;
import moe.plushie.armourers_workshop.client.skin.SkinModelTexture;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public final class ModelBakery {
    public static final ModelBakery INSTANCE = new ModelBakery();
    private final Executor skinBakeExecutor;
    private final Executor skinDownloadExecutor;
    private final CompletionService<BakedSkin> skinCompletion;
    private final AtomicInteger bakingQueue = new AtomicInteger(0);
    private final AtomicIntegerArray bakeTimes = new AtomicIntegerArray(1000);
    private final AtomicInteger bakeTimesIndex = new AtomicInteger(0);

    public ModelBakery() {
        this.skinBakeExecutor = Executors.newFixedThreadPool(ConfigHandlerClient.modelBakingThreadCount);
        this.skinDownloadExecutor = Executors.newFixedThreadPool(2);
        this.skinCompletion = new ExecutorCompletionService<BakedSkin>(this.skinBakeExecutor);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT & event.type == TickEvent.Type.CLIENT & event.phase == TickEvent.Phase.END) {
            this.checkBakery();
        }
    }

    public int getAverageBakeTime() {
        int totalItems = 0;
        int totalTime = 0;
        for (int i = 0; i < this.bakeTimes.length(); ++i) {
            int time = this.bakeTimes.get(i);
            if (time == 0) continue;
            ++totalItems;
            totalTime += time;
        }
        return (int)((double)totalTime / (double)totalItems);
    }

    public void receivedUnbakedModel(Skin skin, SkinIdentifier skinIdentifierRequested, SkinIdentifier skinIdentifierUpdated, IBakedSkinReceiver skinReceiver) {
        this.bakingQueue.incrementAndGet();
        this.skinCompletion.submit(new BakingOven(skin, skinIdentifierRequested, skinIdentifierUpdated, skinReceiver));
    }

    private void checkBakery() {
        Future<BakedSkin> futureSkin = this.skinCompletion.poll();
        while (futureSkin != null) {
            try {
                BakedSkin bakedSkin = futureSkin.get();
                if (bakedSkin != null) {
                    this.bakingQueue.decrementAndGet();
                    if (bakedSkin.skin == null) {
                        ModLogger.log(Level.ERROR, "A skin failed to bake.");
                    }
                    bakedSkin.getSkinReceiver().onBakedSkin(bakedSkin);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            futureSkin = this.skinCompletion.poll();
        }
    }

    public int getBakingQueueSize() {
        return this.bakingQueue.get();
    }

    public void handleModelDownload(Thread downloadThread) {
        downloadThread.setPriority(1);
        this.skinDownloadExecutor.execute(downloadThread);
    }

    public static class BakedSkin {
        private final Skin skin;
        private final SkinIdentifier skinIdentifierRequested;
        private final SkinIdentifier skinIdentifierUpdated;
        private final IBakedSkinReceiver skinReceiver;

        public BakedSkin(Skin skin, SkinIdentifier skinIdentifierRequested, SkinIdentifier skinIdentifierUpdated, IBakedSkinReceiver skinReceiver) {
            this.skin = skin;
            this.skinIdentifierRequested = skinIdentifierRequested;
            this.skinIdentifierUpdated = skinIdentifierUpdated;
            this.skinReceiver = skinReceiver;
        }

        public Skin getSkin() {
            return this.skin;
        }

        public SkinIdentifier getSkinIdentifierRequested() {
            return this.skinIdentifierRequested;
        }

        public SkinIdentifier getSkinIdentifierUpdated() {
            return this.skinIdentifierUpdated;
        }

        public IBakedSkinReceiver getSkinReceiver() {
            return this.skinReceiver;
        }
    }

    private class BakingOven
    implements Callable<BakedSkin> {
        private final Skin skin;
        private final SkinIdentifier skinIdentifierRequested;
        private final SkinIdentifier skinIdentifierUpdated;
        private final IBakedSkinReceiver skinReceiver;

        public BakingOven(Skin skin, SkinIdentifier skinIdentifierRequested, SkinIdentifier skinIdentifierUpdated, IBakedSkinReceiver skinReceiver) {
            this.skin = skin;
            this.skinIdentifierRequested = skinIdentifierRequested;
            this.skinIdentifierUpdated = skinIdentifierUpdated;
            this.skinReceiver = skinReceiver;
        }

        @Override
        public BakedSkin call() throws Exception {
            int i;
            Thread.currentThread().setPriority(1);
            if (this.skin == null) {
                return new BakedSkin(this.skin, this.skinIdentifierRequested, this.skinIdentifierUpdated, this.skinReceiver);
            }
            long startTime = System.currentTimeMillis();
            this.skin.lightHash();
            int extraDyes = PaintTypeRegistry.getInstance().getExtraChannels();
            int[][] dyeColour = new int[3][extraDyes];
            int[] dyeUseCount = new int[extraDyes];
            if (ClientProxy.getTexturePaintType() == ClientProxy.TexturePaintType.MODEL_REPLACE_AW) {
                this.skin.addPaintDataParts();
            }
            for (int i2 = 0; i2 < this.skin.getParts().size(); ++i2) {
                SkinPart partData = this.skin.getParts().get(i2);
                partData.setClientSkinPartData(new ClientSkinPartData());
                int[][][] cubeArray = SkinBaker.cullFacesOnEquipmentPart(partData, ConfigHandlerClient.modelBakingUpdateRate.get());
                SkinBaker.buildPartDisplayListArray(partData, dyeColour, dyeUseCount, cubeArray, ConfigHandlerClient.modelBakingUpdateRate.get());
                partData.clearCubeData();
            }
            if (this.skin.hasPaintData()) {
                this.skin.skinModelTexture = new SkinModelTexture();
                for (int ix = 0; ix < 64; ++ix) {
                    for (int iy = 0; iy < 32; ++iy) {
                        int paintColour = this.skin.getPaintData()[ix + iy * 64];
                        IPaintType paintType = PaintTypeRegistry.getInstance().getPaintTypeFromColour(paintColour);
                        if (!paintType.hasAverageColourChannel()) continue;
                        int index = paintType.getChannelIndex();
                        byte r = (byte)(paintColour >>> 16 & 0xFF);
                        byte g = (byte)(paintColour >>> 8 & 0xFF);
                        byte b = (byte)(paintColour & 0xFF);
                        int n = index;
                        dyeUseCount[n] = dyeUseCount[n] + 1;
                        int[] nArray = dyeColour[0];
                        int n2 = index;
                        nArray[n2] = nArray[n2] + (r & 0xFF);
                        int[] nArray2 = dyeColour[1];
                        int n3 = index;
                        nArray2[n3] = nArray2[n3] + (g & 0xFF);
                        int[] nArray3 = dyeColour[2];
                        int n4 = index;
                        nArray3[n4] = nArray3[n4] + (b & 0xFF);
                    }
                }
            }
            int[] averageR = new int[extraDyes];
            int[] averageG = new int[extraDyes];
            int[] averageB = new int[extraDyes];
            for (i = 0; i < extraDyes; ++i) {
                averageR[i] = (int)((double)dyeColour[0][i] / (double)dyeUseCount[i]);
                averageG[i] = (int)((double)dyeColour[1][i] / (double)dyeUseCount[i]);
                averageB[i] = (int)((double)dyeColour[2][i] / (double)dyeUseCount[i]);
            }
            for (i = 0; i < this.skin.getParts().size(); ++i) {
                SkinPart partData = this.skin.getParts().get(i);
                partData.getClientSkinPartData().setAverageDyeValues(averageR, averageG, averageB);
            }
            this.skin.setAverageDyeValues(averageR, averageG, averageB);
            if (this.skin.hasPaintData()) {
                this.skin.skinModelTexture.createTextureForColours(this.skin, null);
            }
            long totalTime = System.currentTimeMillis() - startTime;
            int index = ModelBakery.this.bakeTimesIndex.getAndIncrement();
            if (index > ModelBakery.this.bakeTimes.length() - 1) {
                index = 0;
                ModelBakery.this.bakeTimesIndex.set(0);
            }
            ModelBakery.this.bakeTimes.set(index, (int)totalTime);
            return new BakedSkin(this.skin, this.skinIdentifierRequested, this.skinIdentifierUpdated, this.skinReceiver);
        }
    }

    public static interface IBakedSkinReceiver {
        public void onBakedSkin(BakedSkin var1);
    }
}

