/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.model.skin;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.client.model.skin.ModelTypeHelper;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.client.render.SkinRenderData;
import moe.plushie.armourers_workshop.client.skin.SkinModelTexture;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinPaintCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelSkinChest
extends ModelTypeHelper {
    @Override
    public void render(Entity entity, Skin skin, boolean showSkinPaint, ISkinDye skinDye, IExtraColours extraColours, boolean itemRender, double distance, boolean doLodLoading) {
        this.render(entity, skin, new SkinRenderData(SCALE, skinDye, extraColours, distance, doLodLoading, showSkinPaint, itemRender, null));
    }

    @Override
    public void render(Entity entity, Skin skin, SkinRenderData renderData) {
        if (skin == null) {
            return;
        }
        ArrayList<SkinPart> parts = skin.getParts();
        if (parts.size() > -1) {
            // empty if block
        }
        if (entity != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.field_78117_n = player.func_70093_af();
            this.field_78093_q = player.func_184218_aH();
        }
        GlStateManager.func_179123_a();
        RenderHelper.func_74520_c();
        if (skin.hasPaintData() & renderData.isShowSkinPaint() & ClientProxy.getTexturePaintType() == ClientProxy.TexturePaintType.TEXTURE_REPLACE) {
            SkinModelTexture st = ClientSkinPaintCache.INSTANCE.getTextureForSkin(skin, renderData.getSkinDye(), renderData.getExtraColours());
            st.bindTexture();
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3008);
            this.field_78115_e.func_78785_a(SCALE);
            this.field_178724_i.func_78785_a(SCALE);
            this.field_178723_h.func_78785_a(SCALE);
            GL11.glPopAttrib();
        }
        boolean override = SkinProperties.PROP_MODEL_OVERRIDE_CHEST.getValue(skin.getProperties());
        for (int i = 0; i < parts.size(); ++i) {
            SkinPart part = parts.get(i);
            GL11.glPushMatrix();
            if (this.field_78091_s) {
                float f6 = 2.0f;
                GL11.glScalef((float)(1.0f / f6), (float)(1.0f / f6), (float)(1.0f / f6));
                GL11.glTranslatef((float)0.0f, (float)(24.0f * SCALE), (float)0.0f);
            }
            if (this.field_78117_n) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            if (part.getPartType().getPartName().equals("base")) {
                this.renderChest(new SkinPartRenderData(part, renderData));
            } else if (part.getPartType().getPartName().equals("leftArm")) {
                this.renderLeftArm(new SkinPartRenderData(part, renderData), override);
            } else if (part.getPartType().getPartName().equals("rightArm")) {
                this.renderRightArm(new SkinPartRenderData(part, renderData), override);
            }
            GL11.glPopMatrix();
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderChest(SkinPartRenderData skinPartRenderData) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.field_78117_n) {
            GL11.glRotated((double)Math.toDegrees(this.field_78115_e.field_78795_f), (double)1.0, (double)0.0, (double)0.0);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderPart(skinPartRenderData);
        GL11.glPopMatrix();
    }

    private void renderLeftArm(SkinPartRenderData partRenderData, boolean override) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(5.0f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(2.0f * partRenderData.getScale()), (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178724_i.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178724_i.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178724_i.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.slim & !override) {
            GL11.glTranslatef((float)(-0.25f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(0.5f * partRenderData.getScale()), (float)0.0f);
            GL11.glScalef((float)0.75f, (float)1.0f, (float)1.0f);
        }
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderRightArm(SkinPartRenderData partRenderData, boolean override) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-5.0f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(2.0f * partRenderData.getScale()), (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178723_h.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178723_h.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178723_h.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.slim & !override) {
            GL11.glTranslatef((float)(0.25f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(0.5f * partRenderData.getScale()), (float)0.0f);
            GL11.glScalef((float)0.75f, (float)1.0f, (float)1.0f);
        }
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }
}

