/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.model.ModelHelper;
import moe.plushie.armourers_workshop.client.render.EntityTextureInfo;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinModelRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinRenderData;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockMannequin;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.Contributors;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinDye;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderEntityMannequin
extends Render<EntityMannequin> {
    private static LoadingCache<EntityMannequin, EntityTextureInfo> textureCache;
    private boolean isHalloweenSeason;
    private boolean isHalloween;
    private final ModelPlayer modelPlayerSmall = new ModelPlayer(0.0f, true);
    private final ModelPlayer modelPlayerNormal = new ModelPlayer(0.0f, false);

    public RenderEntityMannequin(RenderManager renderManager) {
        super(renderManager);
        if (textureCache == null) {
            CacheBuilder builder = CacheBuilder.newBuilder();
            builder.expireAfterAccess(1L, TimeUnit.MINUTES);
            builder.maximumSize(200L);
            builder.removalListener((RemovalListener)new RemovalListener<EntityMannequin, EntityTextureInfo>(){

                public void onRemoval(final RemovalNotification<EntityMannequin, EntityTextureInfo> notification) {
                    Minecraft.func_71410_x().func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            ((EntityTextureInfo)notification.getValue()).deleteTexture();
                        }
                    });
                }
            });
            textureCache = builder.build((CacheLoader)new CacheLoader<EntityMannequin, EntityTextureInfo>(){

                public EntityTextureInfo load(EntityMannequin key) throws Exception {
                    return new EntityTextureInfo();
                }
            });
        }
    }

    public void doRender(EntityMannequin entity, double x, double y, double z, float entityYaw, float partialTicks) {
        Contributors.Contributor contributor;
        EntitySkinCapability skinCap = (EntitySkinCapability)EntitySkinCapability.get(entity);
        if (skinCap == null) {
            return;
        }
        this.isHalloweenSeason = ModHolidays.HALLOWEEN_SEASON.isHolidayActive();
        this.isHalloween = ModHolidays.HALLOWEEN.isHolidayActive();
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        float scale = 0.0625f;
        float size = entity.getScale();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179152_a((float)(15.0f * scale), (float)(-15.0f * scale), (float)(-15.0f * scale));
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179109_b((float)0.0f, (float)(-24.0f * scale), (float)0.0f);
        GlStateManager.func_179114_b((float)entity.getRotation(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179133_A();
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
        GlStateManager.func_179108_z();
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
        PlayerTexture playerTexture = ClientProxy.playerTextureDownloader.getPlayerTexture(entity.getTextureData());
        ModelPlayer targetModel = this.modelPlayerNormal;
        if (playerTexture.isSlimModel()) {
            targetModel = this.modelPlayerSmall;
        }
        targetModel.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, scale, (Entity)entity);
        BipedRotations bipedRotations = entity.getBipedRotations();
        bipedRotations.applyRotationsToBiped(targetModel);
        float[] bodyRots = bipedRotations.getPartRotations(BipedRotations.BipedPart.CHEST);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(bodyRots[0])), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(bodyRots[1])), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(bodyRots[2])), (float)0.0f, (float)0.0f, (float)1.0f);
        targetModel.field_78115_e.field_78795_f = 0.0f;
        targetModel.field_78115_e.field_78796_g = 0.0f;
        targetModel.field_78115_e.field_78808_h = 0.0f;
        targetModel.field_178730_v.field_78795_f = 0.0f;
        targetModel.field_178730_v.field_78796_g = 0.0f;
        targetModel.field_178730_v.field_78808_h = 0.0f;
        skinCap.hideHead = false;
        skinCap.hideChest = false;
        skinCap.hideArmLeft = false;
        skinCap.hideArmRight = false;
        skinCap.hideLegLeft = false;
        skinCap.hideLegRight = false;
        skinCap.hideHeadOverlay = false;
        skinCap.hideChestOverlay = false;
        skinCap.hideArmLeftOverlay = false;
        skinCap.hideArmRightOverlay = false;
        skinCap.hideLegLeftOverlay = false;
        skinCap.hideLegRightOverlay = false;
        targetModel.field_78116_c.field_78807_k = false;
        targetModel.field_178720_f.field_78807_k = false;
        targetModel.field_78115_e.field_78807_k = false;
        targetModel.field_178730_v.field_78807_k = false;
        targetModel.field_178724_i.field_78807_k = false;
        targetModel.field_178734_a.field_78807_k = false;
        targetModel.field_178723_h.field_78807_k = false;
        targetModel.field_178732_b.field_78807_k = false;
        targetModel.field_178722_k.field_78807_k = false;
        targetModel.field_178733_c.field_78807_k = false;
        targetModel.field_178721_j.field_78807_k = false;
        targetModel.field_178731_d.field_78807_k = false;
        ISkinType[] skinTypes = skinCap.getValidSkinTypes();
        SkinModelRenderHelper modelRenderer = SkinModelRenderHelper.INSTANCE;
        IExtraColours extraColours = ExtraColours.EMPTY_COLOUR;
        IWardrobeCap wardrobe = WardrobeCap.get(entity);
        if (wardrobe != null) {
            extraColours = wardrobe.getExtraColours();
        }
        for (int i = 0; i < skinTypes.length; ++i) {
            ISkinType skinType = skinTypes[i];
            if (!(skinType.getVanillaArmourSlotId() != -1 | skinType == SkinTypeRegistry.skinWings | skinType == SkinTypeRegistry.skinOutfit)) continue;
            for (int skinIndex = 0; skinIndex < skinCap.getSlotCountForSkinType(skinType); ++skinIndex) {
                ISkinDescriptor skinDescriptor = skinCap.getSkinDescriptor(skinType, skinIndex);
                if (skinDescriptor == null) continue;
                this.renderSkin(entity, skinDescriptor, skinCap, wardrobe, extraColours, 0.0, true, targetModel);
            }
        }
        if (skinCap.hideHead) {
            targetModel.field_78116_c.field_78807_k = true;
        }
        if (skinCap.hideHead | skinCap.hideHeadOverlay) {
            targetModel.field_178720_f.field_78807_k = true;
        }
        if (skinCap.hideChest) {
            targetModel.field_78115_e.field_78807_k = true;
        }
        if (skinCap.hideChest | skinCap.hideChestOverlay) {
            targetModel.field_178730_v.field_78807_k = true;
        }
        if (skinCap.hideArmLeft) {
            targetModel.field_178724_i.field_78807_k = true;
        }
        if (skinCap.hideArmLeft | skinCap.hideArmLeftOverlay) {
            targetModel.field_178734_a.field_78807_k = true;
        }
        if (skinCap.hideArmRight) {
            targetModel.field_178723_h.field_78807_k = true;
        }
        if (skinCap.hideArmRight | skinCap.hideArmRightOverlay) {
            targetModel.field_178732_b.field_78807_k = true;
        }
        if (skinCap.hideLegLeft) {
            targetModel.field_178722_k.field_78807_k = true;
        }
        if (skinCap.hideLegLeft | skinCap.hideLegLeftOverlay) {
            targetModel.field_178733_c.field_78807_k = true;
        }
        if (skinCap.hideLegRight) {
            targetModel.field_178721_j.field_78807_k = true;
        }
        if (skinCap.hideLegRight | skinCap.hideLegRightOverlay) {
            targetModel.field_178731_d.field_78807_k = true;
        }
        EntityTextureInfo textureInfo = (EntityTextureInfo)textureCache.getUnchecked((Object)entity);
        textureCache.cleanUp();
        this.buildTexture(playerTexture.getResourceLocation(), textureInfo, skinCap, wardrobe);
        this.func_110776_a(textureInfo.preRender());
        if (entity.isVisible()) {
            ModRenderHelper.enableAlphaBlend();
            if (bipedRotations.isChild()) {
                ModelHelper.enableChildModelScale(true, scale);
            }
            targetModel.field_78116_c.func_78785_a(scale);
            targetModel.field_178720_f.func_78785_a(scale);
            if (bipedRotations.isChild()) {
                ModelHelper.disableChildModelScale();
            }
            if (bipedRotations.isChild()) {
                ModelHelper.enableChildModelScale(false, scale);
            }
            targetModel.field_78115_e.func_78785_a(scale);
            targetModel.field_178724_i.func_78785_a(scale);
            targetModel.field_178723_h.func_78785_a(scale);
            targetModel.field_178722_k.func_78785_a(scale);
            targetModel.field_178721_j.func_78785_a(scale);
            if (bipedRotations.isChild()) {
                ModelHelper.disableChildModelScale();
            }
            ModRenderHelper.disableAlphaBlend();
        }
        for (int i = 0; i < 2; ++i) {
            boolean leftArm = i == 0;
            SkinDescriptor descriptor = null;
            descriptor = leftArm ? SkinNBTHelper.getSkinDescriptorFromStack(entity.getHandLeft()) : SkinNBTHelper.getSkinDescriptorFromStack(entity.getHandRight());
            if (descriptor == null) continue;
            GlStateManager.func_179094_E();
            if (bipedRotations.isChild()) {
                ModelHelper.enableChildModelScale(false, scale);
            }
            float[] armRots = bipedRotations.getPartRotations(BipedRotations.BipedPart.RIGHT_ARM);
            if (leftArm) {
                armRots = bipedRotations.getPartRotations(BipedRotations.BipedPart.LEFT_ARM);
            }
            if (!leftArm) {
                GlStateManager.func_179109_b((float)(scale * -5.0f), (float)(scale * 2.0f), (float)(scale * 0.0f));
            } else {
                GlStateManager.func_179109_b((float)(scale * 5.0f), (float)(scale * 2.0f), (float)(scale * 0.0f));
            }
            if (playerTexture.isSlimModel()) {
                GlStateManager.func_179109_b((float)0.0f, (float)(scale * 0.5f), (float)0.0f);
            }
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(armRots[2])), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(armRots[1])), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(armRots[0])), (float)1.0f, (float)0.0f, (float)0.0f);
            if (!leftArm) {
                GlStateManager.func_179109_b((float)(scale * -1.0f), (float)(scale * 8.0f), (float)(scale * 0.0f));
                if (playerTexture.isSlimModel()) {
                    GlStateManager.func_179109_b((float)(scale * 0.5f), (float)0.0f, (float)0.0f);
                }
            } else {
                GlStateManager.func_179109_b((float)(scale * 1.0f), (float)(scale * 8.0f), (float)(scale * 0.0f));
                if (playerTexture.isSlimModel()) {
                    GlStateManager.func_179109_b((float)(scale * -0.5f), (float)0.0f, (float)0.0f);
                }
            }
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (leftArm) {
                GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
            }
            if (playerTexture.isSlimModel()) {
                GL11.glScaled((double)0.75, (double)1.0, (double)1.0);
            }
            this.renderSkin(entity, descriptor, skinCap, wardrobe, extraColours, 0.0, true, null);
            if (leftArm) {
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            }
            if (bipedRotations.isChild()) {
                ModelHelper.disableChildModelScale();
            }
            GlStateManager.func_179121_F();
        }
        if (entity.isRenderExtras() & entity.isVisible() & entity.getTextureData().getTextureType() == TextureType.USER && (contributor = Contributors.INSTANCE.getContributor(entity.getTextureData().getProfile())) != null) {
            int offset = entity.func_145782_y() * 31;
            RenderBlockMannequin.renderMagicCircle(Minecraft.func_71410_x(), contributor.r, contributor.g, contributor.b, partialTicks, offset, targetModel.field_78091_s);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private void renderSkin(EntityMannequin entity, ISkinDescriptor skinDescriptor, EntitySkinCapability skinCap, IWardrobeCap wardrobe, IExtraColours extraColours, double distance, boolean doLodLoading, ModelPlayer targetModel) {
        SkinModelRenderHelper modelRenderer = SkinModelRenderHelper.INSTANCE;
        Skin skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor);
        if (skin != null) {
            if (SkinProperties.PROP_MODEL_OVERRIDE_HEAD.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideHead = true;
            }
            if (SkinProperties.PROP_MODEL_OVERRIDE_CHEST.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideChest = true;
            }
            if (SkinProperties.PROP_MODEL_OVERRIDE_ARM_LEFT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideArmLeft = true;
            }
            if (SkinProperties.PROP_MODEL_OVERRIDE_ARM_RIGHT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideArmRight = true;
            }
            if (SkinProperties.PROP_MODEL_OVERRIDE_LEG_LEFT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideLegLeft = true;
            }
            if (SkinProperties.PROP_MODEL_OVERRIDE_LEG_RIGHT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideLegRight = true;
            }
            if (SkinProperties.PROP_MODEL_HIDE_OVERLAY_HEAD.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideHeadOverlay = true;
            }
            if (SkinProperties.PROP_MODEL_HIDE_OVERLAY_CHEST.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideChestOverlay = true;
            }
            if (SkinProperties.PROP_MODEL_HIDE_OVERLAY_ARM_LEFT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideArmLeftOverlay = true;
            }
            if (SkinProperties.PROP_MODEL_HIDE_OVERLAY_ARM_RIGHT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideArmRightOverlay = true;
            }
            if (SkinProperties.PROP_MODEL_HIDE_OVERLAY_LEG_LEFT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideLegLeftOverlay = true;
            }
            if (SkinProperties.PROP_MODEL_HIDE_OVERLAY_LEG_RIGHT.getValue(skin.getProperties()).booleanValue()) {
                skinCap.hideLegRightOverlay = true;
            }
            if (skin.hasPaintData() & ClientProxy.getTexturePaintType() == ClientProxy.TexturePaintType.MODEL_REPLACE_AW) {
                if (skin.getSkinType() == SkinTypeRegistry.skinHead) {
                    skinCap.hideHead = true;
                }
                if (skin.getSkinType() == SkinTypeRegistry.skinChest) {
                    skinCap.hideChest = true;
                    skinCap.hideArmLeft = true;
                    skinCap.hideArmRight = true;
                }
                if (skin.getSkinType() == SkinTypeRegistry.skinLegs) {
                    skinCap.hideLegLeft = true;
                    skinCap.hideLegRight = true;
                }
                if (skin.getSkinType() == SkinTypeRegistry.skinFeet) {
                    skinCap.hideLegLeft = true;
                    skinCap.hideLegRight = true;
                }
            }
            SkinDye dye = new SkinDye(wardrobe.getDye());
            for (int i = 0; i < 8; ++i) {
                if (!skinDescriptor.getSkinDye().haveDyeInSlot(i)) continue;
                dye.addDye(i, skinDescriptor.getSkinDye().getDyeColour(i));
            }
            GlStateManager.func_179094_E();
            SkinRenderData renderData = new SkinRenderData(0.0625f, (ISkinDye)dye, extraColours, distance, doLodLoading, false, false, this.getEntityTexture(entity));
            modelRenderer.renderEquipmentPart(skin, renderData, entity, (ModelBiped)targetModel);
            GlStateManager.func_179121_F();
        }
    }

    private void buildTexture(ResourceLocation texture, EntityTextureInfo textureInfo, IEntitySkinCapability skinCapability, IWardrobeCap wardrobeCap) {
        textureInfo.updateTexture(texture);
        textureInfo.updateExtraColours(wardrobeCap.getExtraColours());
        ISkinType[] skinTypes = new ISkinType[]{SkinTypeRegistry.skinHead, SkinTypeRegistry.skinChest, SkinTypeRegistry.skinLegs, SkinTypeRegistry.skinFeet, SkinTypeRegistry.skinOutfit};
        Skin[] skins = new Skin[skinTypes.length * 10];
        ISkinDye[] dyes = new ISkinDye[skinTypes.length * 10];
        for (int skinIndex = 0; skinIndex < 10; ++skinIndex) {
            Skin[] skin = new Skin[skinTypes.length];
            ISkinDye[] dye = new ISkinDye[skinTypes.length];
            for (int i = 0; i < skinTypes.length; ++i) {
                ISkinDescriptor descriptor = skinCapability.getSkinDescriptor(skinTypes[i], skinIndex);
                if (descriptor == null) continue;
                skin[i] = ClientSkinCache.INSTANCE.getSkin(descriptor);
                dye[i] = descriptor.getSkinDye();
            }
            skins[0 + skinIndex * skinTypes.length] = skin[0];
            skins[1 + skinIndex * skinTypes.length] = skin[1];
            skins[2 + skinIndex * skinTypes.length] = skin[2];
            skins[3 + skinIndex * skinTypes.length] = skin[3];
            skins[4 + skinIndex * skinTypes.length] = skin[4];
            dyes[0 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[0]);
            dyes[1 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[1]);
            dyes[2 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[2]);
            dyes[3 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[3]);
            dyes[4 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[4]);
        }
        textureInfo.updateSkins(skins);
        textureInfo.updateDyes(dyes);
    }

    private ISkinDye mixDye(ISkinDye wardrobeDye, ISkinDye itemDye) {
        SkinDye dye = new SkinDye(wardrobeDye);
        if (itemDye != null) {
            for (int i = 0; i < 8; ++i) {
                if (!itemDye.haveDyeInSlot(i)) continue;
                dye.addDye(i, dye.getDyeColour(i));
            }
        }
        return dye;
    }

    protected ResourceLocation getEntityTexture(EntityMannequin entity) {
        PlayerTexture playerTexture = ClientProxy.playerTextureDownloader.getPlayerTexture(entity.getTextureData());
        return playerTexture.getResourceLocation();
    }
}

