/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.skin.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinIdentifier;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.model.bake.ModelBakery;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientRequestSkinData;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ClientSkinCache
implements RemovalListener<ISkinIdentifier, Skin>,
ModelBakery.IBakedSkinReceiver {
    public static ClientSkinCache INSTANCE;
    public static Skin errorSkin;
    private final Cache<ISkinIdentifier, Skin> skinCache;
    private final ArrayList<Skin> cleanupList;
    private final Cache<ISkinIdentifier, Boolean> requestedSkins;
    private final Executor skinRequestExecutor;

    public static void init() {
        INSTANCE = new ClientSkinCache();
    }

    protected ClientSkinCache() {
        CacheBuilder builder = null;
        builder = CacheBuilder.newBuilder();
        builder.removalListener((RemovalListener)this);
        builder.recordStats();
        if (ConfigHandlerClient.skinCacheExpireTime > 0) {
            builder.expireAfterAccess((long)ConfigHandlerClient.skinCacheExpireTime, TimeUnit.SECONDS);
        }
        if (ConfigHandlerClient.skinCacheMaxSize > 0) {
            builder.maximumSize((long)ConfigHandlerClient.skinCacheMaxSize);
        }
        this.skinCache = builder.build();
        this.cleanupList = new ArrayList();
        builder = CacheBuilder.newBuilder();
        builder.expireAfterWrite(20L, TimeUnit.SECONDS);
        this.requestedSkins = builder.build();
        this.skinRequestExecutor = Executors.newFixedThreadPool(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Skin getSkin(ISkinDescriptor descriptor) {
        return this.getSkin(descriptor.getIdentifier(), true);
    }

    public Skin getSkin(ISkinDescriptor descriptor, boolean requestSkin) {
        return this.getSkin(descriptor.getIdentifier(), requestSkin);
    }

    public Skin getSkin(ISkinIdentifier identifier) {
        return this.getSkin(identifier, true);
    }

    public Skin getSkin(ISkinIdentifier identifier, boolean requestSkin) {
        Skin skin = (Skin)this.skinCache.getIfPresent((Object)identifier);
        if (this.skinCache.asMap().containsKey(identifier)) {
            return (Skin)this.skinCache.getIfPresent((Object)identifier);
        }
        if (requestSkin) {
            this.requestSkinFromServer(identifier);
        }
        return null;
    }

    public void requestSkinFromServer(ISkinDescriptor skinPointer) {
        this.requestSkinFromServer(skinPointer.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSkinFromServer(ISkinIdentifier identifier) {
        if (!identifier.isValid()) {
            return;
        }
        Cache<ISkinIdentifier, Boolean> cache = this.requestedSkins;
        synchronized (cache) {
            if (!this.requestedSkins.asMap().containsKey(identifier) & this.requestedSkins.asMap().size() < ConfigHandlerClient.maxSkinRequests) {
                this.skinRequestExecutor.execute(new SkinRequestThread(identifier));
                this.requestedSkins.put((Object)identifier, (Object)true);
            }
        }
    }

    public boolean isSkinInCache(ISkinDescriptor skinPointer) {
        return this.isSkinInCache(skinPointer.getIdentifier());
    }

    public boolean isSkinInCache(ISkinIdentifier identifier) {
        return this.skinCache.asMap().containsKey(identifier);
    }

    public void markSkinAsDirty(ISkinIdentifier identifier) {
        this.skinCache.invalidate((Object)identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBakedSkin(ModelBakery.BakedSkin bakedSkin) {
        if (bakedSkin.getSkin() == null) {
            bakedSkin = new ModelBakery.BakedSkin(errorSkin, bakedSkin.getSkinIdentifierRequested(), bakedSkin.getSkinIdentifierUpdated(), null);
        }
        SkinIdentifier identifierRequested = bakedSkin.getSkinIdentifierRequested();
        Cache<ISkinIdentifier, Boolean> cache = this.requestedSkins;
        synchronized (cache) {
            if (this.skinCache.asMap().containsKey(identifierRequested)) {
                Skin oldSkin = (Skin)this.skinCache.getIfPresent((Object)identifierRequested);
                this.skinCache.invalidate((Object)identifierRequested);
                oldSkin.cleanUpDisplayLists();
                ModLogger.log("removing skin");
            }
            if (this.requestedSkins.asMap().containsKey(identifierRequested)) {
                this.skinCache.put((Object)identifierRequested, (Object)bakedSkin.getSkin());
                this.requestedSkins.invalidate((Object)identifierRequested);
            } else {
                this.skinCache.put((Object)bakedSkin.getSkinIdentifierUpdated(), (Object)bakedSkin.getSkin());
                ModLogger.log(Level.WARN, "Got an unknown skin - Identifier: " + bakedSkin.getSkinIdentifierUpdated().toString());
            }
        }
    }

    public int getCacheSize() {
        return this.skinCache.asMap().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestQueueSize() {
        Cache<ISkinIdentifier, Boolean> cache = this.requestedSkins;
        synchronized (cache) {
            return this.requestedSkins.asMap().size();
        }
    }

    public int getModelCount() {
        int count = 0;
        Collection skins = this.skinCache.asMap().values();
        for (Skin skin : skins) {
            if (skin == null) continue;
            count += skin.getModelCount();
        }
        return count;
    }

    public int getPartCount() {
        int count = 0;
        Collection skins = this.skinCache.asMap().values();
        for (Skin skin : skins) {
            if (skin == null) continue;
            count += skin.getPartCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.skinCache.invalidateAll();
        Cache<ISkinIdentifier, Boolean> cache = this.requestedSkins;
        synchronized (cache) {
            this.requestedSkins.asMap().size();
        }
    }

    public CacheStats getStats() {
        return this.skinCache.stats();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT & event.phase == TickEvent.Phase.END) {
            this.cleanupCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCheck() {
        ArrayList<Skin> arrayList = this.cleanupList;
        synchronized (arrayList) {
            for (int i = this.cleanupList.size() - 1; i >= 0; --i) {
                this.cleanupList.get(i).cleanUpDisplayLists();
                this.cleanupList.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoval(RemovalNotification<ISkinIdentifier, Skin> notification) {
        ArrayList<Skin> arrayList = this.cleanupList;
        synchronized (arrayList) {
            this.cleanupList.add((Skin)notification.getValue());
        }
    }

    static {
        errorSkin = null;
    }

    private static class SkinRequestThread
    implements Runnable {
        private ISkinIdentifier skinIdentifier;

        public SkinRequestThread(ISkinIdentifier skinIdentifier) {
            this.skinIdentifier = skinIdentifier;
        }

        @Override
        public void run() {
            Thread.currentThread().setPriority(1);
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientRequestSkinData(this.skinIdentifier));
        }
    }
}

