/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.command;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.command.ModCommand;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandWardrobeSetColour
extends ModCommand {
    public CommandWardrobeSetColour(ModCommand parent) {
        super(parent, "setColour");
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == this.getParentCount() + 1) {
            return CommandWardrobeSetColour.func_71530_a((String[])args, (String[])this.getPlayers(server));
        }
        if (args.length == this.getParentCount() + 2) {
            ArrayList<String> types = new ArrayList<String>();
            for (IExtraColours.ExtraColourType type : IExtraColours.ExtraColourType.values()) {
                types.add(type.toString().toLowerCase());
            }
            return types;
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != this.getParentCount() + 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[]{args});
        }
        String argPlayer = args[this.getParentCount()];
        String argColourType = args[this.getParentCount() + 1];
        String argDye = args[this.getParentCount() + 2];
        EntityPlayerMP player = CommandWardrobeSetColour.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)argPlayer);
        IExtraColours.ExtraColourType colourType = IExtraColours.ExtraColourType.valueOf(argColourType.toUpperCase());
        Color colour = null;
        if (argDye.startsWith("#") && argDye.length() == 7) {
            if (!this.isValidHex(argDye)) throw new WrongUsageException(this.getFullName() + ".invalidColourFormat", new Object[]{argDye});
            Color dyeColour = Color.decode(argDye);
            int r = dyeColour.getRed();
            int g = dyeColour.getGreen();
            int b = dyeColour.getBlue();
            colour = new Color(r, g, b, 255);
        } else {
            if (!(argDye.length() >= 5 & argDye.contains(","))) throw new WrongUsageException(this.getFullName() + ".invalidColourFormat", new Object[]{argDye});
            String[] dyeValues = argDye.split(",");
            if (dyeValues.length != 3) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[]{argDye});
            }
            int r = CommandWardrobeSetColour.func_175764_a((String)dyeValues[0], (int)0, (int)255);
            int g = CommandWardrobeSetColour.func_175764_a((String)dyeValues[1], (int)0, (int)255);
            int b = CommandWardrobeSetColour.func_175764_a((String)dyeValues[2], (int)0, (int)255);
            colour = new Color(r, g, b, 255);
        }
        IPlayerWardrobeCap wardrobeCap = PlayerWardrobeCap.get((EntityPlayer)player);
        if (wardrobeCap == null) return;
        wardrobeCap.getExtraColours().setColour(colourType, colour.getRGB());
        wardrobeCap.syncToPlayer(player);
        wardrobeCap.syncToAllTracking();
    }

    private boolean isValidHex(String colorStr) {
        ModLogger.log(colorStr);
        String hexPatten = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
        Pattern pattern = Pattern.compile(hexPatten);
        Matcher matcher = pattern.matcher(colorStr);
        return matcher.matches();
    }
}

