/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.entities;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.common.GameProfileCache;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.init.items.ItemMannequin;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.inventory.ModInventory;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.TrigUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMannequin
extends Entity
implements GameProfileCache.IGameProfileCallback,
ModInventory.IInventoryCallback {
    public static final DataSerializer<TextureData> TEXTURE_DATA_SERIALIZER = new DataSerializerTextureData();
    public static final DataSerializer<BipedRotations> BIPED_ROTATIONS_SERIALIZER = new DataSerializerBipedRotations();
    private static final String TAG_BIPED_ROTATIONS = "biped_rotations";
    private static final String TAG_TEXTURE_DATA = "texture_data";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_RENDER_EXTRAS = "render_extras";
    private static final String TAG_FLYING = "flying";
    private static final String TAG_VISIBLE = "visible";
    private static final String TAG_NO_CLIP = "no_clip";
    private static final String TAG_SCALE = "scale";
    private static final String TAG_INVENTORY = "inventory";
    private static final DataParameter<BipedRotations> DATA_BIPED_ROTATIONS = EntityDataManager.func_187226_a(EntityMannequin.class, BIPED_ROTATIONS_SERIALIZER);
    private static final DataParameter<TextureData> DATA_TEXTURE_DATA = EntityDataManager.func_187226_a(EntityMannequin.class, TEXTURE_DATA_SERIALIZER);
    private static final DataParameter<Float> DATA_ROTATION = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> DATA_RENDER_EXTRAS = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_FLYING = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_VISIBLE = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_NO_CLIP = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> DATA_SCALE = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<ItemStack> DATA_HAND_LEFT = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> DATA_HAND_RIGHT = EntityDataManager.func_187226_a(EntityMannequin.class, (DataSerializer)DataSerializers.field_187196_f);
    private final ModInventory inventoryHands = new ModInventory("", 2, this);
    private int hitCount = 0;

    public EntityMannequin(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 1.9f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_BIPED_ROTATIONS, (Object)new BipedRotations());
        this.field_70180_af.func_187214_a(DATA_TEXTURE_DATA, (Object)new TextureData());
        this.field_70180_af.func_187214_a(DATA_ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DATA_RENDER_EXTRAS, (Object)true);
        this.field_70180_af.func_187214_a(DATA_FLYING, (Object)false);
        this.field_70180_af.func_187214_a(DATA_VISIBLE, (Object)true);
        this.field_70180_af.func_187214_a(DATA_NO_CLIP, (Object)false);
        this.field_70180_af.func_187214_a(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(DATA_HAND_LEFT, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(DATA_HAND_RIGHT, (Object)ItemStack.field_190927_a);
    }

    public void setBipedRotations(BipedRotations bipedRotations) {
        this.field_70180_af.func_187227_b(DATA_BIPED_ROTATIONS, (Object)bipedRotations);
    }

    public BipedRotations getBipedRotations() {
        return (BipedRotations)this.field_70180_af.func_187225_a(DATA_BIPED_ROTATIONS);
    }

    public void setTextureData(TextureData textureData, boolean updateProfile) {
        this.field_70180_af.func_187227_b(DATA_TEXTURE_DATA, (Object)textureData);
        if (updateProfile && !this.func_130014_f_().field_72995_K && textureData.getTextureType() == TextureType.USER & textureData.getProfile() != null) {
            GameProfileCache.getGameProfile(textureData.getProfile(), this);
        }
    }

    private void setTextureDataProfile(GameProfile gameProfile) {
        ModLogger.log("got profile back: " + gameProfile);
        this.field_70180_af.func_187227_b(DATA_TEXTURE_DATA, (Object)new TextureData(gameProfile));
    }

    public TextureData getTextureData() {
        return (TextureData)this.field_70180_af.func_187225_a(DATA_TEXTURE_DATA);
    }

    public void setRotation(float value) {
        this.field_70180_af.func_187227_b(DATA_ROTATION, (Object)Float.valueOf(value));
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(DATA_ROTATION)).floatValue();
    }

    public void setRenderExtras(boolean value) {
        this.field_70180_af.func_187227_b(DATA_RENDER_EXTRAS, (Object)value);
    }

    public boolean isRenderExtras() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_RENDER_EXTRAS);
    }

    public void setFlying(boolean value) {
        this.field_70180_af.func_187227_b(DATA_FLYING, (Object)value);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_FLYING);
    }

    public void setVisible(boolean value) {
        this.field_70180_af.func_187227_b(DATA_VISIBLE, (Object)value);
    }

    public boolean isVisible() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_VISIBLE);
    }

    public void setNoClip(boolean value) {
        this.field_70180_af.func_187227_b(DATA_NO_CLIP, (Object)value);
    }

    public boolean isNoClip() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_NO_CLIP);
    }

    public void setScale(float value) {
        this.field_70180_af.func_187227_b(DATA_SCALE, (Object)Float.valueOf(value));
    }

    public float getScale() {
        return ((Float)this.field_70180_af.func_187225_a(DATA_SCALE)).floatValue();
    }

    public void setHandLeft(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(DATA_HAND_LEFT, (Object)itemStack);
    }

    public ItemStack getHandLeft() {
        return (ItemStack)this.field_70180_af.func_187225_a(DATA_HAND_LEFT);
    }

    public void setHandRight(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(DATA_HAND_RIGHT, (Object)itemStack);
    }

    public ItemStack getHandRight() {
        return (ItemStack)this.field_70180_af.func_187225_a(DATA_HAND_RIGHT);
    }

    public ModInventory getInventoryHands() {
        return this.inventoryHands;
    }

    public void updateInventory() {
        if (!this.func_130014_f_().field_72995_K) {
            this.setHandLeft(this.inventoryHands.func_70301_a(0));
            this.setHandRight(this.inventoryHands.func_70301_a(1));
        }
    }

    public float func_70047_e() {
        return super.func_70047_e() * this.getScale();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70075_an() {
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.hitCount > 80) {
            this.func_70106_y();
        }
        if (this.hitCount > 0) {
            --this.hitCount;
        }
    }

    public AxisAlignedBB func_174813_aQ() {
        float halfWidthScaled = this.field_70130_N / 2.0f * this.getScale();
        AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - (double)halfWidthScaled, this.field_70163_u, this.field_70161_v - (double)halfWidthScaled, this.field_70165_t + (double)halfWidthScaled, this.field_70163_u + (double)(this.field_70131_O * this.getScale()), this.field_70161_v + (double)halfWidthScaled);
        return bb;
    }

    public AxisAlignedBB func_70046_E() {
        if (this.isNoClip()) {
            return null;
        }
        return this.func_174813_aQ();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return true;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                double angle = TrigUtils.getAngleDegrees(player.field_70165_t, player.field_70161_v, this.field_70165_t, this.field_70161_v) + 90.0;
                this.setRotation((float)angle);
            }
        } else if (itemStack.func_77973_b() != ModItems.MANNEQUIN_TOOL) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ArmourersWorkshop.getInstance(), (int)EnumGuiId.WARDROBE_ENTITY.ordinal(), (World)this.func_130014_f_(), (int)this.func_145782_y(), (int)0, (int)0);
        }
        return EnumActionResult.PASS;
    }

    public void func_70106_y() {
        if (!this.field_70128_L && !this.func_130014_f_().field_72995_K) {
            IEntitySkinCapability skinCapability = EntitySkinCapability.get(this);
            if (skinCapability != null) {
                skinCapability.getSkinInventoryContainer().dropItems(this.func_130014_f_(), this.func_174791_d());
            }
            BlockUtils.dropInventoryBlocks(this.func_130014_f_(), this.inventoryHands, this.func_180425_c());
            this.func_184185_a(SoundEvents.field_187701_j, 1.0f, 1.0f);
            ItemStack itemStack = this.createStackForEntity();
            this.func_70099_a(itemStack, 0.0f);
        }
        super.func_70106_y();
    }

    public ItemStack createStackForEntity() {
        return ItemMannequin.create(this.getTextureData(), this.getScale());
    }

    public boolean func_85031_j(Entity entityIn) {
        if (!this.func_130014_f_().field_72995_K && entityIn instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entityIn;
            this.func_184185_a(SoundEvents.field_187707_l, 0.8f, 1.0f);
            this.hitCount = entityPlayer.field_71075_bZ.field_75098_d ? (this.hitCount += 200) : (this.hitCount += 20);
        }
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b(TAG_BIPED_ROTATIONS, 10)) {
            BipedRotations bipedRotations = new BipedRotations();
            bipedRotations.loadNBTData(compound.func_74775_l(TAG_BIPED_ROTATIONS));
            this.setBipedRotations(bipedRotations);
        }
        if (compound.func_150297_b(TAG_TEXTURE_DATA, 10)) {
            TextureData textureData = new TextureData();
            textureData.readFromNBT(compound.func_74775_l(TAG_TEXTURE_DATA));
            this.setTextureData(textureData, false);
        }
        if (compound.func_150297_b(TAG_ROTATION, 5)) {
            this.setRotation(compound.func_74760_g(TAG_ROTATION));
        }
        if (compound.func_150297_b(TAG_RENDER_EXTRAS, 1)) {
            this.setRenderExtras(compound.func_74767_n(TAG_RENDER_EXTRAS));
        }
        if (compound.func_150297_b(TAG_FLYING, 1)) {
            this.setFlying(compound.func_74767_n(TAG_FLYING));
        }
        if (compound.func_150297_b(TAG_VISIBLE, 1)) {
            this.setVisible(compound.func_74767_n(TAG_VISIBLE));
        }
        if (compound.func_150297_b(TAG_NO_CLIP, 1)) {
            this.setNoClip(compound.func_74767_n(TAG_NO_CLIP));
        }
        if (compound.func_150297_b(TAG_SCALE, 5)) {
            this.setScale(compound.func_74760_g(TAG_SCALE));
        }
        if (compound.func_150297_b(TAG_INVENTORY, 10)) {
            this.inventoryHands.loadItemsFromNBT(compound.func_74775_l(TAG_INVENTORY));
            this.updateInventory();
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a(TAG_BIPED_ROTATIONS, (NBTBase)this.getBipedRotations().saveNBTData(new NBTTagCompound()));
        compound.func_74782_a(TAG_TEXTURE_DATA, (NBTBase)this.getTextureData().writeToNBT(new NBTTagCompound()));
        compound.func_74776_a(TAG_ROTATION, this.getRotation());
        compound.func_74757_a(TAG_RENDER_EXTRAS, this.isRenderExtras());
        compound.func_74757_a(TAG_FLYING, this.isFlying());
        compound.func_74757_a(TAG_VISIBLE, this.isVisible());
        compound.func_74757_a(TAG_NO_CLIP, this.isNoClip());
        compound.func_74776_a(TAG_SCALE, this.getScale());
        compound.func_74782_a(TAG_INVENTORY, (NBTBase)this.inventoryHands.saveItemsToNBT(new NBTTagCompound()));
    }

    @Override
    public void profileDownloaded(final GameProfile gameProfile) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityMannequin.this.setTextureDataProfile(gameProfile);
            }
        });
    }

    @Override
    public void setInventorySlotContents(IInventory inventory, int index, ItemStack stack) {
        this.updateInventory();
    }

    @Override
    public void dirty() {
    }

    public static class DataSerializerTextureData
    implements DataSerializer<TextureData> {
        public void write(PacketBuffer buf, TextureData value) {
            value.writeToBuf((ByteBuf)buf);
        }

        public TextureData read(PacketBuffer buf) throws IOException {
            TextureData textureData = new TextureData();
            textureData.readFromBuf((ByteBuf)buf);
            return textureData;
        }

        public DataParameter<TextureData> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public TextureData copyValue(TextureData value) {
            return value;
        }
    }

    public static class DataSerializerBipedRotations
    implements DataSerializer<BipedRotations> {
        public void write(PacketBuffer buf, BipedRotations value) {
            value.writeToBuf((ByteBuf)buf);
        }

        public BipedRotations read(PacketBuffer buf) throws IOException {
            BipedRotations bipedRotations = new BipedRotations();
            bipedRotations.readFromBuf((ByteBuf)buf);
            return bipedRotations;
        }

        public DataParameter<BipedRotations> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public BipedRotations copyValue(BipedRotations value) {
            return value;
        }
    }

    public static class TextureData {
        private static final String TAG_TEXTURE_TYPE = "texture_type";
        private static final String TAG_PROFILE = "profile";
        private static final String TAG_URL = "url";
        private TextureType textureType = TextureType.NONE;
        private GameProfile profile = null;
        private String url = null;

        public TextureData() {
            this.textureType = TextureType.NONE;
        }

        public TextureData(GameProfile gameProfile) {
            this.textureType = TextureType.USER;
            this.profile = gameProfile;
        }

        public TextureData(String url) {
            this.textureType = TextureType.URL;
            this.url = url;
        }

        public TextureType getTextureType() {
            return this.textureType;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public String getUrl() {
            return this.url;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.textureType = compound.func_150297_b(TAG_TEXTURE_TYPE, 8) ? TextureType.valueOf(compound.func_74779_i(TAG_TEXTURE_TYPE)) : TextureType.NONE;
            switch (this.textureType) {
                case NONE: {
                    break;
                }
                case USER: {
                    if (compound.func_150297_b(TAG_PROFILE, 10)) {
                        this.profile = NBTUtil.func_152459_a((NBTTagCompound)compound.func_74775_l(TAG_PROFILE));
                        break;
                    }
                    this.textureType = TextureType.NONE;
                    break;
                }
                case URL: {
                    if (compound.func_150297_b(TAG_URL, 8)) {
                        this.url = compound.func_74779_i(TAG_URL);
                        break;
                    }
                    this.textureType = TextureType.NONE;
                }
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            switch (this.textureType) {
                case NONE: {
                    break;
                }
                case USER: {
                    if (this.profile != null) {
                        compound.func_74782_a(TAG_PROFILE, (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.profile));
                        break;
                    }
                    this.textureType = TextureType.NONE;
                    break;
                }
                case URL: {
                    if (!StringUtils.func_151246_b((String)this.url)) {
                        compound.func_74778_a(TAG_URL, this.url);
                        break;
                    }
                    this.textureType = TextureType.NONE;
                }
            }
            compound.func_74778_a(TAG_TEXTURE_TYPE, this.textureType.toString());
            return compound;
        }

        public void writeToBuf(ByteBuf buf) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeToNBT(new NBTTagCompound()));
        }

        public void readFromBuf(ByteBuf buf) {
            this.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        }

        public String toString() {
            return "TextureData [textureType=" + (Object)((Object)this.textureType) + ", profile=" + this.profile + ", url=" + this.url + "]";
        }
    }
}

