/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinIdentifier;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.settings.Keybindings;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItemArmour;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeRegistry;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.world.BlockSkinPlacementHelper;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemSkin
extends AbstractModItem {
    private static final IBehaviorDispenseItem dispenserBehavior = new BehaviorDefaultDispenseItem(){

        protected ItemStack func_82487_b(IBlockSource blockSource, ItemStack itemStack) {
            if (!SkinNBTHelper.stackHasSkinData(itemStack)) {
                return super.func_82487_b(blockSource, itemStack);
            }
            IBlockState state = blockSource.func_189992_e();
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos target = blockSource.func_180699_d().func_177972_a(facing);
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(target);
            List list = blockSource.func_82618_k().func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (int i = 0; i < list.size(); ++i) {
                EntityPlayer player;
                IEntitySkinCapability skinCap;
                EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(i);
                if (!(entitylivingbase instanceof EntityPlayer) || !(skinCap = EntitySkinCapability.get((Entity)(player = (EntityPlayer)entitylivingbase))).setStackInNextFreeSlot(itemStack.func_77946_l())) continue;
                itemStack.func_190918_g(1);
                skinCap.syncToAllTracking();
                skinCap.syncToPlayer((EntityPlayerMP)player);
                return itemStack;
            }
            return super.func_82487_b(blockSource, itemStack);
        }
    };

    public ItemSkin() {
        super("skin", false);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)dispenserBehavior);
    }

    public ISkinType getSkinType(ItemStack stack) {
        return SkinNBTHelper.getSkinTypeFromStack(stack);
    }

    public String func_77653_i(ItemStack stack) {
        Skin skin = SkinUtils.getSkinDetectSide(stack, true, false);
        if (skin != null && !skin.getCustomName().trim().isEmpty()) {
            return skin.getCustomName();
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addTooltipToSkinItem(ItemStack stack, EntityPlayer player, List tooltip, ITooltipFlag flagIn) {
        String cRed = TextFormatting.RED.toString();
        boolean isEquipmentSkin = stack.func_77973_b() == ModItems.SKIN;
        boolean isEquipmentContainer = stack.func_77973_b() instanceof AbstractModItemArmour;
        if (SkinNBTHelper.stackHasSkinData(stack)) {
            SkinDescriptor skinData = SkinNBTHelper.getSkinDescriptorFromStack(stack);
            ISkinIdentifier identifier = skinData.getIdentifier();
            if (!isEquipmentSkin) {
                tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.hasSkin"));
            }
            if (ClientSkinCache.INSTANCE.isSkinInCache(skinData)) {
                String flavour;
                Skin data = ClientSkinCache.INSTANCE.getSkin(skinData);
                if (stack.func_77973_b() != ModItems.SKIN & !data.getCustomName().trim().isEmpty()) {
                    tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinName", data.getCustomName()));
                }
                if (!data.getAuthorName().trim().isEmpty()) {
                    tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinAuthor", data.getAuthorName()));
                }
                if (skinData.getIdentifier().getSkinType() != null) {
                    String localSkinName = SkinTypeRegistry.INSTANCE.getLocalizedSkinTypeName(skinData.getIdentifier().getSkinType());
                    tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinType", localSkinName));
                }
                if (ConfigHandlerClient.showSkinTooltipDebugInfo) {
                    if (GuiScreen.func_146272_n()) {
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinIdentifier"));
                        if (identifier.hasLocalId()) {
                            tooltip.add("  " + TranslateUtils.translate("item.armourers_workshop:rollover.skinId", identifier.getSkinLocalId()));
                        }
                        if (identifier.hasLibraryFile()) {
                            tooltip.add("  " + TranslateUtils.translate("item.armourers_workshop:rollover.skinLibraryFile", identifier.getSkinLibraryFile().getFullName()));
                        }
                        if (identifier.hasGlobalId()) {
                            tooltip.add("  " + TranslateUtils.translate("item.armourers_workshop:rollover.skinGlobalId", identifier.getSkinGlobalId()));
                        }
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinTotalCubes", data.getTotalCubes()));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinNumCubes", data.getTotalOfCubeType(CubeRegistry.INSTANCE.getCubeFormId((byte)0))));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinNumCubesGlowing", data.getTotalOfCubeType(CubeRegistry.INSTANCE.getCubeFormId((byte)1))));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinNumCubesGlass", data.getTotalOfCubeType(CubeRegistry.INSTANCE.getCubeFormId((byte)2))));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinNumCubesGlassGlowing", data.getTotalOfCubeType(CubeRegistry.INSTANCE.getCubeFormId((byte)3))));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinPaintData", data.hasPaintData()));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinMarkerCount", data.getMarkerCount()));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinDyeCount", skinData.getSkinDye().getNumberOfDyes()));
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinProperties"));
                        ArrayList<String> props = data.getProperties().getPropertiesList();
                        for (int i = 0; i < props.size(); ++i) {
                            tooltip.add("  " + props.get(i));
                        }
                    } else {
                        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinHoldShiftForInfo"));
                    }
                }
                if (identifier.hasLocalId() && identifier.getSkinLocalId() != data.lightHash()) {
                    tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinIdError1"));
                    tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinIdError2"));
                }
                if (!StringUtils.isEmpty((CharSequence)(flavour = SkinProperties.PROP_ALL_FLAVOUR_TEXT.getValue(data.getProperties()).trim()))) {
                    tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.flavour", flavour));
                }
            } else {
                tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skindownloading", identifier.toString()));
                if (identifier.hasLocalId()) {
                    tooltip.add("  " + TranslateUtils.translate("item.armourers_workshop:rollover.skinId", identifier.getSkinLocalId()));
                }
                if (identifier.hasLibraryFile()) {
                    tooltip.add("  " + TranslateUtils.translate("item.armourers_workshop:rollover.skinLibraryFile", identifier.getSkinLibraryFile().getFullName()));
                }
                if (identifier.hasGlobalId()) {
                    tooltip.add("  " + TranslateUtils.translate("item.armourers_workshop:rollover.skinGlobalId", identifier.getSkinGlobalId()));
                }
            }
            String keyName = Keybindings.OPEN_WARDROBE.getDisplayName();
            if (isEquipmentSkin) {
                tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinOpenWardrobe", keyName));
            }
        } else if (isEquipmentSkin) {
            tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.skinInvalidItem"));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        SkinDescriptor descriptor = SkinNBTHelper.getSkinDescriptorFromStack(stack);
        if (descriptor != null && descriptor.getIdentifier().getSkinType() == SkinTypeRegistry.skinBlock) {
            IBlockState replaceBlock;
            Skin skin = SkinUtils.getSkinDetectSide(descriptor, false, true);
            if (skin != null && (replaceBlock = worldIn.func_180495_p(pos.func_177972_a(facing))).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177972_a(facing))) {
                BlockSkinPlacementHelper.placeSkinAtLocation(worldIn, player, facing, stack, pos.func_177972_a(facing), skin, descriptor);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        SkinDescriptor descriptor;
        IEntitySkinCapability skinCapability;
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        IPlayerWardrobeCap wardrobeCap = PlayerWardrobeCap.get(playerIn);
        if (wardrobeCap == null | (skinCapability = EntitySkinCapability.get((Entity)playerIn)) == null | (descriptor = SkinNBTHelper.getSkinDescriptorFromStack(itemStack)) == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        ISkinType skinType = descriptor.getIdentifier().getSkinType();
        if (!worldIn.field_72995_K && skinCapability.canHoldSkinType(descriptor.getIdentifier().getSkinType())) {
            if (skinCapability.setStackInNextFreeSlot(itemStack.func_77946_l())) {
                skinCapability.syncToPlayer((EntityPlayerMP)playerIn);
                skinCapability.syncToAllTracking();
                itemStack.func_190918_g(1);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }
}

