/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.inventory;

import moe.plushie.armourers_workshop.common.exception.SkinSaveException;
import moe.plushie.armourers_workshop.common.init.items.ItemArmourContainerItem;
import moe.plushie.armourers_workshop.common.init.items.ItemSkin;
import moe.plushie.armourers_workshop.common.init.items.ItemSkinTemplate;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.inventory.ModTileContainer;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotOutput;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotSkinTemplate;
import moe.plushie.armourers_workshop.common.skin.ISkinHolder;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperty;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.common.world.ArmourerWorldHelper;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ContainerArmourer
extends ModTileContainer<TileEntityArmourer> {
    public ContainerArmourer(InventoryPlayer invPlayer, TileEntityArmourer tileEntity) {
        super(invPlayer, tileEntity);
        this.func_75146_a(new SlotSkinTemplate(tileEntity, 0, 64, 21));
        this.func_75146_a(new SlotOutput(tileEntity, 1, 147, 21));
        this.addPlayerSlots(8, 142);
    }

    @Override
    protected ItemStack transferStackFromPlayer(EntityPlayer playerIn, int index) {
        Slot slot = this.func_75139_a(index);
        if (slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack result = stack.func_77946_l();
            if (stack.func_77973_b() instanceof ItemSkinTemplate | stack.func_77973_b() instanceof ItemSkin | stack.func_77973_b() instanceof ItemArmourContainerItem) {
                if (!this.func_75135_a(stack, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_190901_a(playerIn, stack);
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public void saveArmourItem(EntityPlayerMP player, String customName, String tags) {
        if (((TileEntityArmourer)this.tileEntity).func_145831_w().field_72995_K) {
            return;
        }
        ItemStack stackInput = ((TileEntityArmourer)this.tileEntity).func_70301_a(0);
        ItemStack stackOutput = ((TileEntityArmourer)this.tileEntity).func_70301_a(1);
        if (player.field_71075_bZ.field_75098_d && stackInput.func_190926_b()) {
            stackInput = new ItemStack(ModItems.SKIN_TEMPLATE);
        }
        if (stackInput.func_190926_b()) {
            return;
        }
        if (!stackOutput.func_190926_b()) {
            return;
        }
        if (!(stackInput.func_77973_b() instanceof ISkinHolder)) {
            return;
        }
        Skin skin = null;
        SkinProperties skinProps = new SkinProperties();
        SkinProperties.PROP_ALL_AUTHOR_NAME.setValue(skinProps, player.func_70005_c_());
        if (player.func_146103_bH() != null && player.func_146103_bH().getId() != null) {
            SkinProperties.PROP_ALL_AUTHOR_UUID.setValue(skinProps, player.func_146103_bH().getId().toString());
        }
        SkinProperties.PROP_ALL_CUSTOM_NAME.setValue(skinProps, customName);
        for (int i = 0; i < ((TileEntityArmourer)this.tileEntity).getSkinType().getProperties().size(); ++i) {
            SkinProperty skinProp = (SkinProperty)((TileEntityArmourer)this.tileEntity).getSkinType().getProperties().get(i);
            skinProp.setValue(skinProps, skinProp.getValue(((TileEntityArmourer)this.tileEntity).getSkinProps()));
        }
        try {
            skin = ArmourerWorldHelper.saveSkinFromWorld(((TileEntityArmourer)this.tileEntity).func_145831_w(), skinProps, ((TileEntityArmourer)this.tileEntity).getSkinType(), ((TileEntityArmourer)this.tileEntity).getPaintData(), ((TileEntityArmourer)this.tileEntity).func_174877_v().func_177967_a(EnumFacing.UP, ((TileEntityArmourer)this.tileEntity).getHeightOffset()), ((TileEntityArmourer)this.tileEntity).getDirection());
        }
        catch (SkinSaveException e) {
            switch (e.getType()) {
                case NO_DATA: {
                    player.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                    break;
                }
                case MARKER_ERROR: {
                    player.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                    break;
                }
                case MISSING_PARTS: {
                    player.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                    break;
                }
                case BED_AND_SEAT: {
                    player.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                    break;
                }
                case INVALID_MULTIBLOCK: {
                    player.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                }
            }
        }
        if (skin == null) {
            return;
        }
        CommonSkinCache.INSTANCE.addEquipmentDataToCache(skin, null);
        ItemStack stackArmour = ((ISkinHolder)stackInput.func_77973_b()).makeSkinStack(skin);
        if (stackArmour.func_190926_b()) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            ((TileEntityArmourer)this.tileEntity).func_70298_a(0, 1);
        }
        ((TileEntityArmourer)this.tileEntity).func_70299_a(1, stackArmour);
    }

    public void loadArmourItem(EntityPlayerMP player) {
        if (((TileEntityArmourer)this.tileEntity).func_145831_w().field_72995_K) {
            return;
        }
        ItemStack stackInput = ((TileEntityArmourer)this.tileEntity).func_70301_a(0);
        ItemStack stackOuput = ((TileEntityArmourer)this.tileEntity).func_70301_a(1);
        if (stackInput.func_190926_b()) {
            return;
        }
        if (!stackOuput.func_190926_b()) {
            return;
        }
        if (!(stackInput.func_77973_b() instanceof ItemSkin)) {
            return;
        }
        SkinDescriptor skinPointerInput = SkinNBTHelper.getSkinDescriptorFromStack(stackInput);
        if (skinPointerInput == null) {
            return;
        }
        if (((TileEntityArmourer)this.tileEntity).getSkinType() == null) {
            return;
        }
        if (((TileEntityArmourer)this.tileEntity).getSkinType() != skinPointerInput.getIdentifier().getSkinType() && (((TileEntityArmourer)this.tileEntity).getSkinType() != SkinTypeRegistry.skinLegs || skinPointerInput.getIdentifier().getSkinType() != SkinTypeRegistry.oldSkinSkirt)) {
            return;
        }
        Skin skin = CommonSkinCache.INSTANCE.getSkin(skinPointerInput);
        if (skin == null) {
            return;
        }
        ((TileEntityArmourer)this.tileEntity).setSkinProps(new SkinProperties(skin.getProperties()));
        ArmourerWorldHelper.loadSkinIntoWorld(((TileEntityArmourer)this.tileEntity).func_145831_w(), ((TileEntityArmourer)this.tileEntity).func_174877_v().func_177967_a(EnumFacing.UP, ((TileEntityArmourer)this.tileEntity).getHeightOffset()), skin, ((TileEntityArmourer)this.tileEntity).getDirection());
        if (skin.hasPaintData()) {
            ((TileEntityArmourer)this.tileEntity).setPaintData((int[])skin.getPaintData().clone());
        } else {
            ((TileEntityArmourer)this.tileEntity).clearPaintData(true);
        }
        ((TileEntityArmourer)this.tileEntity).dirtySync();
        ((TileEntityArmourer)this.tileEntity).func_70299_a(0, ItemStack.field_190927_a);
        ((TileEntityArmourer)this.tileEntity).func_70299_a(1, stackInput);
    }
}

