/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.task;

import com.google.gson.JsonObject;
import moe.plushie.armourers_workshop.common.library.global.PlushieUser;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTask;
import moe.plushie.armourers_workshop.utils.ModLogger;
import org.apache.logging.log4j.Level;

public class GlobalTaskUserInfo
extends GlobalTask<PlushieUser> {
    private static final String URL = "user-info.php?userId=%d";
    private final int userID;

    public GlobalTaskUserInfo(int userID) {
        super(PermissionSystem.PlushieAction.USER_INFO, false);
        this.userID = userID;
    }

    @Override
    public PlushieUser call() throws Exception {
        this.permissionCheck();
        String url = this.getBaseUrl() + URL;
        url = String.format(url, this.userID);
        JsonObject json = GlobalTaskUserInfo.downloadJson(url).getAsJsonObject();
        PlushieUser plushieUser = PlushieUser.readPlushieUser(json);
        if (plushieUser == null) {
            ModLogger.log(Level.ERROR, "Failed downloading info for user id: " + this.userID);
        }
        return plushieUser;
    }
}

