/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.painting;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintType;
import moe.plushie.armourers_workshop.utils.BitwiseUtils;
import moe.plushie.armourers_workshop.utils.ModLogger;
import org.apache.logging.log4j.Level;

public final class PaintTypeRegistry
implements IPaintTypeRegistry {
    public static final PaintType PAINT_TYPE_NORMAL = new PaintType(255, 0, "normal");
    public static final PaintType PAINT_TYPE_DYE_1 = new PaintType(1, 1, true, "dye_1");
    public static final PaintType PAINT_TYPE_DYE_2 = new PaintType(2, 2, true, "dye_2");
    public static final PaintType PAINT_TYPE_DYE_3 = new PaintType(3, 3, true, "dye_3");
    public static final PaintType PAINT_TYPE_DYE_4 = new PaintType(4, 4, true, "dye_4");
    public static final PaintType PAINT_TYPE_DYE_5 = new PaintType(5, 5, true, "dye_5");
    public static final PaintType PAINT_TYPE_DYE_6 = new PaintType(6, 6, true, "dye_6");
    public static final PaintType PAINT_TYPE_DYE_7 = new PaintType(7, 7, true, "dye_7");
    public static final PaintType PAINT_TYPE_DYE_8 = new PaintType(8, 8, true, "dye_8");
    public static final PaintType PAINT_TYPE_RAINBOW = new PaintType(104, 14, true, "rainbow").setTextureUV(1.0f, 0.0f);
    public static final PaintType PAINT_TYPE_PULSE_1 = new PaintType(105, 15, "pulse_1").setTextureUV(2.0f, 0.0f);
    public static final PaintType PAINT_TYPE_PULSE_2 = new PaintType(106, 16, "pulse_2").setTextureUV(3.0f, 0.0f);
    public static final PaintType PAINT_TYPE_TEXTURE = new PaintType(107, 17, "texture");
    public static final PaintType PAINT_TYPE_FLICKER_1 = new PaintType(108, 18, "flicker_1").setTextureUV(4.0f, 0.0f);
    public static final PaintType PAINT_TYPE_FLICKER_2 = new PaintType(109, 19, "flicker_2").setTextureUV(5.0f, 0.0f);
    public static final PaintType PAINT_TYPE_SKIN = new PaintType(253, 10, true, "skin").setExtraColourType(IExtraColours.ExtraColourType.SKIN);
    public static final PaintType PAINT_TYPE_HAIR = new PaintType(254, 11, true, "hair").setExtraColourType(IExtraColours.ExtraColourType.HAIR);
    public static final PaintType PAINT_TYPE_EYES = new PaintType(251, 12, true, "eye").setExtraColourType(IExtraColours.ExtraColourType.EYE);
    public static final PaintType PAINT_TYPE_MISC_1 = new PaintType(252, 13, true, "misc_1").setExtraColourType(IExtraColours.ExtraColourType.MISC_1);
    public static final PaintType PAINT_TYPE_MISC_2 = new PaintType(250, 20, true, "misc_2").setExtraColourType(IExtraColours.ExtraColourType.MISC_2);
    public static final PaintType PAINT_TYPE_MISC_3 = new PaintType(249, 21, true, "misc_3").setExtraColourType(IExtraColours.ExtraColourType.MISC_3);
    public static final PaintType PAINT_TYPE_MISC_4 = new PaintType(248, 22, true, "misc_4").setExtraColourType(IExtraColours.ExtraColourType.MISC_4);
    public static final PaintType PAINT_TYPE_NONE = new PaintType(0, 9, "none");
    private final IPaintType[] paintTypes = new IPaintType[256];
    private final ArrayList<IPaintType> registeredTypes = new ArrayList();
    private int extraChannels = 0;

    public static PaintTypeRegistry getInstance() {
        return ArmourersWorkshop.getProxy().getPaintTypeRegistry();
    }

    public PaintTypeRegistry() {
        for (int i = 0; i < this.paintTypes.length; ++i) {
            this.paintTypes[i] = PAINT_TYPE_NORMAL;
        }
        for (IPaintType paintType : PaintType.PAINT_TYPES) {
            this.registerPaintType(paintType);
        }
    }

    @Override
    public boolean registerPaintType(IPaintType paintType) {
        if (paintType == null) {
            ModLogger.log(Level.WARN, "A mod tried to register a null paint type.");
            return false;
        }
        if (this.paintTypes[paintType.getId()] != PAINT_TYPE_NORMAL) {
            ModLogger.log(Level.WARN, "A mod tried to register a paint type with an id that is in use.");
            return false;
        }
        this.paintTypes[paintType.getId()] = paintType;
        this.registeredTypes.add(paintType);
        if (paintType.hasAverageColourChannel()) {
            paintType.setColourChannelIndex(this.extraChannels);
            ++this.extraChannels;
        }
        return true;
    }

    @Override
    public int getExtraChannels() {
        return this.extraChannels;
    }

    @Override
    public IPaintType getPaintTypeFromColour(int trgb) {
        int type = 0xFF & trgb >> 24;
        return this.getPaintTypeFromIndex(type);
    }

    @Override
    public int setPaintTypeOnColour(IPaintType paintType, int colour) {
        return BitwiseUtils.setUByteToInt(colour, 0, paintType.getId());
    }

    @Override
    public IPaintType getPaintTypeFormByte(byte index) {
        return this.getPaintTypeFromIndex(index & 0xFF);
    }

    @Override
    public IPaintType getPaintTypeFormName(String name) {
        for (IPaintType paintType : this.paintTypes) {
            if (!paintType.getName().equals(name)) continue;
            return paintType;
        }
        return PAINT_TYPE_NORMAL;
    }

    @Override
    public ArrayList<IPaintType> getRegisteredTypes() {
        return this.registeredTypes;
    }

    @Override
    public IPaintType getPaintTypeFromIndex(int index) {
        return this.paintTypes[index];
    }
}

