/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.skin.exporter;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.client.model.bake.ColouredFace;
import moe.plushie.armourers_workshop.client.skin.ClientSkinPartData;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.skin.exporter.ISkinExporter;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import moe.plushie.armourers_workshop.utils.ModLogger;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class SkinExporterWavefrontObj
implements ISkinExporter {
    @Override
    public String[] getFileExtensions() {
        return new String[]{"obj"};
    }

    @Override
    public void exportSkin(Skin skin, File filePath, String filename, float scale) {
        try {
            for (int i = 0; i < skin.getPartCount(); ++i) {
                SkinPart skinPart = skin.getParts().get(i);
                this.exportPart(skinPart, skin, filePath, filename, scale);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void exportPart(SkinPart skinPart, Skin skin, File filePath, String filename, float scale) throws IOException {
        ClientSkinPartData cspd = skinPart.getClientSkinPartData();
        for (int i = 0; i < ClientProxy.getNumberOfRenderLayers(); ++i) {
            this.exportLayer(skinPart, skin, filePath, filename, scale, i);
        }
    }

    private void exportLayer(SkinPart skinPart, Skin skin, File filePath, String filename, float scale, int layer) throws IOException {
        ColouredFace cf;
        int i;
        String finalName = filename;
        finalName = finalName + "-" + skin.getSkinType().getName().toLowerCase();
        finalName = finalName + "-" + skinPart.getPartType().getPartName().toLowerCase();
        finalName = finalName + "-" + layer;
        ClientSkinPartData cspd = skinPart.getClientSkinPartData();
        ArrayList<ColouredFace> faces = cspd.vertexLists[layer];
        if (faces.isEmpty()) {
            return;
        }
        BufferedImage texture = new BufferedImage(256, 256, 2);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(filePath, finalName + ".obj"), false);
        }
        catch (FileNotFoundException e) {
            IOUtils.closeQuietly(outputStream);
            e.printStackTrace();
            return;
        }
        ModLogger.log("Exporting part " + skinPart);
        String CRLF = "\n";
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)outputStream, Charsets.US_ASCII);
        os.write("# WavefrontObj" + CRLF);
        os.write("# This file was exported from the Minecraft mod Armourer's Workshop" + CRLF);
        os.write("mtllib " + finalName + ".mtl" + CRLF);
        os.write("o " + skinPart.getPartType().getPartName().toLowerCase() + CRLF);
        os.flush();
        ModLogger.log("faces to export " + faces.size());
        block18: for (int i2 = 0; i2 < faces.size(); ++i2) {
            ColouredFace cf2 = faces.get(i2);
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(cf2.t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            switch (cf2.face) {
                case 0: {
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x, scale * (float)(-cf2.y) - scale);
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x, scale * (float)(-cf2.y) - scale);
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x + scale, scale * (float)(-cf2.y) - scale);
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x + scale, scale * (float)(-cf2.y) - scale);
                    continue block18;
                }
                case 1: {
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x + scale, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x + scale, scale * (float)(-cf2.y));
                    continue block18;
                }
                case 2: {
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x + scale, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x + scale, scale * (float)(-cf2.y) - scale);
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x, scale * (float)(-cf2.y) - scale);
                    continue block18;
                }
                case 3: {
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x + scale, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x + scale, scale * (float)(-cf2.y) - scale);
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x, scale * (float)(-cf2.y) - scale);
                    continue block18;
                }
                case 4: {
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x + scale, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x + scale, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x + scale, scale * (float)(-cf2.y) - scale);
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x + scale, scale * (float)(-cf2.y) - scale);
                    continue block18;
                }
                case 5: {
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x, scale * (float)(-cf2.y));
                    this.writeVert(os, scale * (float)(-cf2.z) - scale, scale * (float)cf2.x, scale * (float)(-cf2.y) - scale);
                    this.writeVert(os, scale * (float)(-cf2.z), scale * (float)cf2.x, scale * (float)(-cf2.y) - scale);
                    continue block18;
                }
            }
        }
        int ix = 0;
        int iy = 0;
        float pixelSize = 0.0078125f;
        for (i = 0; i < faces.size(); ++i) {
            cf = faces.get(i);
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(cf.t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            int colour = PaintingHelper.bytesToInt(new byte[]{cf.r, cf.g, cf.b, -1});
            texture.setRGB(ix, 255 - iy, colour);
            texture.setRGB(ix + 1, 255 - iy, colour);
            texture.setRGB(ix, 255 - iy - 1, colour);
            texture.setRGB(ix + 1, 255 - iy - 1, colour);
            float shift = 0.002f;
            os.write(String.format("vt %f %f", Float.valueOf((float)ix / 2.0f * pixelSize + pixelSize - shift), Float.valueOf((float)iy / 2.0f * pixelSize + shift)) + CRLF);
            os.write(String.format("vt %f %f", Float.valueOf((float)ix / 2.0f * pixelSize + pixelSize - shift), Float.valueOf((float)iy / 2.0f * pixelSize + pixelSize - shift)) + CRLF);
            os.write(String.format("vt %f %f", Float.valueOf((float)ix / 2.0f * pixelSize + shift), Float.valueOf((float)iy / 2.0f * pixelSize + pixelSize - shift)) + CRLF);
            os.write(String.format("vt %f %f", Float.valueOf((float)ix / 2.0f * pixelSize + shift), Float.valueOf((float)iy / 2.0f * pixelSize + shift)) + CRLF);
            ++ix;
            if (++ix <= 255) continue;
            ix = 0;
            ++iy;
            ++iy;
        }
        block20: for (i = 0; i < faces.size(); ++i) {
            cf = faces.get(i);
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(faces.get((int)i).t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            switch (cf.face) {
                case 0: {
                    os.write("vn 0 -0.1 0" + CRLF);
                    continue block20;
                }
                case 1: {
                    os.write("vn 0 0.1 0" + CRLF);
                    continue block20;
                }
                case 2: {
                    os.write("vn 0.1 0 0" + CRLF);
                    continue block20;
                }
                case 3: {
                    os.write("vn -1 0 0" + CRLF);
                    continue block20;
                }
                case 4: {
                    os.write("vn 0 0 1" + CRLF);
                    continue block20;
                }
                case 5: {
                    os.write("vn 0 0 -1" + CRLF);
                    continue block20;
                }
            }
        }
        os.write("usemtl basetexture" + CRLF);
        os.write("s 1" + CRLF);
        int index = 0;
        for (int i3 = 0; i3 < faces.size(); ++i3) {
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(faces.get((int)i3).t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            os.write("f");
            os.write(String.format(" %d/%d/%d", 4 * index + 1, 4 * index + 1, index + 1));
            os.write(String.format(" %d/%d/%d", 4 * index + 2, 4 * index + 2, index + 1));
            os.write(String.format(" %d/%d/%d", 4 * index + 3, 4 * index + 3, index + 1));
            os.write(String.format(" %d/%d/%d", 4 * index + 4, 4 * index + 4, index + 1));
            os.write(CRLF);
            ++index;
        }
        os.flush();
        outputStream.flush();
        outputStream.close();
        ImageIO.write((RenderedImage)texture, "png", new File(filePath, finalName + ".png"));
    }

    private void writeVert(OutputStreamWriter os, float x, float y, float z) throws IOException {
        String CRLF = "\n";
        os.write(String.format("v %f %f %f", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)) + CRLF);
    }
}

