/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import java.awt.Color;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPaintingTool;
import moe.plushie.armourers_workshop.api.common.painting.IPantable;
import moe.plushie.armourers_workshop.api.common.skin.cubes.ICubeColour;
import moe.plushie.armourers_workshop.client.gui.GuiColourMixer;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.init.items.paintingtool.ItemColourPicker;
import moe.plushie.armourers_workshop.common.inventory.ContainerColourMixer;
import moe.plushie.armourers_workshop.common.inventory.IGuiFactory;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeColour;
import moe.plushie.armourers_workshop.common.tileentities.AbstractTileEntityInventory;
import moe.plushie.armourers_workshop.utils.UtilColour;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityColourMixer
extends AbstractTileEntityInventory
implements IPantable,
IGuiFactory {
    private static final String TAG_ITEM_UPDATE = "itemUpdate";
    private static final String TAG_COLOUR_FAMILY = "colourFamily";
    private static final String TAG_PAINT_TYPE = "paintType";
    private static final int INVENTORY_SIZE = 2;
    public int colour = 0xFFFFFF;
    private IPaintType paintType = PaintTypeRegistry.PAINT_TYPE_NORMAL;
    private UtilColour.ColourFamily colourFamily = UtilColour.ColourFamily.MINECRAFT;
    private boolean itemUpdate;
    private boolean colourUpdate = false;

    public TileEntityColourMixer() {
        super(2);
    }

    public boolean isSpecial() {
        int meta = this.func_145832_p();
        return meta == 1;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        super.func_70299_a(i, itemstack);
        this.checkForPaintBrush();
    }

    private void checkForPaintBrush() {
        ItemStack stackInput = this.func_70301_a(0);
        ItemStack stackOutput = this.func_70301_a(1);
        if (stackInput.func_77973_b() instanceof IPaintingTool) {
            if (!stackOutput.func_190926_b()) {
                return;
            }
            this.func_70299_a(0, ItemStack.field_190927_a);
            this.func_70299_a(1, stackInput);
            if (stackInput.func_77973_b() instanceof IPaintingTool && stackInput.func_77973_b() != ModItems.COLOUR_PICKER) {
                IPaintingTool paintingTool = (IPaintingTool)stackInput.func_77973_b();
                paintingTool.setToolColour(stackInput, this.colour);
                paintingTool.setToolPaintType(stackInput, this.getPaintType(0));
            }
            if (stackInput.func_77973_b() == ModItems.COLOUR_PICKER) {
                this.setPaintType(((ItemColourPicker)stackInput.func_77973_b()).getToolPaintType(stackInput), 0);
                this.setColour(((ItemColourPicker)stackInput.func_77973_b()).getToolColour(stackInput), true);
            }
            this.func_70296_d();
        }
    }

    public void setColourFamily(UtilColour.ColourFamily colourFamily) {
        this.colourFamily = colourFamily;
        this.func_70296_d();
    }

    public UtilColour.ColourFamily getColourFamily() {
        return this.colourFamily;
    }

    @Override
    public String func_70005_c_() {
        return "colour-mixer";
    }

    public void receiveColourUpdateMessage(int colour, boolean item, IPaintType paintType) {
        this.setColour(colour, item);
        this.setPaintType(paintType, 0);
    }

    public void setColour(int colour, boolean item) {
        if (item) {
            this.itemUpdate = true;
        }
        this.colour = colour;
        this.dirtySync();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.colour = compound.func_74762_e("colour");
        this.colourFamily = UtilColour.ColourFamily.values()[compound.func_74762_e(TAG_COLOUR_FAMILY)];
        this.paintType = compound.func_74764_b(TAG_PAINT_TYPE) ? PaintTypeRegistry.getInstance().getPaintTypeFromIndex(compound.func_74762_e(TAG_PAINT_TYPE)) : PaintTypeRegistry.PAINT_TYPE_NORMAL;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("colour", this.colour);
        compound.func_74768_a(TAG_COLOUR_FAMILY, this.colourFamily.ordinal());
        compound.func_74768_a(TAG_PAINT_TYPE, this.paintType.getId());
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeBaseToNBT(compound);
        compound.func_74768_a("colour", this.colour);
        compound.func_74768_a(TAG_PAINT_TYPE, this.paintType.getId());
        compound.func_74757_a(TAG_ITEM_UPDATE, this.itemUpdate);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.itemUpdate) {
            this.itemUpdate = false;
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.readBaseFromNBT(compound);
        this.colour = compound.func_74762_e("colour");
        this.paintType = PaintTypeRegistry.getInstance().getPaintTypeFromIndex(compound.func_74762_e(TAG_PAINT_TYPE));
        this.itemUpdate = compound.func_74767_n(TAG_ITEM_UPDATE);
        this.syncWithClients();
        this.colourUpdate = true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getHasItemUpdateAndReset() {
        if (this.itemUpdate) {
            this.itemUpdate = false;
            return true;
        }
        return false;
    }

    @Override
    public int getColour(int side) {
        return this.colour;
    }

    @Override
    public ICubeColour getColour() {
        return new CubeColour(this.colour);
    }

    @Override
    @Deprecated
    public void setColour(int colour) {
        this.setColour(colour, false);
    }

    @Override
    public void setColour(byte[] rgb, int side) {
        this.setColour(new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF).getRGB(), false);
    }

    @Override
    @Deprecated
    public void setColour(int colour, int side) {
        this.setColour(colour, false);
    }

    @Override
    public void setColour(ICubeColour colour) {
    }

    @Override
    public void setPaintType(IPaintType paintType, int side) {
        this.paintType = paintType;
        this.dirtySync();
    }

    @Override
    public IPaintType getPaintType(int side) {
        return this.paintType;
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new ContainerColourMixer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new GuiColourMixer(player.field_71071_by, this);
    }
}

