/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.world;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.common.init.blocks.BlockSkinnable;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnable;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnableChild;
import moe.plushie.armourers_workshop.common.world.AsyncWorldUpdateBlock;
import moe.plushie.armourers_workshop.common.world.SyncWorldUpdater;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.UtilPlayer;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockSkinPlacementHelper {
    private BlockSkinPlacementHelper() {
    }

    public static boolean placeSkinAtLocation(World world, EntityPlayer player, EnumFacing sidePlacedOn, ItemStack stack, BlockPos pos, ISkinDescriptor descriptor) {
        IBlockState replaceBlock;
        Skin skin;
        if (descriptor != null && descriptor.getIdentifier().getSkinType() == SkinTypeRegistry.skinBlock && (skin = SkinUtils.getSkinDetectSide(descriptor, false, true)) != null && (replaceBlock = world.func_180495_p(pos.func_177972_a(sidePlacedOn))).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177972_a(sidePlacedOn))) {
            return BlockSkinPlacementHelper.placeSkinAtLocation(world, player, sidePlacedOn, stack, pos.func_177972_a(sidePlacedOn), skin, descriptor);
        }
        return false;
    }

    public static boolean placeSkinAtLocation(World world, EntityPlayer player, EnumFacing sidePlacedOn, ItemStack stack, BlockPos pos, Skin skin, ISkinDescriptor descriptor) {
        if (!BlockSkinPlacementHelper.canPlaceSkinAtLocation(world, player, sidePlacedOn, stack, pos, descriptor)) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        EnumFacing dir = UtilPlayer.getDirectionSide(player).func_176734_d();
        BlockSkinnable targetBlock = (BlockSkinnable)ModBlocks.SKINNABLE;
        if (SkinProperties.PROP_BLOCK_GLOWING.getValue(skin.getProperties()).booleanValue()) {
            targetBlock = (BlockSkinnable)ModBlocks.SKINNABLE_GLOWING;
        }
        boolean multiblock = SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skin.getProperties());
        ArrayList<BlockPos> relatedBlocks = new ArrayList<BlockPos>();
        if (multiblock) {
            if (!BlockSkinPlacementHelper.canPlaceChildren(world, player, sidePlacedOn, stack, pos, skin, descriptor, relatedBlocks)) {
                return false;
            }
            BlockSkinPlacementHelper.placeChildren(world, player, sidePlacedOn, pos, skin, descriptor, relatedBlocks);
        }
        IBlockState state = targetBlock.func_176223_P().func_177226_a((IProperty)BlockSkinnable.STATE_FACING, (Comparable)dir);
        TileEntitySkinnable te = new TileEntitySkinnable();
        te.setSkinPointer(skin, descriptor);
        te.setRelatedBlocks(relatedBlocks);
        SyncWorldUpdater.addWorldUpdate(new AsyncWorldUpdateBlock(state, pos, world).setTileEntity(te).setDelay(1));
        stack.func_190918_g(1);
        SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
        world.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        return true;
    }

    private static boolean canPlaceSkinAtLocation(World world, EntityPlayer player, EnumFacing sidePlacedOn, ItemStack stack, BlockPos pos, ISkinDescriptor descriptor) {
        if (!player.func_175151_a(pos, sidePlacedOn, stack)) {
            return false;
        }
        if (stack.func_190916_E() == 0) {
            return false;
        }
        if (!world.func_175701_a(pos)) {
            return false;
        }
        return world.func_190527_a(world.func_180495_p(pos).func_177230_c(), pos, true, sidePlacedOn, (Entity)player);
    }

    private static boolean canPlaceChildren(World world, EntityPlayer player, EnumFacing sidePlacedOn, ItemStack stack, BlockPos pos, Skin skin, ISkinDescriptor descriptor, ArrayList<BlockPos> relatedBlocks) {
        EnumFacing dir = UtilPlayer.getDirectionSide(player).func_176734_d();
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    float[] bounds = TileEntitySkinnable.getBlockBounds(skin, -ix + 2, iy, iz, dir);
                    if (bounds == null) continue;
                    BlockPos childPos = pos.func_177982_a(ix - 1 - dir.func_82601_c() * 1, iy, iz - 1 - dir.func_82599_e() * 1);
                    relatedBlocks.add(childPos);
                    IBlockState replaceState = world.func_180495_p(childPos);
                    if (replaceState.func_177230_c().func_176200_f((IBlockAccess)world, childPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void placeChildren(World world, EntityPlayer player, EnumFacing sidePlacedOn, BlockPos pos, Skin skin, ISkinDescriptor descriptor, ArrayList<BlockPos> relatedBlocks) {
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    BlockSkinPlacementHelper.placeChild(world, player, sidePlacedOn, pos, ix, iy, iz, skin, descriptor, relatedBlocks);
                }
            }
        }
    }

    private static void placeChild(World world, EntityPlayer player, EnumFacing sidePlacedOn, BlockPos pos, int ix, int iy, int iz, Skin skin, ISkinDescriptor descriptor, ArrayList<BlockPos> relatedBlocks) {
        float[] bounds;
        EnumFacing dir = UtilPlayer.getDirectionSide(player).func_176734_d();
        BlockSkinnable targetBlock = (BlockSkinnable)ModBlocks.SKINNABLE_CHILD;
        IBlockState state = targetBlock.func_176223_P().func_177226_a((IProperty)BlockSkinnable.STATE_FACING, (Comparable)dir);
        if (SkinProperties.PROP_BLOCK_GLOWING.getValue(skin.getProperties()).booleanValue()) {
            targetBlock = (BlockSkinnable)ModBlocks.SKINNABLE_CHILD_GLOWING;
        }
        if ((bounds = TileEntitySkinnable.getBlockBounds(skin, -ix + 2, iy, iz, dir)) != null) {
            BlockPos childPos = pos.func_177982_a(ix - 1 - dir.func_82601_c() * 1, iy, iz - 1 - dir.func_82599_e() * 1);
            world.func_180501_a(childPos, state, 2);
            TileEntitySkinnableChild te = new TileEntitySkinnableChild();
            te.setSkinPointer(skin, descriptor);
            te.setParentLocation(pos);
            te.setRelatedBlocks(relatedBlocks);
            world.func_175690_a(childPos, (TileEntity)te);
        }
    }
}

